% *************************************************************************************************************************************
% 
% Program :  Computes the aggreagated infinite population model for a number of gamma
% Author  :  S.Y. Yuen   
% Version :  21st Feb 2005
%
%

% INPUT PARAMETERS
% *************************************************************************************************************************************

% reset
clear;clc;close all;

disp ('Note: ');
disp ('1. This program may allow zero fitness value, but will fail if the fitness landscape is a plane of zero fitness');
disp ('2. All fitness values must be non-negative');
disp ('3. Please transform manually your fitness function to the form where (1 ... 1) is the optimal solution first');
disp ('4. The program can handle special cases like mutation rate and/or crossover rate = 0');
disp (' ');

disp ('choice  = 1  -  aggregated infinite population models only');
choice = 1;
disp (' ');

% input the variables
disp ('EA parameters');
%mu        = input ('bit mutation rate                           = ');
%chi_mu    = input ('bit crossover rate for uniform crossover    = ');
%no_of_gen = input ('no. of generations (>=1, gen. 0 is the initial generation) = ');

chi_mu = 0.6
no_of_gen = 100
mu = 0.01

disp ('fitness function');
disp ('1         -  counting one          ');
disp ('2         -  linear (or modular)   ');
disp ('3         -  pseudo modular        ');
disp ('4         -  almost positive       ');
disp ('5         -  real royal road       ');
disp ('6         -  crude average version of 3. pseudo modular ');

functype=input       ('choose fitness function number (1-6)        = ');
if functype == 2 % If choose the set of funciton 2, choose the sub-function of type 2 for different Ci
   disp ('1         -   ci = i     for function 2');
   disp ('2         -   ci = 2^i                 ');
   disp ('3         -   ci = 2^(-i)              ');
   
   functype2=input('choice            = ');  

   if choice < 1 | choice > 3
      disp ('FATAL ERROR !  Invalid choice.');
   end

end
disp (' ');

gamma_set = [5 10 20];
disp ('gamma = 5 10 20');

disp (' ');

disp ('random noise = 0  (no random noise)');
randamp = 0;
disp (' ');

ave_choice = 0;

for trial_no = 1:length(gamma_set)
tic
    
gamma = gamma_set(trial_no);
disp (gamma);


%disp ('random number state');
%rand('state')

% FITNESS LANDSCAPE AND FITNESS UPPER AND LOWER BOUNDS 
% *************************************************************************************************************************************

W             = 2^gamma;      % search space size
optimal_index = W;            % the optimal index is the integer index of the binary vector of (1 ... 1). Here 1 means a correct bit
                              % and 0 means an incorrect bit

% aggregated infinite population model
upbound  = ones (1, gamma+1);  % fitness upper bound of each ring
lowbound = ones (1, gamma+1);  % fitness lower bound of each ring

% generate fitness bound of each ring

% ** calculate lower and upper bound analytically **
for ii=1:gamma+1
    
    switch functype
            case 1
                lowbound(ii)=(ii-1);     % fitness = 0 for ring 0
                upbound (ii)=(ii-1);
            case 2
                switch functype2
                    case 1
                        lowbound(ii)=(ii-1)*(ii)/2;                  % fitness = 0 for ring 0
                        upbound (ii)=(ii-1)*(2*gamma-(ii-1)+1)/2;        
                    case 2
                        lowbound(ii)=2*(2^(ii-1)-1)+1;           
                        upbound(ii) =2^(gamma-(ii-1)+1)*(2^(ii-1)-1)+1;
                    case 3
                        lowbound(ii)=2^(-(gamma-(ii-1)))*(1-2^-(ii-1))+1; 
                        upbound(ii) =1-2^(-(ii-1))+1;
                end
            case 3
                if(ii~=gamma+1)
                    lowbound(ii)=0;             % fitness can be 0
                    upbound(ii)=ii-1;
                else
                    lowbound(ii)=gamma;
                    upbound(ii)=gamma;
                end
            case 4
                if(ii~=gamma+1)
                    lowbound(ii)=gamma-ii+1;
                else
                    lowbound(ii)=gamma+1;
                end
                upbound(ii)= lowbound(ii);
            case 5
                tao=round(gamma/2);
                if(ii-1<=gamma-tao) | ii-1==gamma
                    lowbound(ii)=tao+ii-1;
                else
                    lowbound(ii)=gamma-(ii-1);
                end
                upbound(ii)= lowbound(ii);
            case 6                                      %  created to approx. 3
                if(ii~=gamma+1)
                    lowbound(ii)=0 + ii-1;            
                    lowbound(ii)=lowbound(ii)/2;
                    upbound (ii)=lowbound(ii);  
                else
                    lowbound(ii)=gamma;
                    upbound(ii)=gamma;
                end
 
    end
end     


lowbound
upbound


disp ('do not normalize');
%lowbound      =lowbound/(max(lowbound)); 
%upbound       =upbound/(max(upbound));



% INFINITE POPULATION MODEL 
% *************************************************************************************************************************************


% AGGREGATED MODEL (infinite population model)
% ***********************************************************************************************

% initialize probability
R_p_ini    =zeros(1,gamma+1); % probability vector of ring in infinite population model
R_lowbound =zeros(1,gamma+1); % lower bound probability vector of ring in infinite population model
R_upbound  =zeros(1,gamma+1); % upper bound probability vector of ring in infintie population model

ring_num = [];
for i = 1:gamma+1
    ring_num = [ring_num nchoosek(gamma, i-1)];
end

R_p_ini    = ring_num/W;      % equally distributed
R_lowbound = R_p_ini;
R_upbound  = R_p_ini;

% generate mixing matrix Agg_M based on independent equally liklihood model
Agg_M=Agg_getmatrixM(gamma,mu,chi_mu);

% Agg_M

% initialize the expected probability of optimal chromosome in infinite population model
infi_low_EP(trial_no, 1)=R_p_ini(gamma+1); % Note: index 1 means the initial generation, or generation 0
infi_up_EP(trial_no, 1) =R_p_ini(gamma+1);

% these two parameters are to compute the normalization factor of each generation of low
% bound and up bound to prevent numerical instability
factor1=1;
factor2=1;

for iter=1:no_of_gen
    
    % begin aggregated model
    R_lowbound=lowbound.*R_lowbound;
    R_upbound=upbound.*R_upbound;

    p_all=reshape((R_lowbound'*R_lowbound)',(gamma+1)^2,1);
    R_lowbound=(Agg_M*p_all)';

    p_all=reshape((R_upbound'*R_upbound)',(gamma+1)^2,1);
    R_upbound=(Agg_M*p_all)';
    
    factor1= factor1*(sum(R_lowbound)/sum(R_upbound))^2;
    factor2= factor2*(sum(R_upbound)/sum(R_lowbound))^2;

    R_lowbound = R_lowbound/sum(R_lowbound);
    R_upbound = R_upbound/sum(R_upbound);
    
    % current generation's expected probability
    infi_low_EP(trial_no, iter+1)= R_lowbound(gamma+1)/ (R_lowbound(gamma+1)+factor2*sum(R_upbound(1:gamma)));
    infi_up_EP (trial_no, iter+1)= R_upbound(gamma+1) / (R_upbound(gamma+1) +factor1*sum(R_lowbound(1:gamma)));  
    % end of aggregated model
    
end

disp ('aggregated Infinite Population Model finished');
disp (' ');

toc

time_log (trial_no) = toc;
disp (['time = ', num2str(toc)]);
end   % for trial_no

% DISPLAY - INFINITE POPULATION MODEL
% ***********************************************************************************************

% plot the expected probability of optimal chromosome
figure; hold on;


%title ('Expected prob./ infinite population model');
xlabel('generation'); ylabel('probability');

%gamma_set = [5 10 20 40];

x = 0:no_of_gen;

%plot(x, infi_up_EP (1,:), 'k-');
plot(x, infi_low_EP(1,:), 'k-');
%plot(x, infi_up_EP (2,:), 'k--');
plot(x, infi_low_EP(2,:), 'k--');
%plot(x, infi_up_EP (3,:), 'k:');
plot(x, infi_low_EP(3,:), 'k:');
%plot(x, infi_up_EP (4,:), 'k-.');
%plot(x, infi_low_EP(4,:), 'k-.');
   
legend('gamma = 5', 'gamma = 10', 'gamma = 20', 0); 

for iter = 1:3
    infi_up_EP (iter,:)
    infi_low_EP(iter,:)
end
    
time_log(1)
time_log(2)
time_log(3)
   
hold off
