function M = Agg_getmatrixM(gamma,mu,chi_mu)
% 
% Function : Calculate the aggregated matrix M  
%            It implements  eqn (21) and APPENDIX 1 of our paper
%
% 
% Input  Parameters :  mu      bit mutation rate (uniform mutation)
%                      chi_mu  bit crossover rate (uniform crossover)
%                      gamma   chromosome length
% Output Parameters :  (gamma+1) x (gamma+1)^2 matrix M 
%
% Updated  : 30 Oct 2004

mc=zeros(gamma+1,(gamma+1)^2);      % (gamma+1) x (gamma+1)^2 crossover matrix
mm=zeros(gamma+1);                  % (gamma+1) x (gamma+1)   mutation  matrix

for ii=1:gamma+1
    for jj=1:gamma+1
         % caution : ii-1 since matlab starts from 1 rather than 0
         mm(ii,jj)= computeM_m(ii-1,jj-1,gamma,mu); %  mutation probability from ring (jj-1) to ring (ii-1)
         for kk=1:gamma+1
             mc(kk,(ii-1)*(gamma+1)+jj)=computeM_c(ii-1,jj-1,kk-1,gamma,chi_mu);
         end
     end
 end
M=mm*mc;


        
function m_m=computeM_m(y,x,gamma,mu)
% implements eqn (21) of our paper
m_m=0;
for a=0:x
    if y-x+a<0 | y+a>gamma
     continue;
    end
     m_m=m_m+nchoosek(x,a)*nchoosek(gamma-x,y-x+a)*mu^(y-x+2*a)*(1-mu)^(gamma-(y-x+2*a));
end


function m_c=computeM_c(x,y,k,gamma,chi_mu)
% implements Appendix 1 of our paper
m_c=0;

if(k>(x+y) | k<x+y-gamma)      % conservation law of correct bits
    return;
end
 lowm=x+y-gamma;     % minimum number of overlapping bits
 if lowm<0 
     lowm=0;
 end 

if(k>=x)
    for m=lowm:min(x,y)              % m is the number of overlapping bits
        
        petaxym = factorial(gamma-x)*factorial(gamma-y)*factorial(x)*factorial(y)./(factorial(gamma)*factorial(x-m)...
                *factorial(y-m)*factorial(gamma-x-y+m)*factorial(m));
            
        for ta=0:x-m
            if( k-x+ta>y-m)
                continue;
            end
          m_c = m_c +  nchoosek(x-m,ta)*nchoosek(y-m,k-x+ta)*chi_mu.^(2*ta+k-x)*(1-chi_mu)^(2*x-2*m-2*ta+y-k)*petaxym;
                
        end
    end
else
   for m=lowm:min(x,y)
       
        petaxym =  factorial(gamma-x)*factorial(gamma-y)*factorial(x)*factorial(y)./(factorial(gamma)*factorial(x-m)...
                *factorial(y-m)*factorial(gamma-x-y+m)*factorial(m));  
       
        for tb=0:y-m
            if(x-k+tb<0 | x-k+tb>x-m)
                continue;
            end
            m_c = m_c + nchoosek(y-m,tb)*nchoosek(x-m,x-k+tb)*chi_mu.^(x-k+2*tb)*(1-chi_mu)^(y+k-2*m-2*tb)*petaxym;
               
        end
    end
end
% if(k~=(x+y)/2) m_c=m_c/2;end

