function ArbitraryLandscape(Fitnessfilename, gamma)

W = 2^gamma;

%============ Load the fitness landscape
fitness = zeros(1, W);
cvtfitness = zeros(1, W);
fid = fopen(Fitnessfilename, 'r');
for i = 1: W
    fitness(1, i) = fscanf(fid, '%f', 1);
end
fclose(fid);

%============ Internal Testing
% gramma = 14;
% W = 2^gramma;
% fitness = rand(1, W);

%============ Search the Global Optimum
[max_fitness, max_index] = max(fitness);
max_key = bitcmp(max_index - 1, gamma);

Li = ones(1, gamma + 1) * NaN;
Ui = ones(1, gamma + 1) * NaN;

%============ Determine the Li and Ui of the ith ring
for i = 1:W
    cvt_index = bitxor(i - 1, max_key);
    cvtfitness(1, cvt_index + 1) = fitness(1, i);
    
    hamming_dist = dec2bin(cvt_index, gamma);
    ring_index = sum(hamming_dist) - 48*length(hamming_dist) + 1;
    
    if isnan(Li(1, ring_index)) == 1 | Li(1, ring_index) > fitness(1, i)
        Li(1, ring_index) = fitness(1, i);
    end

    if isnan(Ui(1, ring_index)) == 1 | Ui(1, ring_index) < fitness(1, i)
        Ui(1, ring_index) = fitness(1, i);
    end
end

Li
Ui

%============ Write the converted fitness to 'cvtFitnessfilename'
fid = fopen('cvtlandscape', 'w');
for i = 1: W
    fprintf(fid, '%f\n', cvtfitness(1, i));
end
fclose(fid);

%============ Write the Li and Ui to 'LBdfilename'
fid = fopen('LUBound', 'w');
for i = 1: gamma + 1
    fprintf(fid, '%f %f\n', Li(1, i), Ui(1, i));
end
fclose(fid);

