gamma    = input ('chromosome length                       = ');
poolsize = input ('population pool size                    = ');
W     = 2^gamma;

tic

posval = 0:gamma-1;             % bit positions           
posval = 2.^posval;             % bit position values
posval = perms (posval);        % all permutations of values of bit positions

b = [];
for ii=1:W                      % W = 2^gamma
    a=dec2bin (ii-1, gamma);
    a=str2num (a(:));
    b = [b a];
end                             % listing of all binary patterns.  There are 2^gamma of them

per_index = posval * b + ones (size(posval, 1), W);        % permutations in terms of decimal values 

no_per    = size(posval, 1);    % no. of such permutations
 
Z = generateZ(poolsize,W);    % generate combination(poolsize+W-1, poolsize) x W matrix of all possible finite populations

curr_label = 1;
label     = zeros (size(Z, 1), 1);

for i=1:size(Z, 1)
    if label(i) == 0
       label(i)   = curr_label;
       labelp(curr_label).size   =1;
       labelp(curr_label).pattern=Z(i,:);
          
       per_form = gen_permutation (Z (i,:), per_index, no_per, W);
       
       for j=i+1:size(Z, 1)
           if oneof_per ( Z(j,:), per_form, no_per, W) 
              label(j) = curr_label;
              labelp(curr_label).size = labelp(curr_label).size+1;
           end
       end
       
       curr_label = curr_label+1;
    end
end

no_label = curr_label-1;

csvwrite ( ['label', num2str(gamma), '_', num2str(poolsize)], label );

disp (['time to compute the permutation indices = ', num2str(toc)]);