function F = generateF(X,gamma,functype)

% X is a column vector; the first row is the most significant bit, the last row is the least significant bit

 switch functype
  case 1 
      F=sum(X);
  case 3
        zeroindex=find(X==0);
        if(length(zeroindex)>0)
           F=gamma - zeroindex(length(zeroindex));   % the second term on RHS is the position of the LSB that is zero 
        else
           F=gamma;
        end
  case 4
      n=sum(X);
      if n == gamma 
          F= gamma-n+(gamma+1);
      else
          F=gamma-n;
      end
  case 5
      tao=round(gamma/2);
       n=sum(X);
      if n <= gamma-tao | n==gamma
          F=tao+n;
      else
          F=gamma-n;
      end   

  otherwise
      disp('! Fatal Error : Unknown fitness function.')
end 
