function F  = generateF2(X,gamma,functype2)

% X is a column vector; the first row is the most significant bit, the last row is the least significant bit
% 
% funcytpe2 = 1 Ci=i
% functype2 = 2 Ci=2^i
% functype2 = 3 Ci=2^-i

 switch functype2
  case 1 
      c=gamma:-1:0;
  case 2
      c=gamma:-1:0;
      c=2.^c;
  case 3
      c=-gamma:1:0;
      c=2.^c;
end

 
F  =c(length(c))+sum(c(1:length(c)-1)'.*X);   % c(length(c)) is c0
