function M = generateM(mu, chi_mu, gamma )
% 
%  Compute M, the mixing matrix of the Vose-Liepins' infinite population model
%  The entries of M are rij(0)
%
%  Input parameters :  mu         bit mutation rate (uniform mutation)
%                      chi_mu     bit cross over rate (uniform crossover)
%                      gamma      chromosome length 
%  Output parameters: square matrix M
%  

M = zeros(2.^gamma);

for i=1:size(M,1)
    for j=i:size(M,2)
        % i,j should be [0 2.^gamma-1] so when use M  should pay attention to the index 
        M(i,j)=calculate_rij(i-1,j-1,mu,chi_mu,gamma); % compute rij(0)
        M(j,i)=M(i,j);                                 % because the matrix is symmetric
    end
end

