function Z = generateZ(poolsize,W)
% Calculate Z
% It is a combinatorial problem and  Matlab has a convenient command 'nchoosek'   
% But we need to adapt it to our problem 

% e.g W=16,poolsize=5 
% nz=[3 4 17 19 20]
%                                        |
% 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 | 17 18 19 20
%     1  1                                  1  0   1  1
%
% I use 17 18 19 20 as a code and decode it by the position of 0 
% In this case 
% It tells us '3' must repeat '1' more time '4' must repeat 2 more times
% becase there are '0's dividing the 17-20 into 2 parts 
% so the final Z is 
% 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16
%     2 3

nz=nchoosek(1:poolsize+W-1,poolsize);
Z=zeros(size(nz,1),W);
for i=1:size(nz,1)
    Z(i,:)=decodenz(nz(i,:),poolsize,W);
end


