% An Example of UE-ABC

    addpath(genpath('..\'))
    load('UE_ABC','xmin','set')
    [dd,pps] = size(xmin);
    if dd~=set.nGauss*(set.d+2)
        error('Check #1 in ''feval_prob.m'' ... ');
    else
        rot = zeros(set.nGauss,1);  %% No Rotation in Current Work %
    end
    % ----- X-to-Config ----- %
    if set.nGauss < 100
        sig(:,1) = xmin(1:set.nGauss,1);
        sqz      = reshape(xmin(set.nGauss+1:set.nGauss*(set.d+1),1),set.nGauss,set.d);
        rat(:,1) = xmin(set.nGauss*(set.d+1)+1:set.nGauss*(set.d+2)-1);
        rs       = xmin(dd,1);  %% Random Seed
    else
        sig(:,1) = xmin(1:nGauss,1);
        rat(:,1) = xmin(nGauss+1:nGauss*2-1);
        rs       = xmin(dd,1);  %% Random Seed
        sqz = 0;
    end
    % ----- X-to-Config ----- %
    rand('seed',rs);
    Lfbest = glg06_init(set.d,set.nGauss,set.ub,set.lb,set.gbf,sig,rot,sqz,rat);    
    %glg06_plot(set.ub,set.lb,100)
    
    disp('The UE-ABC instance is generated. ')
    disp('The figure gives the 1st and 2nd dimension to the fitness value, which is for reference only.')
    disp('Next, try to generate a solution, e.g., x = (set.ub-set.lb).*rand(1,10) + set.lb; ')
    disp('and then, calculate it fitness by f = glg06_fit(x)')
    save('afterRe.mat')
    
    
    