% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Source Code for Y.Lou S.Y.Yuen, and G.Chen, "Evolving Benchmark
% Functions Using Kruskal-Wallis Test," In: Proc. Genetic and
% Evolutionary Computation Conference (GECCO 2018)
% doi: 10.1145/3205651.3208257, 2018.
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Four Algorithms = {'ABC'; 'CoDE'; 'NBiPOP-CMAES';}
%       1. ABC
%       2. CoDE
%       3. NBiPOP-CMA-ES
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Copyright (c) 2018 Yang Lou, Shiu Yin Yuen and Guanrong Chen 
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions
% are met: 
% 
% 1. Redistributions of source code must retain the above copyright
%    notice, this list of conditions and the following disclaimer. 
% 2. Redistributions in binary form must reproduce the above copyright
%    notice, this list of conditions and the following disclaimer in
%    the documentation and/or other materials provided with the 
%    distribution.
% 
% This software is provided by the copyright holders and contributors
% "as is" and any express or implied warranties, including, but not 
% limited to, the implied warranties of merchantability and fitness
% for a particular purpose are disclaimed. In no event shall the
% copyright owner or contributors be liable for any direct, indirect,
% incidental, special, exemplary, or consequential damages (including,
% but not limited to, procurement of substitute goods or services;
% loss of use, data, or profits; or business interruption) however
% caused and on any theory of liability, whether in contract, strict
% liability, or tort (including negligence or otherwise) arising in
% any way out of the use of this software, even if advised of the
% possibility of such damage.
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Updated: 15-04-2018 version 2 (3EA_UE+UD)
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %

clearvars; clc;
global arXiv;
global fMat;
global fit;

disp('Settings for component EAs ...')
disp('Generate Uniquely-Easy or Uniquely-Difficult Problem?')
ueud = input('(1) UE, (2) UD: ');
if ueud == 1
    disp('Generate UE Problem for which EA?')
elseif ueud == 2
    disp('Generate UE Problem for which EA?')
end
p_idx = input('(1) ABC, (2) CoDE, (3) NBiPOPCMAES(CMA): ');
TM = p_idx+(ueud-1)*3;
nGauss = input('Number of Modals (Local Optima), (e.g.,5): ');
Dim = input('Problem Dimension, (at minimum 2, e.g.,10): ');
Rept = input('Number of Repeated Runs, (e.g.,20): ');

addpath(genpath('algorithms'))
% ----- >> Set Here -----  -----  ----- %
BM = 2;  %% BenckMark - ID (1-For-CEC || 2-For-GLG)
BenchMarks = {'cec2013'; 'glg06';};
Algorithms = {'abc'; 'code'; 'nbicma'};
TestMode   = {'abcs';'cods';'cmas';'abci';'codi';'cmai';};
NEA        = length(Algorithms);
ProbSet    = BenchMarks{BM};
fmode      = TestMode{TM};
disp(['BenchMark(',ProbSet,') || TestMode(', fmode, ') ... ']);

switch ProbSet
    case 'glg06'
        % ----- >> Gaussian Landscape Paras ----- %
        % To save time, we use small search space for conference version.
        % Search space could be changed to any value.
        set = struct( ...	%% Gaussian Benchmark Setting
                    'nGauss',	nGauss,	...
                    'd',        Dim,	...
                    'gbf',      1,      ... 
                    'ub',       1,      ...
                    'lb',       -1      ...
                    );
        set.sigb.ub = (set.ub-set.lb)/10;  %% Note "set.ub" & "set.sigb.ub" Different
        set.sigb.lb = 1E-9;
        set.maxfes  = min(500*set.d*set.nGauss,5E4);
        % Set a small MAXFES to save time, any MAXFES is OK
end

%% -----  -----  -----| Generating New Instances |-----  -----  ----- %%
if strcmp(ProbSet,'glg06')
    % Use Differential Evolution to Evolve Instance in Gaussian Landscapes
    D  = set.nGauss*(set.d+2);
        % (nGauss,1)	>> Sigma
        % (nGauss,d)	>> Squeeze
        % (nGauss-1,1)	>> Ratio
        % Plus a Random Seed 'rs', (nGauss,d+2) in Total
    F  = 0.85;
    CR = 0.5;       %% Para Setting: http://www1.icsi.berkeley.edu/~storn/code.html
    psDE  = 20;     %% 40 (Note: psDE>3, for DE-Rand/Bin/1)
    MAXFE = 1000;	%% 4000;
    % -----  -----  -----  -----  ----- 
% %     if (1)
% %         Rept = 2;
% %         psDE = 3;
% %         MAXFE= 6;
% %     end
    % -----  -----  -----  -----  ----- 
    MAXG = MAXFE/psDE;
    disp('Using Gaussian Landscape Generator to Evolve New Benchmark Instances: ')
    disp(['>> nGauss(',int2str(set.nGauss),');  Dim(',int2str(set.d),');  Repeat(',int2str(Rept),') ...'])
    disp(['   PopSize(',int2str(psDE),');  MaxFEs_DE(',int2str(MAXFE),') ...'])
    if psDE < 3
        error('Population Size of Differential Evolution Should be Greater Than 3, for Mutation Purpose.')
    end
    % ----- Initialization ----- %
    % Note Size(x_DE)	 = D-by-psDE;
    %      Size(x_Gauss) = ps-by-d;
    x = zeros(D,psDE);	%% Configuration (Paras) of Benchmark Instances
    f = cell(psDE,1);	%% Fitness of Benchmark Instances
    g = 1;  disp(['Initializing (Gen.',int2str(g),') ...'])
    fmat = cell(psDE,1);  rs = zeros(psDE,1);  fbias = zeros(psDE,1);
    for idx = 1:psDE  %% Initialize All Solutions, Eight Pops. %
        % ----- Config-to-X ----- %
        sig = set.sigb.lb+rand(set.nGauss,1)*(set.sigb.ub - set.sigb.lb);	% (nGauss,1)	>> Sigma
        sqz = reshape(rand(set.nGauss,set.d),set.nGauss*set.d,1);           % (nGauss,d)	>> Squeeze
        rat = rand(set.nGauss-1,1);                                         % (nGauss-1,1)	>> Ratio
        rs  = randi(2^40-1);  % IMAX Less Than 2^53
        % ----- Config-to-X ----- %
        x(1:D,idx) = [sig;sqz;rat;rs];
        [f{idx,1},fmat{idx},fbias(idx)] = feval_prob_h(ProbSet,set,x(:,idx),Rept,fmode);
    end
    % ----- Update Current Best ----- %
    [fmin,xmin,dx] = find_best(f,x);
    fmin_mat = fmat{dx};    %% Fit of EAs Under Best Configuration
    % ----- arXiv Initialization & Insertion ----- %
    [arXiv,nNode,fMat,fit,nFmat] = arXiv_init(D,MAXFE);  %% Was: [arXiv,nNode,fMat,nFmat] = arXiv_init(D,MAXFE);
    % Note "fMat = cell(cell(MAXFE,2)" and "fit = cell(mfe,2)". %
    [nNode,nFmat] = arXiv_in(x,f,nNode,fmat,nFmat,fbias);
    fmin
    while (g < MAXG)&&(fmin.f > 0.001)  %%(fmin > 1E-12)
        % NOTE: in HFEBG-H, the stop criteria fmin.f could be much greater than HFEBG
        % Recommended: HFEBG-H (0.05); HFEBG (1E-10)
        g = g+1;
        disp(['Running Gen.',int2str(g),' ...'])
        % ----- Generate Offspring ----- %
        u = zeros(D,psDE);
        for idx = 1:psDE
            i = randperm(psDE);            
            i = i(1:3);  %% psDE > 3
            v = x(:,i(1))+F*(x(:,i(2))-x(:,i(3)));
            cr = rand(D,1)>CR;
            u(:,idx) = cr.*v + (~cr).*x(:,idx);
        end
        u = bound_check(u,set.nGauss,set.sigb);  %% Sigb is Bounds of Sigma
        % ----- arXiv Revisit Check ----- %
        u = arXiv_check(u,set.lb,set.ub);
        fmat = cell(psDE,1);  fu = cell(psDE,1);
        for idx = 1:psDE  %% Evaluate One after Another
            %%[fu(idx,1),fmat{idx},fbias(idx)] = feval_prob_h(ProbSet,set,u(:,idx),Rept,fmode);
            [fu{idx},fmat{idx},fbias(idx)] = feval_prob_h(ProbSet,set,u(:,idx),Rept,fmode);
            % ----- Tournament Selection ----- %
            [f{idx},pdx] = tour_sele(fu{idx},f{idx}); 
            if pdx == 1  %% Meaning 'fu{idx}' is Better
                x(:,idx) = u(:,idx);
            end  %% {x,f} is the next-generation-population
        end
        [nNode,nFmat] = arXiv_in(u,fu,nNode,fmat,nFmat,fbias);  %% U -> arXiv, No Matter Better or Not
        % ----- Update Current Best ----- %
        [fmin,xmin,dx] = find_best(f,x);
        fmin_mat = fmat{dx};    %% Fit of EAs Under Best Configuration
        clear fmat
        fmin
    end
    if ueud == 1
        prx = 'UE';
    elseif ueud == 2
        prx = 'UD';
    end
    % save all information
    fname = ['H_all_N',int2str(set.nGauss),'D',int2str(set.d), ...
             prx,TestMode{TM}(1:3),'.mat'];
    save(fname)
    % save only the required problem instance
    fname = ['H_bestInst_N',int2str(set.nGauss),'D',int2str(set.d), ...
             prx,TestMode{TM}(1:3),'.mat'];
    save(fname,'xmin')
    
end
