% Downloaded - http://mf.erciyes.edu.tr/abc/ (Accessed Date: 14-12-2016)
% Remarks - ABC version 2, released on 14-12-2009
% Ref.Article: D.Karaboga,B.Basturk,"A powerful and Efficient Algorithm for 
% Numerical Function Optimization: Artificial Bee Colony (ABC) Algorithm," 
% Journal of Global Optimization,39(3),2007:459-171,doi:10.1007/s10898-007-9149-x
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Slightly Modified by Felix (Felix.lou@my.cityu.edu.hk)
% 1. To fit the Gaussian Landscape Benchmarks as the testsuite;
% 2. To collect the data to form convergence curve (Variable Name - cv)
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Updated: 03-01-2017

function [fmin] = run_abc(ProbSet,fn,d,ps,lbin,ubin,maxfes)

    NP = ps;  %% Population size  = employed bees + onlooker bees) %
    xNum = NP/2; %% Food -> x; FoodNumber -> xNum %
    limit = 100;  %/*A food source which could not be improved through "limit" trials is abandoned by its employed bee*/
    D = d;  %/*The number of parameters of the problem to be optimized*/
    if isscalar(lbin) && isscalar(ubin)
        ub = ones(1,D)*ubin;  %/*lower bounds of the parameters. */
        lb = ones(1,D)*lbin;  %/*upper bound of the parameters.*/
    else
        ub = ubin;
        lb = lbin;
    end
    Range = repmat((ub-lb),[xNum,1]);
    Lower = repmat(lb,[xNum,1]);
    x = rand(xNum,D).*Range+Lower;  %% Size: PopSize-by-Dimension
    f = fit_eval(x,ProbSet,fn);
    fes = ps;
    abc_fit = abc_fitness(f);
    trial = zeros(1,xNum);  %% Reset trial counters

    %/*The best food source is memorized*/
    [fmin,pos] = min(f);
    xmin = x(pos,:);
    %cv = fmin;

    while fes <= maxfes
        % -----  ----- EMPLOYED BEE PHASE  -----  ----- %
        for i = 1:(xNum)
            Param2Change = randi(D);  %% Parameter to change is determined randomly
            neighbour = randi(xNum);  %% Randomly chosen solution
            while neighbour == i
                neighbour = randi(xNum);
            end
            sol = x(i,:);
            % v_{ij}=x_{ij}+\phi_{ij}*(x_{kj}-x_{ij})
            sol(Param2Change) = x(i,Param2Change)+(x(i,Param2Change)-x(neighbour,Param2Change))*(rand-0.5)*2;
            ind=find(sol<lb);	sol(ind)=lb(ind);
            ind=find(sol>ub);   sol(ind)=ub(ind);
            ftmp = fit_eval(sol,ProbSet,fn);
            fit_tmp = abc_fitness(ftmp);
            % Greedy selection Between sol(i,:) and Mutant
            if fit_tmp > abc_fit(i)
                x(i,:) = sol;
                abc_fit(i) = fit_tmp;
                f(i) = ftmp;
                trial(i) = 0;
            else
                trial(i) = trial(i)+1;  %% If sol(i) can not be improved, Increase its trial cnt
            end
        end
        fes = fes + xNum;
        prob = (0.9.*abc_fit./max(abc_fit))+0.1;
        
        % -----  ----- ONLOOKER BEE PHASE -----  ----- %
        i = 1;  t = 0;
        while t<xNum
            if rand<prob(i)
                t = t+1;
                Param2Change = randi(D);
                neighbour = randi(xNum);
                while neighbour==i
                    neighbour = randi(xNum);
                end
                sol = x(i,:);
                % v_{ij}=x_{ij}+\phi_{ij}*(x_{kj}-x_{ij})
                sol(Param2Change) = x(i,Param2Change)+(x(i,Param2Change)-x(neighbour,Param2Change))*(rand-0.5)*2;
                ind=find(sol<lb);	sol(ind)=lb(ind);
                ind=find(sol>ub);   sol(ind)=ub(ind);
                ftmp = fit_eval(sol,ProbSet,fn);
                fes = fes + 1;
                fit_tmp = abc_fitness(ftmp);
                if fit_tmp > abc_fit(i)
                    x(i,:) = sol;
                    abc_fit(i) = fit_tmp;
                    f(i) = ftmp;
                    trial(i) = 0;
                else
                    trial(i) = trial(i)+1; %% If Not Improved, Increase by One
                end
            end
            i = i+1;
            if i == xNum+1
                i = 1;
            end
        end
        % Update the Best
        [cur_fmin,pos] = min(f);
        if cur_fmin < fmin
            fmin = cur_fmin;
            xmin = x(pos,:);
        end
        
        % -----  ----- SCOUT BEE PHASE -----  ----- %
        % Determine Food Sources whose Trial cnt exceeds Limit
        % In Basic ABC, Only One Scout is allowed to Occur Each Cycle
        ind = find(trial==max(trial));
        ind = ind(end);
        if (trial(ind)>limit)
            trial(ind) = 0;
            sol = (ub-lb).*rand(1,D)+lb;  %% Re-Initialization, if exceeds Limit
            ftmp = fit_eval(sol,ProbSet,fn);
            fes = fes + 1;
            fit_tmp = abc_fitness(ftmp);
            x(ind,:) = sol;
            abc_fit(ind) = fit_tmp;
            f(ind) = ftmp;
        end
        
        %cv = [cv;fmin];
    end  %% While-Loop
end

% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
%%->>	ABC (Artificial Bee Colony) abc_fit Calculation
%%->>	Sourse Code & Relevant Papers Available:
%%->>	http://mf.erciyes.edu.tr/abc/
%%->>	Updated: 22-11-2016
function  abc_fit = abc_fitness(fv)
% INPUT:    OBJECTIVE_FUNCTION_VALUE, EITHER A SCALE OR VECTOR          %
% OUTPUT:   RETURN THE SAME SIZED MATRIX                                %
% FOR MINIMIZATION, THE LARGER FITNESS_VALUE IT HAS, THE BETTER IT IS.  %
    abc_fit = zeros(size(fv));
    [idx,jdx] = find(fv>=0);
    abc_fit(idx,jdx) = 1 ./ (fv(idx,jdx) + 1);
    [idx,jdx] = find(fv<0);
    abc_fit(idx,jdx) = 1 + abs(fv(idx,jdx));
end
