% Downloaded - http://ist.csu.edu.cn/YongWang.htm (Accessed Date: 24-05-2016)
% Ref.Article: Y.Wang, Z.Cai, & Q.Zhang,"Differential Evolution with Composite 
%              Trial Vector Generation Strategies and Control Parameters,"
%              IEEE Transactions on Evolutionary Computation,15(1):55-66(2011).
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Slightly Modified by Felix (Felix.lou@my.cityu.edu.hk)
% Updated: 03-01-2017

function [fmin] = run_code(ProbSet,fn,d,ps,lbin,ubin,maxfes)
% Size of x: ps-by-d

    if isscalar(lbin) && isscalar(ubin)
        ub = ones(1,d)*ubin;  %/*lower bounds of the parameters. */
        lb = ones(1,d)*lbin;  %/*upper bound of the parameters.*/
    else
        ub = ubin;
        lb = lbin;
    end
% ----- Initilization ----- %
    x = repmat(lb,[ps,1]) + rand(ps,d).*(repmat(ub-lb,[ps,1]));
    f = fit_eval(x,ProbSet,fn);
    [fmin,pos] = min(f);
    xmin = x(pos,:);
    fes = ps;
    %cv(1,1) = fmin;
% ----- Main Loop ----- %    
    while fes < maxfes    
        x_tmp = x;
        f_tmp = f;
        uSet = zeros(3*ps,d);  %% uSet: Set of Trial Vectors
        for i = 1:ps  %% This For-Loop Generates 3*ps Trial Vectors
            F  = [1.0;1.0;0.8];  %% Three Control Parameter Settings
            CR = [0.1;0.9;0.2];
            paraIdx = randi(3,[3,1]);  %% Uni-Rand-Select One Para-Set for Each Trial Vector
            u = codeGenerator(x,lb,ub,i,F,CR,d,ps,paraIdx);
            uSet(i*3-2:3*i,:) = u;
        end
        fSet = fit_eval(uSet,ProbSet,fn);
        fSet = fSet(:);
        fes = fes + 3*ps;
        
        for i = 1:ps
            [~, minID] = min(fSet(3*i-2:3*i));  %% Choose Best Trial Vector from Three
            bestInd    = uSet(3*(i-1)+minID,:);
            bestIndFit = fSet(3*(i-1)+minID);
            if f(i) >= bestIndFit  %% Choose Better One between Trial Vector & Target Vector
                x_tmp(i,:) = bestInd;
                f_tmp(i) = bestIndFit;
            end
        end
        x = x_tmp;
        f = f_tmp;
        % Update Best_Solution
        [fmin,pos] = min(f);
        xmin = x(pos,:);
        %cv = [cv;fmin];
    end  %% End-of-While-Loop
end  %% End-of-Function
        
function u = codeGenerator(x,lb,ub,i,F,CR,d,ps,paraIdx)
% This CoDE_Generator was Modified for Dimension-by-PopSize Solutions
    x = x';
    lb = lb';
    ub = ub';
    %% [1] Rand/1/Bin, Use paraIdx(1) %
    idxSet = randperm(ps);
    idxSet(idxSet==i) = [];
    idx(1:3,1) = idxSet(1:3);
    % -- Mutation
    v1 = x(:,idx(1))+F(paraIdx(1)).*(x(:,idx(2))-x(:,idx(3)));
    
    % -- Handle Boundary
    vioLow = find(v1 < lb);
    if ~isempty(vioLow)
        v1(vioLow,1) = 2.*lb(vioLow,1) - v1(vioLow,1);
        vioLowUpper = find(v1(vioLow,1) > ub(vioLow,1));
        if ~isempty(vioLowUpper)
            v1(vioLow(vioLowUpper),1) = ub(vioLow(vioLowUpper),1);
        end
    end
    vioUpper = find(v1 > ub);
    if ~isempty(vioUpper)
        v1(vioUpper,1) = 2.*ub(vioUpper,1) - v1(vioUpper,1);
        vioUpperLow = find(v1(vioUpper,1) < lb(vioUpper,1));
        if ~isempty(vioUpperLow)
            v1(vioUpper(vioUpperLow),1) = lb(vioUpper(vioUpperLow),1);
        end
    end
    
    % -- Binomial Crossover
    j_rand = randi(d);
    t = rand(d,1) < CR(paraIdx(1));
    t(j_rand,1) = 1;
    t_ = 1-t;
    u(:,1) = t.*v1 + t_.*x(:,i);
    
    %% [2] Current to Rand/1, Use paraIdx(2) %
    idx(1:3,1) = floor(rand(3,1)*ps)+1;
    % -- Mutation
    v2 = x(:,i)+rand*(x(:,idx(1))-x(:,i))+F(paraIdx(2)).*(x(:,idx(2))-x(:,idx(3)));
    
    % -- Handle Boundary
    vioLow = find(v2 < lb);
    if ~isempty(vioLow)
        v2(vioLow,1) = 2.*lb(vioLow,1)-v2(vioLow,1);
        vioLowUpper = find(v2(vioLow,1) > ub(vioLow,1));
        if ~isempty(vioLowUpper)
            v2(vioLow(vioLowUpper),1) = ub(vioLow(vioLowUpper),1);
        end
    end
    vioUpper = find(v2 > ub);
    if ~isempty(vioUpper)
        v2(vioUpper,1) = 2.*ub(vioUpper,1) - v2(vioUpper,1);
        vioUpperLow = find(v2(vioUpper,1) < lb(vioUpper,1));
        if ~isempty(vioUpperLow)
            v2(vioUpper(vioUpperLow),1) = lb(vioUpper(vioUpperLow),1);
        end
    end
    
    % -- No Binomial Crossover
    u(:,2) = v2;
    
    %% [3] Rand/2/Bin, Use paraIdx(3) %
    idxSet = randperm(ps);
    idxSet(idxSet==i) = [];
    idx(1:5,1) = idxSet(1:5);
    % -- Mutation
    v3 = x(:,idx(1))+rand.*(x(:,idx(2))-x(:,idx(3)))+F(paraIdx(3)).*(x(:,idx(4))-x(:,idx(5)));
    
    % -- Handle Boundary
    vioLow = find(v3 < lb);
    if ~isempty(vioLow)
        v3(vioLow,1) = 2.*lb(vioLow,1) - v3(vioLow,1);
        vioLowUpper = find(v3(vioLow,1) > ub(vioLow,1));
        if ~isempty(vioLowUpper)
            v3(vioLow(vioLowUpper),1) = ub(vioLow(vioLowUpper),1);
        end
    end
    vioUpper = find(v3 > ub);
    if ~isempty(vioUpper)
        v3(vioUpper,1) = 2.*ub(vioUpper,1) - v3(vioUpper,1);
        vioUpperLow = find(v3(vioUpper,1) < lb(vioUpper,1));
        if ~isempty(vioUpperLow)
            v3(vioUpper(vioUpperLow),1) = lb(vioUpper(vioUpperLow),1);
        end
    end
    
    % -- Binomial crossover
    j_rand = randi(d);
    t = rand(d,1) < CR(paraIdx(3));
    t(j_rand,1) = 1;
    t_ = 1-t;
    u(:,3) = t.*v3 + t_.*x(:,i);
    
    u = u';
end  %% End-of-Generator-Function

