% Downloaded - http://www.particleswarm.info/ (Accessed Date: 09-08-2016)
% Ref.Article: M.Zambrano-Bigiarini, M.Clerc, and R.Rojas, "Standard Particle
%              Swarm Optimisation 2011 at CEC-2013: A Baseline for Future PSO
%              Improvements," In Proc. IEEE Congress on Evolutionary Computation,
%              (CEC2013),DOI:10.1109/CEC.2013.6557848(2013).
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% [Standard PSO 2011]
% Developed by: Dr. Mahamed G.H. Omran (omran.m@gust.edu.kw) 7-May-2011
% Modified and improved by: Maurice Clerc 23-May-2011
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Slightly Modified by Felix (Felix.lou@my.cityu.edu.hk)
% Updated: 17-01-2017

function [fmin] = run_spso(ProbSet,fn,d,ps,lbin,ubin,maxfes)

    if isscalar(lbin) && isscalar(ubin)
        ubin = ones(1,d)*ubin;  %/*lower bounds of the parameters. */
        lbin = ones(1,d)*lbin;  %/*upper bound of the parameters.*/
    end
    
    w = 1/(2*log(2));
    c1 = 0.5+log(2);
    c2 = c1;
    x = zeros(ps,d);
    v = zeros(size(x));  %% Velocity

    for i=1:1:ps
        for j=1:1:d
            x(i,j) = alea(lbin(j),ubin(j));
            v(i,j) = alea(lbin(j)-x(i,j), ubin(j)-x(i,j));
        end
    end
    % Calculate Fitness
    f = fit_eval(x,ProbSet,fn);
    % Initialize the personal experience
    p_x = x;  p_f = f;
    % Index of the global best particle
    [best_f, g] = min(p_f);
    %PSO_run = zeros(1,t_max); %a PSO run
    FEs = ps; % ps initialisations.  *****FEs = 0;
    count = 1;
    % K neighbors for each particle -- based on Clerc description 
    % http://clerc.maurice.free.fr/pso/random_topology.pdf
    % P.2 (Method 2)
    K = 3;
    p = 1-power(1-1/ps,K); % Probability to be an informant
    stop = 0;
    
    while stop<1
        % In the C version, random permutation is applied here. This is
        % currently not implemented in this code.
        if count > 0  % No improvement in the best solution. So randomize topology
            % L = eye(ps,ps); % Matlab function, but does not exist in FreeMat
            L = zeros(ps,ps);
            for s = 1:1:ps
                L(s,s) = 1;
            end
            
            for s = 1:1:ps % Each particle (column) informs at most K other at random 
                for r=1:1:ps
                    if (r~=s)
                        if (alea(0,1)<p)
                            L(s,r) = 1;
                        end
                    end
                end
            end
        end % if
        
        for i = 1:1:ps  % For each particle (line) find the best informant g
            MIN = Inf;
            for s = 1:1:ps
                if (L(s,i) == 1)
                    if p_f(s) < MIN
                        MIN = p_f(s);
                        g_best = s;
                    end
                end
            end
            % define a point p' on x-p, beyond p
            p_x_p = x(i,:) + c1*(p_x(i,:) - x(i,:));
            % ... define a point g' on x-g, beyond g
            p_x_l = x(i,:) + c2*(p_x(g_best,:) - x(i,:));
            
            if (g_best == i) % If the best informant is the particle itself, define the gravity center G as the middle of x-p'
                G = 0.5*(x(i,:) + p_x_p);
            else % Usual  way to define G
                sw = 1/3;
                G = sw*(x(i,:) + p_x_p + p_x_l);
            end
            rad = norm(G - x(i,:)); % radius = Euclidean norm of x-G
            x_p = alea_sphere(d,rad)+ G; % Generate a random point in the hyper-sphere around G (uniform distribution)
            v(i,:) = w*v(i,:) + x_p - x(i,:); % Update the velocity = w*v(t) + (G-x(t)) + random_vector
            % The result is v(t+1)
            x(i,:) = x(i,:) + v(i,:); % Apply the new velocity to the current position. The result is x(t+1)
            %Check for constraint violations
            for j = 1:1:d
                if x(i,j) > ubin(j)
                    x(i,j) = ubin(j);
                    v(i,j) = -0.5*v(i,j); % variant: 0
                end
                if x(i,j) < lbin(j)
                    x(i,j) = lbin(j);
                    v(i,j) = -0.5*v(i,j); % variant: 0
                end
            end %j
            f(i) = fit_eval(x(i,:),ProbSet,fn);
            FEs = FEs + 1;
            if (FEs>=maxfes) % Too many FE
                break;
            end
        end %i
        % Update personal best
        for i=1:1:ps
            if f(i) <= p_f(i)
                p_x(i,:) = x(i,:);
                p_f(i) = f(i);
            end %if
        end %i
        % Update global best
        [b_f, g] = min(p_f);
        
        if b_f < best_f
            best_f = b_f;
            count = 0;
        else
            count = count + 1; % If no improvement, the topology will be initialised for the next iteration
        end
        if (FEs>=maxfes)
            stop = 1;
        end
    end %t

    % best_x = p_x(g,:);
    fmin = best_f;
end %SPSO2011
