% -----  -----  -----  -----  -----  -----  ----- %
% arXiv_check.m
% -----  -----  -----  -----  -----  -----  ----- %
% Given a Solution x:
%       If x is Revisit
%           - Then Generate a New-Non-Revisit x
%           - Return x
%       Else
%           - Return Original x
%       End
% -----  -----  -----  -----  -----  -----  ----- %
% Updated: 02-01-2017

function [x] = arXiv_check(x,lw,up)
% Input:  x  - A Population: d-by-ps
%         lw - Lower of Entire Search Space
%         up - Upper of Entire Search Space
% Output: x  - A Non-Revisit Population
global arXiv;

    [d,ps] = size(x);
    if isscalar(lw) && isscalar(up)
        lw = ones(d,1)*lw;	%% Lower Bound - Scalar to Vector
        up = ones(d,1)*up;  %% Upper Bound - Scalar to Vector
    end
    
    for idx = 1:ps
        ndx = 1;
        sub = [lw,up];  %% A Sub-Space to Shrink and Generate New Solutions
        while arXiv.d(ndx,1)
            jdx = arXiv.d(ndx,1);
            if x(jdx,idx) < (arXiv.min(ndx,1)+arXiv.max(ndx,1))/2.0
                sub(jdx,2) = arXiv.max(ndx,1);  %% Upper Bound
                ndx = arXiv.ldx(ndx,1);
            else
                sub(jdx,1) = arXiv.min(ndx,1);  %% Lower Bound
                ndx = arXiv.rdx(ndx,1);
            end
        end
        if ~sum(abs(arXiv.x(:,ndx) - x(:,idx)))  %% Revisiting If Sum is 0
            jdx = randi(d);
            x(jdx,idx) = rand*(sub(jdx,2)-sub(jdx,1)) + sub(jdx,1);
        end
    end
    
end