% arXiv_in.m
% Insertion Two Global Variables: 1) arXiv; 2) fMat.
% 1) arXiv - all Evaluated-Instances (To Avoid Re-Evaluation)
% 2) fMat  - Fitness Matrix: (Component-EA, Generated-Instance)
% Updated: 22-01-2017

function [nd,nf] = arXiv_in(x,f,nd,fmat,nf,gb)
% Input:  x	 -
%         f  - 
%         nd - #of nodes
%         fmat - The New Fitness Matrix to be Inserted
%         nf   - #of Fitness Mats
%         gb   - Global Best Fitness (Optimum, Minimum)
global arXiv;	%% Binary Space Partitioning (BSP) Tree
global fMat;	%% Note "fmat = cell(maxFEs,2)"
                %->> fMat{idx,1} - The Fitness Matrix
                %->> fMat{idx,2} - The Random Seed
global fit;     %% Fitness, note "fit = cell(maxFEs,1)"
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- 
% Note that: arXiv.fp points to both 'fMat' and 'fit'.
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- 

    [~,ps] = size(x);
    for idx = 1:ps
        if arXiv.d(1,1) == -2
            arXiv.x(:,1) = x(:,1);
            %[1]%>> arXiv.f(1,1) = f(1,1);
            arXiv.d(1,1) = 0;
            nd = 1;
            fMat{1,1} = fmat{idx};  %% Fitness Mat
            fMat{1,2} = gb(idx);	%% Rand Seed
            fit{1,1} = f{1};
            arXiv.fp(1,1) = 1;      %% Pointing to fMat, a.w.a. fit
            nf = 1;
        else
            ndx = 1;
            while arXiv.d(ndx,1)
                jdx = arXiv.d(ndx,1);
                if x(jdx,idx) < (arXiv.min(ndx,1)+arXiv.max(ndx,1))/2.0
                    ndx = arXiv.ldx(ndx,1);
                else
                    ndx = arXiv.rdx(ndx,1);
                end
            end
            memo_x = arXiv.x(:,ndx);
            %[2]%>> memo_f = arXiv.f(ndx,1);
            %fp = arXiv.fp(ndx,1);
            d_diff = abs(memo_x - x(:,idx));
            d = find(d_diff == max(d_diff));
            d = d(1);
% %             if length(d) > 1
% %                 d = d(randi(length(d)));
% %             end
            % --- --- --- --- --- --- --- --- --- --- %
            cur_min = min(memo_x(d,1), x(d,idx));
            cur_max = max(memo_x(d,1), x(d,idx));
            % --- --- --- --- --- --- --- --- --- --- %
            arXiv.d(ndx,1) = d;
            arXiv.min(ndx,1) = cur_min;
            arXiv.max(ndx,1) = cur_max;
            
            ldx = nd+1;
            rdx = nd+2;
            nd = nd+2;
            arXiv.ldx(ndx,1) = ldx;
            arXiv.rdx(ndx,1) = rdx;
            arXiv.pdx(ldx,1) = ndx;
            arXiv.pdx(rdx,1) = ndx;
            arXiv.d(ldx,1) = 0;
            arXiv.d(rdx,1) = 0;
            
            nf = nf+1;
            fMat{nf,1} = fmat{idx};     %% A new fit-matrix is formed
            fMat{nf,2} = gb(idx);       %% together with its global best.
            fit{nf,1}  = f{idx};        %% .f independent
            
            if x(d,idx) < (cur_min+cur_max)/2.0
                arXiv.x(:,ldx) = x(:,idx);
                %[3]%>> arXiv.f(ldx) = f(idx);
                arXiv.x(:,rdx) = memo_x;
                %[4]%>> arXiv.f(rdx) = fp;
                % -- L -- %
                arXiv.fp(ldx) = nf;  %% Put x on Left, and Point to nf(New Idx in fMat)
                arXiv.fp(rdx) = arXiv.fp(ndx,1);  %% Old Solution -> Old in fMat
                % -- End L -- %
            else
                arXiv.x(:,rdx) = x(:,idx);
                %[5]%>> arXiv.f(rdx) = f(idx);
                arXiv.x(:,ldx) = memo_x;
                %[6]%>> arXiv.f(ldx) = fp;
                % -- R -- %
                arXiv.fp(rdx) = nf;  %% Put x on Right
                arXiv.fp(ldx) = arXiv.fp(ndx,1);
                % -- End R -- %
            end
        end
    end
    
end

