% arXiv_init.m
% Initialization Three Global Variables: 1)arXiv; 2)fMat; 3)fit.
% 1) arXiv - all Evaluated-Instances (To Avoid Re-Evaluation)
% 2) fMat  - Fitness Matrix: (Comp-EA, Gen-Instance)
% 3) fit   - Fitness in arXiv
% Updated: 21-01-2017

function [arXiv,nd,fmat,fit,nf] = arXiv_init(d,mfe)
% Input:  d    - 
%         mfe  - Max #of Function Evaluations
% Output: aXv  - Tree
%         nd   - #of nodes in Tree
%         fmat - Queue, Not a Tree
%         fit  - Queue, to store fitness values
%         nf   - #of nodes in Queue

max_arXiv = mfe*2;
arXiv = struct ('x',	zeros(d,max_arXiv),	...
                'd',	-1*ones(max_arXiv,1),	...
                'min',	zeros(max_arXiv,1),	...
                'max',	zeros(max_arXiv,1),	...
                'pdx',	zeros(max_arXiv,1),	...
                'ldx',	zeros(max_arXiv,1),	...
                'rdx',  zeros(max_arXiv,1),	...
                'fp',	zeros(max_arXiv,1)  ...  %%~ 'fp' FitMatrix Pointor
                );
    arXiv.d(1,1) = -2;
    nd = 0;  %% #Nodes in arXiv
    fmat = cell(mfe,2);  %% Each fmat is a #EA-by-#Rep (NEA-by-NREP) Matrix
    nf = 0;  %% #Nodes in fMat
    fit = cell(mfe,1);
    
end

