% ea_exe.m
% Evolutionary Algorithms Execution
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% COMPONENTS:
% 1. ABC        - Artificial Bee Colony
% 2. CoDE       - Composite Differential Evolution
% 3. SPSO-2011	- Standard Particle Swarm Optimization v2011
% 4. CMA-ES     - Evolution Strategy with Covariance Matrix Adaptation v3.62
%       for details of these four EAs, please see
%       "\algorithms\about_algorithms.txt"
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Updated: 02-01-2017

function [f] = ea_exe(ProbSet,fn,algo,d,ps,lb,ub,maxfes,fgb)
% fgb = Fitness of Global Best
EAs = {'ABC'; 'CoDE'; 'SPSO2011'; 'CMAES'};

    if ~ischar(algo)
        disp(['Running EA(',int2str(algo),'), i.e. ',EAs{algo},' ...'])
        algo = EAs{algo};
    end
    switch algo
        case {'abc';'ABC'}                      %% ABC
            f = run_abc(ProbSet,fn,d,ps,lb,ub,maxfes);            
        case {'code';'CoDE';'CODE'}             %% CoDE
            f = run_code(ProbSet,fn,d,ps,lb,ub,maxfes);        
        case {'pso';'spso';'PSO';'SPSO';'spo2011';'spso2011';'PSO20011';'SPSO2011'}  %% SPSO-2011
            f = run_spso(ProbSet,fn,d,ps,lb,ub,maxfes);
        case {'nbipop';'nbicma';'nbipopcmaes';} %% NBIPOP-CMA
            switch ProbSet
                case 'cec2013'
                    f = run_nbicma(ProbSet,fn,d,ps,lb(1),ub(1),maxfes);
                case 'glg06'
                    f = run_nbicma(ProbSet,fn,d,ps,lb(1),ub(1),maxfes,fgb);
            end
    end
end


