% feval_prob.m
% Calculate and assign the hierarchical fitness (HF) value for each
% benchmark instance.
% Updated: 24-09-2020

function [fit,fmat,f_bias] = feval_prob(ProbSet,set,x,rept,fmode)
%global TestNrRS;
% x - One Configuration / Four(Five) Components
% (1) sig = ones(nGauss,1);
% (2) sqz = ones(nGauss,d);
% (3) rat = ones(nGauss-1,1);
% (4) rs  = ones(1,1);       %% an Integer
% (5) rot = rand(nGauss,1);  %% Not In This Work
% rept  - #Repeated Runs
% fmode - Fitness-Evaluation-Mode - Which Algorithm is Superior/Inferior %
% EAs = {'ABC'; 'CoDE'; 'SPSO2011'; 'NBIPOPCMA';};
eas = {'abc'; 'code'; 'spso'; 'nbicma';};
NEA = length(eas);
%%>> Common Paras both CEC and GLG use
    d = set.d;  ub = set.ub;  lb = set.lb;
%%>> PopSize Defined in the EA Literatures
    ps_abc	= 20;   ps_spso = ceil(10+sqrt(d)*2);
    ps_code	= 30;   ps_cma  = 4+floor(3*log(d));
    %ps_nr = max([ps_abc;ps_spso;ps_code;ps_cma]);
%%>> We Do Not Change Paras in Component EAs, including PopSize

if strcmp(ProbSet,'glg06')
    nGauss = set.nGauss;    
    gbf = set.gbf;    
    [dd,pps] = size(x);
    %%if dd~=nGauss*(d+2)-1 || pps~=1
    if dd~=nGauss*(d+2) || pps~=1
        error('Check #1 in ''feval_prob.m'' ... ');
    else
        rot = zeros(nGauss,1);  %% No Rotation in Current Work %
    end
    
% ----- X-to-Config ----- %
    if set.nGauss < 100
        sig(:,1) = x(1:nGauss,1);
        sqz      = reshape(x(nGauss+1:nGauss*(d+1),1),nGauss,d);
        rat(:,1) = x(nGauss*(d+1)+1:nGauss*(d+2)-1);
        rs       = x(dd,1);  %% Random Seed
    else
        sig(:,1) = x(1:nGauss,1);
        rat(:,1) = x(nGauss+1:nGauss*2-1);
        rs       = x(dd,1);  %% Random Seed
        sqz = 0;
    end 
% ----- X-to-Config ----- %

    if ~exist('set.fn','var') && ~exist('fn','var')
        fn = 1;
    else
        error('Check ...')
    end
    %rs = randi(2^53-1);  %% All Possible Integer, IMAX Less Than 2^53
    rand('seed',rs);
    Lfbest = glg06_init(d,nGauss,ub,lb,gbf,sig,rot,sqz,rat);
    f_bias = min(Lfbest);  %% The Best Fitness Among the Local Optima

    Ub = ub*ones(1,d);
    Lb = lb*ones(1,d);
    fmat = inf*ones(NEA,rept);
    
    % NOTE: -->
    %	(1) Above: rand('seed',rs) for re-construct the Benchmark Instance
    %   (2) Below: rng('default') + rng('shuffle') to reset the random stream
    % NOTE: -->
    rng('default');  rng('shuffle');
    for idx = 1:NEA
        %disp(['    running ',EAs{idx},', ',int2str(idx),'/',int2str(NEA),' EAs to evaluate',])
        for r = 1:rept
            switch idx
                case 1
                    fmat(idx,r) = ea_exe(ProbSet,fn,'abc',   d,ps_abc, Lb,Ub,set.maxfes) - f_bias;
                case 2
                    fmat(idx,r) = ea_exe(ProbSet,fn,'code',  d,ps_code,Lb,Ub,set.maxfes) - f_bias;
                case 3
                    fmat(idx,r) = ea_exe(ProbSet,fn,'spso',  d,ps_spso,lb,ub,set.maxfes) - f_bias;
                case 4
                    fmat(idx,r) = ea_exe(ProbSet,fn,'nbicma',d,ps_cma, Lb,Ub,set.maxfes, f_bias);
                otherwise
                    error('Wrong EA-ID ... ')
            end
        end
    end
    
    switch fmode
        case 'abcs'  %% ABC Superior
            idx = 1;  s = 1;       
        case 'cods'
            idx = 2;  s = 1;  
        case 'psos'
            idx = 3;  s = 1;
        case 'cmas'
            idx = 4;  s = 1;
        otherwise
            error('Wrong F-Mode ... ')
    end
    
    fit = struct('f',       1,  ... p-Value if mean is better
                 'n',       0,  ... 
                 'i',       [], ...
                 'fi',      [], ...
                 'delta',	0   ...
                 );
    if s
        fen = fmat;  fen(idx,:) = [];	%% fen: Get an Ensamble EA
        fin = min(fen,[],1);            %% fin: Get the Best of Other EAs
        ftgt = fmat(idx,:);             %% ftgt: 'tgt' short for Target
        mtgt = mean(ftgt);
        
        if mtgt < mean(fin)	%% Target EA is Smaller (Better)
            [fit.f,~] = ranksum(fin,ftgt);  %% Smaller Fitness >> More Significant Superior
            % This makes fit.f < 1
        else  %% mean(ftgt) >= mean(fin)
            tmpIdx = 1:NEA;
            %%tmpIdx(idx) = [];
            mi = zeros(NEA,1);
            for itmp = tmpIdx
                mi(itmp) = mean(fmat(itmp,:));
                if mtgt < mi(itmp)
                    fit.i(itmp) = 1;  %% The Target EA Better than EA(i)
                    fit.fi(itmp,1) = ranksum(ftgt,fmat(itmp,:));
                else
                    fit.i(itmp) = 0;  %% The Target EA NOT Better than EA(i)
                    fit.fi(itmp,1) = 1;
                end
            end
            fit.n = sum(fit.i);
            % Check >>
            tmpv = sum(mtgt<mi);
            if fit.n ~= tmpv
                error('Check point #1 ... ')
            end
            if ~fit.n  %% Target EA NOT Better than Any EA(i)
                mi(idx) = [];
                fit.delta = mtgt - max(mi);  %% Delta = mean(Target) - mean(WorstEA_Exp_Target)
            %else
            %    fit.delta = 0;  %% Assigned 0 Initially
            end
        end
    else  %% Inferior Purpose
        fen = fmat;  fen(idx,:) = [];	%% fen: Get an Ensamble EA
        fin = max(fen,[],1);            %% fin: Get the Best of Other EAs
        ftgt = fmat(idx,:);             %% ftgt: 'tgt' short for Target
        mtgt = mean(ftgt);
        
        if mean(ftgt) > mean(fin)	%% Target EA is Smaller (Better)
            [fit.f,~] = ranksum(fin,ftgt);  %% Smaller Fitness >> More Inferior
            % This makes fit.f < 1
        else  %% mean(ftgt) <= mean(fin)
            tmpIdx = 1:NEA;
            %tmpIdx(idx) = [];            
            mi = zeros(NEA,1);
            for itmp = tmpIdx
                mi(itmp) = mean(fmat(itmp,:));
                if mtgt > mi(itmp)
                    fit.i(itmp) = 1;  %% The Target EA Better than EA(i)
                    fit.fi(itmp,1) = ranksum(ftgt,fmat(itmp,:));
                else
                    fit.i(itmp) = 0;  %% The Target EA NOT Better than EA(i)
                    fit.fi(itmp,1) = 1;
                end
            end
            fit.n = sum(fit.i);
            % Check >>
            tmpv = sum(mtgt>mi);
            if fit.n ~= tmpv
                error('Check point #2 ... ')
            end
            if ~fit.n  %% Target EA NOT Worse than Any EA(i), Target EA is Best
                fit.delta = min(mi)-mtgt;  %% Delta = mean(BestEA_Exp_Target) - mean(Target)
            %else
            %    fit.delta = 0;  %% Assigned 0 Initially
            end
        end
    end
    
else  %% if strcmp(ProbSet,'cec2013')
    f_bias = [-1400:100:-100,100:100:1400];
    fn = set.fn;
    Ub = ub*ones(1,d);
    Lb = lb*ones(1,d);
    fmat = inf*ones(NEA,rept);
    for idx = 1:NEA
        for r = 1:rept
            switch idx
                case 1
                    fmat(idx,r) = ea_exe(ProbSet,fn,'abc',  d,ps_abc, Lb,Ub,set.maxfes) - f_bias(fn);
                case 2
                    fmat(idx,r) = ea_exe(ProbSet,fn,'code', d,ps_code,Lb,Ub,set.maxfes) - f_bias(fn);
                case 3
                    fmat(idx,r) = ea_exe(ProbSet,fn,'spso', d,ps_spso,Lb,Ub,set.maxfes) - f_bias(fn);
                case 4
                    fmat(idx,r) = ea_exe(ProbSet,fn,'nbicma',d,ps_cma,Lb,Ub,set.maxfes);  %% Bias Remove inside CMA-ES Source Code %                    
               otherwise
                    error('Wrong EA-ID ... ')
            end
        end
    end
    fit = [];
end

