% fit_eval.m
% Single Objective Fitness Value Evaluation
% Updated: 02-01-2017

function [f] = fit_eval(x,ProbSet,fn)
% ProbSet - {'cec2013'; 'glg06'; ... }
% fn      - Only If ProbSet == 'cec2013'; Then fn = {1,2,...,28}

    if strcmp(ProbSet,'glg06') && fn
        f = glg06_fit(x);
    elseif strcmp(ProbSet,'cec2013') && fn
        f = cec13_func(x',fn); 
    end
end

% %     % ----- For Test Only -----  -----  ----- %
% %     [ps,d] = size(x);
% %     f = zeros(ps,1);
% %     for idx = 1:ps
% %         f(idx,1) = sum(x(idx,:).^2);
% %     end
