% get_nodeInfo.m
% To Get Node Information in arXiv & fMat
% Updated: 02-01-2017

function [nid,ninfo,fmatx] = get_nodeInfo(x,f)
% Input:  x
%
% Output: nid   - Node Address
%         ninfo - Node Content, a Structure
%         fmatx - Fitness Matrix Element
global arXiv;
global fMat;

    ndx = 1;
    while arXiv.d(ndx,1)
        jdx = arXiv.d(ndx,1);
        if x(jdx,1) < (arXiv.min(ndx,1)+arXiv.max(ndx,1))/2.0
            ndx = arXiv.ldx(ndx,1);
        else
            ndx = arXiv.rdx(ndx,1);
        end
    end
    if arXiv.f(ndx,1) == f
        nid = ndx;
        ninfo.x = arXiv.x;
        ninfo.f = arXiv.f;
        ninfo.d = arXiv.d;
        fmatx = fMat{ndx};
    else
        disp('Solution NOT Found in arXiv ... ');
        nid = 0;
        ninfo = [];
        fmatx = [];
    end

end
