% glg06_fit.m
% Downloaded From: http://staff.itee.uq.edu.au/marcusg/msg.html (Accessed Date: 14-12-2016)
% Ref.Article: M.Gallagher & B.Yuan, "A General-purpose Tunable Landscape Generator,"
% IEEE Transactions on Evolutionary Computation, 10(5):590-603(2006).
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Slightly Modified by Felix (Felix.lou@my.cityu.edu.hk)
% Updated: 20-01-2017

function [fbest,components] = glg06_fit_2d(x,opt)

global cmInv;       %% Inverse Covariance Matrix of Local Basin
global lbPos;       %% Positions of Local Best
global lbFit;       %% Peak Value of Each Component

    maxMode = 'max';  %% 'additive';  %% maxMode = {'max'; 'additive'}
    if nargin==1
        opt = 'min';
    end
    if isempty(cmInv) || isempty(lbPos) || isempty(lbFit)
        error('Run ''glg06_init.m'' First ... ');
    end
    nGauss = size(lbPos,1);
    [ps,d] = size(x);
    if d~=size(lbPos,2) && d == 2
        %error('Wrong d ... ');
        x(:,2:size(lbPos,2)) = 0;
    end
    tmp = zeros(nGauss,ps);
    %----------------------------------------------------
    for idx = 1:nGauss
        newx = x - repmat(lbPos(idx,:),[ps,1]);
        z = (newx*cmInv{idx}).*newx;
        tmp(idx,:) = sum(z,2)';
    end

    f = exp(-0.5*tmp/d);            %% f is a nGauss-by-ps matrix
    f = f.*repmat(lbFit',[1,ps]);	%% multiply the peak value of each component
    components = f';                %% the value of each individual generated by each component

    switch maxMode
        case 'additive'
            fbest = sum(f,1);
        case 'max'
            fbest = max(f,[],1);      % choose the maximum values as the fitness values
    end

    if strcmp(opt,'min')
        fbest = -fbest;
    end

end

%%>> fbest = fbest - fbias;
% Fbias could be 1)some Bias Values; 2)other Landscapes(e.g., Sphere, etc.)
