% glg06_init.m
% Downloaded From: http://staff.itee.uq.edu.au/marcusg/msg.html (Accessed Date: 14-12-2016)
% Ref.Article: M.Gallagher & B.Yuan, "A General-purpose Tunable Landscape Generator,"
% IEEE Transactions on Evolutionary Computation, 10(5):590-603(2006).
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Initalization A Gaussian Landscape Benchmark Instance
% Slightly Modified by Felix (Felix.lou@my.cityu.edu.hk)
% Updated: 19-01-2017

function [Lfbest, Lxbest] = glg06_init(d,nGauss,ub,lb,gbf,sig,rot,sqz,rat)
% Input:  d      -
%         nGauss -
%         ub,lb  - Real Numbers, Not Matrice
%         gbf    - Global Best Fitness (Optimum)
%         sig	 - (Sigma)      Size: nGauss-by-One
%         //rot  - (Rotation)   Size: nGauss-by-One//Not Considered
%         sqz    - (Squeeze)    Size: nGauss-by-Dim
%         rat	 - (Ratio)      Size: (nGauss-1)-by-One, & rat(1,1) = 1
% Output: (Optional)
%         Lfbest - Fitness Values of All Local Optima, aka lbFit
%         Lxbest - Positions of All Local Optima, aka lbPos
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
clear global cmInv;
clear global lbPos;
clear global lbFit;
global cmInv;       %% Inverse Covariance Matrix of Local Basin
global lbPos;       %% Positions of Local Best
global lbFit;       %% Peak Value of Each Component

    mean_dst = 'dst';  %% mean_dst = {'rnd'; 'dst'}
    % mean_dst: Distribution of Local-Optima-Means ...
    % Either Random ('rnd'), Or Intentionally Distributed ('dts'), to avoid Overlapping

    manyLocalOptima = 100;
    %% ----- (1/2) WHEN nGauss < manyLocalOptima ----- %
    if nGauss < manyLocalOptima
        %%----- Rotating & Squeezing -----%%
        rotation = cell(nGauss,1);
        for idx = 1:nGauss
            rotation{idx} = eye(d);  %% Initial Rotation Matrix for Each Gaussian
            for jdx = 1:d-1  %% Totally n(n-1)/2 Rotation Matrice
                for kdx = jdx+1:d
                    r = eye(d);
                    alpha = rot(idx)*(rand*pi - pi/2);  %% Angel from -pi/2 ~ pi/2
                    %%alpha = rot(idx)*(rand*pi/2 - pi/4);
                    r(jdx,jdx) = cos(alpha);
                    r(kdx,kdx) = cos(alpha);
                    r(jdx,kdx) = sin(alpha);
                    r(kdx,jdx) =-sin(alpha);
                end
            end
            for jdx = 1:d
                r(jdx,jdx) = r(jdx,jdx)*sqz(idx,jdx);  %% Squeezing on Dimension j, of nGaussian i
            end
            rotation{idx} = rotation{idx}*r;
        end
        
        %%----- Generate Covariance Matrix -----%%
        for idx = 1:nGauss
            variance = ones(nGauss,d)*sig(idx,1);
            variance(~variance) = 1E-9;  %% Set a Minimal Value in case of Zero %
            covmatrix = diag(variance(idx,:));
            covmatrix = rotation{idx}'*covmatrix*rotation{idx};
            cmInv{idx} = inv(covmatrix);
        end
        
    %% ----- (2/2) WHEN nGauss >= manyLocalOptima ----- %
    else
        %%----- Rotating & Squeezing -----%%
        rotation = cell(nGauss,1);
        for idx = 1:nGauss
            rotation{idx} = eye(d);  %% Initial Rotation Matrix for Each Gaussian
        end
        %%----- Generate Covariance Matrix -----%%
        for idx = 1:nGauss
            variance = ones(nGauss,d)*sig(idx,1);
            variance(~variance) = 1E-9;  %% Set a Minimal Value in case of Zero %
            covmatrix = diag(variance(idx,:));
            covmatrix = rotation{idx}'*covmatrix*rotation{idx};
            cmInv{idx} = inv(covmatrix);
        end
    end
    
    %%----- Generate Mean Vectors   -----%%
    switch mean_dst
        case 'rnd'  %% Random
            lbPos = rand(nGauss,d)*(ub-lb)+lb;
        case 'dst'
            lbPos = zeros(nGauss,d);  %% Init
            pt = 2;
            while power(pt,d) < nGauss
                pt = pt+1;
            end
            allpt = min(power(pt,d),1000);  %% The Search Space is Divided into ALLPT parts, on Each Dim: PT parts.
            pos = randperm(allpt);
            pos = pos(1:nGauss)-1;
            for idx = 1:nGauss
                str = dec2base(pos(idx), pt,d);
                for jdx = 1:d
                    lbPos(idx,jdx) = (str2double(str(jdx))+rand)/pt;
                end
            end
    end
    
    %%----- Assign Values to Components -----%%
    if isempty(rat)
        rat = 1;
    elseif size(rat,1)<nGauss && rat(1)~=1
        rat = [1;rat];  %% rat(1) = Global_Optimum / Global_Optimum
    end
    lbFit = gbf*rat';
    Lxbest = lbPos;
    Lfbest = glg06_fit(Lxbest);
    
end
