% glg06_plot.m
% Downloaded From: http://staff.itee.uq.edu.au/marcusg/msg.html (Accessed Date: 14-12-2016)
% Ref.Article: M.Gallagher & B.Yuan, "A General-purpose Tunable Landscape Generator,"
% IEEE Transactions on Evolutionary Computation, 10(5):590-603(2006).
% -----  -----  -----  -----  -----  -----  -----  -----  -----  ----- %
% Plot the Landscape - Dimension Must be 2.
% Slightly Modified by Felix (Felix.lou@my.cityu.edu.hk)
% Updated: 03-01-2017

function glg06_plot(ub,lb,N)

    if nargin~=3 || ub<=lb || N<10
        error('Wrong input ... ');
    end
    
    inc = (ub-lb)/N;
    x = lb:inc:ub;     %x coordinates
    y = lb:inc:ub;     %y coordinates

    d = length(y);
    pos = zeros(d*d,2);      %(x,y)coordinates for all sampling points

    for i = 1:d
        pos((i-1)*d+1:i*d,1) = x(i)*ones(d,1);
    end
    pos(:,2) = repmat(y',[d,1]);
    
    f = glg06_fit_2d(pos);	% evaluate individuals
    z = vec2mat(f,d)';	% transform into a matrix
    
    figure;
    rotate3d on
    colormap(gray);  %3D surface plot
    surfl(x,y,z);
    shading interp;    
%     figure;
%     [C,H]=contour(x,y,z);  %2D contour plot
end