#include<stdio.h>
#include<stdlib.h>
#include<stdarg.h>
#include<malloc.h>
#include<math.h>
#include<time.h>
#include"HdEA_Kernel.H"

void HdEA_Construction(HdEA *cur_EA, int no_dimension, int population_size, double crossover_rate)
{
	EvolutionaryAlgorithm_Construction(&(*cur_EA).EA_Info, no_dimension, population_size, population_size, crossover_rate, 0.0);

	FitnessTree_Construction(&(*cur_EA).Fitness_Tree, no_dimension, 1, 0);

	return;
}

void HdEA_Destruction(HdEA cur_EA)
{
	EvolutionaryAlgorithm_Destruction(cur_EA.EA_Info);

	FitnessTree_Destruction(cur_EA.Fitness_Tree);

	return;
}

void HdEA_Kernel(HdEA *cur_EA, int optimization_mode, int terminate_mode, double terminate_parameter, double (*fn_ptr)(double *chromosome))
{
	//============ terminate_mode: 0 = Fixed Generation    (terminate_parameter = max. no. of iteration)
	//                             1 = Fixed Accuracy	   (terminate_parameter = target accuracy)
	//                             2 = Fitness Improvement (terminate_parameter = delta imrpovement)
	//
	//============ optimization_mode: 0 = Minization, 1: Maximization

	int i, j;
	int individual_index_1, individual_index_2, optimal_individual_index;
	long clock_begin;

	double *unused_individual;

	int no_stopping_generation;
	double prev_optimum;

	no_stopping_generation = 0;
	(*cur_EA).EA_Info.no_Generation = 0;
	clock_begin = clock();

	unused_individual = malloc(sizeof(double) * (*cur_EA).EA_Info.no_Dimension);

	//============ Fitness Tree Initialization
	for(i=0; i< (*cur_EA).EA_Info.no_Dimension; ++i)
		for(j=0; j< 2; ++j)
			(*cur_EA).Fitness_Tree.Interval[i][j] = (*cur_EA).EA_Info.SearchSpace[i][j];

	//============ Population Initialization
	optimal_individual_index = 0;
	for(i=0;i< (*cur_EA).EA_Info.cur_Population_Size; ++i)
	{
		for(j=0;j< (*cur_EA).EA_Info.no_Dimension; ++j)
			(*cur_EA).EA_Info.cur_Population[i][j] = (double) rand() / RAND_MAX * ((*cur_EA).EA_Info.SearchSpace[j][1] - (*cur_EA).EA_Info.SearchSpace[j][0]) + (*cur_EA).EA_Info.SearchSpace[j][0];

		(*cur_EA).EA_Info.cur_Fitness[i] = (1.0 - 2.0 * optimization_mode) * (*fn_ptr)((*cur_EA).EA_Info.cur_Population[i]);


		FitnessTree_Insertion(&(*cur_EA).Fitness_Tree, (*cur_EA).EA_Info.cur_Population[i], (*cur_EA).EA_Info.cur_Fitness[i]);

		if(i==0 || (*cur_EA).EA_Info.cur_Fitness[i] < (*cur_EA).EA_Info.Optimal_Fitness)
		{
			(*cur_EA).EA_Info.Optimal_Fitness = (*cur_EA).EA_Info.cur_Fitness[i];
			optimal_individual_index = i;
		}
	}

	for(j=0;j< (*cur_EA).EA_Info.no_Dimension; ++j)
		(*cur_EA).EA_Info.Optimal_Individual[j] = (*cur_EA).EA_Info.cur_Population[optimal_individual_index][j];

	++(*cur_EA).EA_Info.no_Generation;

	(*cur_EA).EA_Info.Convergence = realloc((*cur_EA).EA_Info.Convergence, sizeof(double) * (*cur_EA).EA_Info.no_Generation);
	(*cur_EA).EA_Info.Convergence[(*cur_EA).EA_Info.no_Generation - 1] = (*cur_EA).EA_Info.Optimal_Fitness;

	(*cur_EA).EA_Info.Processing_Time = realloc((*cur_EA).EA_Info.Processing_Time, sizeof(double) * (*cur_EA).EA_Info.no_Generation);
	(*cur_EA).EA_Info.Processing_Time[(*cur_EA).EA_Info.no_Generation - 1] = (double) (clock() - clock_begin) / CLOCKS_PER_SEC;
	//===================================================================================================

	//============ Evoluation
	do {
		//----------- Mutation
		for(i=0; i< (*cur_EA).EA_Info.cur_Population_Size; ++i)
		{
			for(j=0; j< (*cur_EA).EA_Info.no_Dimension; ++j)
				(*cur_EA).EA_Info.tmp_Population[i][j] = (*cur_EA).EA_Info.cur_Population[i][j];

			HdEA_Mutation(&(*cur_EA).EA_Info.tmp_Population[i],
						  (*cur_EA).EA_Info.no_Dimension,
						  (*cur_EA).EA_Info.SearchSpace,
						  &(*cur_EA).Fitness_Tree);
		}

		//------------ Cross-Over
		for(i=0; i< (*cur_EA).EA_Info.nxt_Population_Size; ++i)
		{
			individual_index_1 = rand() % (*cur_EA).EA_Info.cur_Population_Size;
			individual_index_2 = rand() % (*cur_EA).EA_Info.cur_Population_Size;
			while(individual_index_2 == individual_index_1)
				individual_index_2 = rand() % (*cur_EA).EA_Info.cur_Population_Size;

			CrossOver((*cur_EA).EA_Info.cur_Population[i],
					  (*cur_EA).EA_Info.tmp_Population[individual_index_2],
					  &(*cur_EA).EA_Info.nxt_Population[i],
					  &unused_individual,
					  (*cur_EA).EA_Info.no_Dimension,
					  1);
		}

		//------------ Fitness Measurement
		for(i=0; i< (*cur_EA).EA_Info.nxt_Population_Size; ++i)
		{
			(*cur_EA).EA_Info.nxt_Fitness[i] = (1.0 - 2.0 * optimization_mode) * (*fn_ptr)((*cur_EA).EA_Info.nxt_Population[i]);

			FitnessTree_Insertion(&(*cur_EA).Fitness_Tree, (*cur_EA).EA_Info.nxt_Population[i], (*cur_EA).EA_Info.nxt_Fitness[i]);
		}

		//------------ Selection
		Parallel1Plus1_Selection(&(*cur_EA).EA_Info);

		if(terminate_mode == 2)
		{
			if((*cur_EA).EA_Info.no_Generation > 0)
			{
				if((prev_optimum - (*cur_EA).EA_Info.Optimal_Fitness) / prev_optimum < terminate_parameter)
					++no_stopping_generation;
				else
					no_stopping_generation = 0;
			}
			prev_optimum = (*cur_EA).EA_Info.Optimal_Fitness;
		}

		++(*cur_EA).EA_Info.no_Generation;

		(*cur_EA).EA_Info.Convergence = realloc((*cur_EA).EA_Info.Convergence, sizeof(double) * (*cur_EA).EA_Info.no_Generation);
		(*cur_EA).EA_Info.Convergence[(*cur_EA).EA_Info.no_Generation - 1] = (*cur_EA).EA_Info.Optimal_Fitness;

		(*cur_EA).EA_Info.Processing_Time = realloc((*cur_EA).EA_Info.Processing_Time, sizeof(double) * (*cur_EA).EA_Info.no_Generation);
		(*cur_EA).EA_Info.Processing_Time[(*cur_EA).EA_Info.no_Generation - 1] = (double) (clock() - clock_begin) / CLOCKS_PER_SEC;

		if((*cur_EA).EA_Info.no_Generation % 200 == 0)
			printf("%dth iteration = %1.8lf\n", (*cur_EA).EA_Info.no_Generation, (*cur_EA).EA_Info.Optimal_Fitness);

	} while((terminate_mode == 0 && terminate_parameter > (*cur_EA).EA_Info.no_Generation) ||
			(terminate_mode == 1 && ((1.0 - 2.0 * optimization_mode) * terminate_parameter < (*cur_EA).EA_Info.Optimal_Fitness) && (*cur_EA).EA_Info.no_Generation < HDEA_MAX_GENERATION) ||
			(terminate_mode == 2 && no_stopping_generation < HDEA_STOPPING_GENERATION));

	optimal_individual_index = -1;
	for(i=0; i< (*cur_EA).EA_Info.cur_Population_Size; ++i)
	{
		(*cur_EA).EA_Info.cur_Fitness[i] *= (1.0 - 2.0 * optimization_mode);
		if((*cur_EA).EA_Info.Optimal_Fitness > (*cur_EA).EA_Info.cur_Fitness[i])
		{
			optimal_individual_index = i;
			(*cur_EA).EA_Info.Optimal_Fitness = (*cur_EA).EA_Info.cur_Fitness[i];
		}
	}

	(*cur_EA).EA_Info.Optimal_Fitness *= (1.0 - 2.0 * optimization_mode);
	if(optimal_individual_index > -1)
		for(i=0; i< (*cur_EA).EA_Info.no_Dimension; ++i)
			(*cur_EA).EA_Info.Optimal_Individual[i] = (*cur_EA).EA_Info.cur_Population[optimal_individual_index][i];

	free(unused_individual);

	return;
}

void HdEA_Mutation(double **cur_Individual, int no_Dimension, double **Search_Space, FitnessTree *cur_Tree)
{
	int i;
	double individual_distance;
	double tgr_Fitness, Ap, cur_gene;
	FitnessNode *tgr_Node;

	//============ Serach the leaf
	tgr_Node = (*cur_Tree).Root;
	while ((*tgr_Node).Dimension > -1)
	{
		if((*cur_Individual)[(*tgr_Node).Dimension] < (*tgr_Node).Threshold)
			tgr_Node = (*tgr_Node).Child_Left;
		else
			tgr_Node = (*tgr_Node).Child_Right;
	}

	tgr_Fitness = (*tgr_Node).Optimal_Fitness;

	while((*tgr_Node).Parent != NULL && (*(*tgr_Node).Parent).Optimal_Fitness < tgr_Fitness)
		tgr_Node = (*tgr_Node).Parent;

	FitnessNode_Interval(tgr_Node, cur_Tree);

	individual_distance = 0.0;
	for(i=0; i< no_Dimension; ++i)
		individual_distance += fabs((*cur_Individual)[i] - (*tgr_Node).Optimal_Data[i]);

	if(individual_distance < 1e-8)
	{
		for(i=0; i<no_Dimension; ++i)
		{
			Ap = (double) (rand() + 1) / (RAND_MAX + 1);
			cur_gene = (*cur_Individual)[i];
			(*cur_Individual)[i] = cur_gene + Ap * 2.0 * ((double) (rand() % 2) - 0.5) * ((double) (rand() + 1) / (RAND_MAX+1)) * ((*cur_Tree).cur_Interval[i][1] - (*cur_Tree).cur_Interval[i][0]);
			while((*cur_Individual)[i] < Search_Space[i][0] || (*cur_Individual)[i] > Search_Space[i][1])
				(*cur_Individual)[i] = cur_gene + Ap * 2.0 * ((double) (rand() % 2) - 0.5) * ((double) (rand() + 1) / (RAND_MAX+1)) * ((*cur_Tree).cur_Interval[i][1] - (*cur_Tree).cur_Interval[i][0]);
		}
	}
	else
	{
		Ap = (double) (rand() + 1) / (RAND_MAX + 1);
		for(i=0; i<no_Dimension; ++i)
			(*cur_Individual)[i] = Ap * (*cur_Individual)[i] + (1.0 - Ap) * (*tgr_Node).Optimal_Data[i];
	}

	return;
}

void CrossOver(double *Parent_1, double *Parent_2, double **Child_1, double **Child_2, int no_Dimension, int no_Swapping)
{
	int i;
	int swapping_index;

	for(i=0; i< no_Dimension; ++i)
	{
		(*Child_1)[i] = Parent_1[i];
		(*Child_2)[i] = Parent_2[i];
	}

	for(i=0; i< no_Swapping; ++i)
	{
		swapping_index = rand() % no_Dimension;

		(*Child_1)[swapping_index] = Parent_2[swapping_index];
		(*Child_2)[swapping_index] = Parent_1[swapping_index];
	}

	return;
}

void Parallel1Plus1_Selection(EvolutionaryAlgorithm *EA_Info)
{
	int i, j;

	for(i=0; i< (*EA_Info).cur_Population_Size; ++i)
	{
		if((*EA_Info).nxt_Fitness[i] < (*EA_Info).cur_Fitness[i])
		{
			for(j=0; j < (*EA_Info).no_Dimension; ++j)
				(*EA_Info).cur_Population[i][j] = (*EA_Info).nxt_Population[i][j];
			(*EA_Info).cur_Fitness[i] = (*EA_Info).nxt_Fitness[i];
		}
	}

	for(i=0; i< (*EA_Info).cur_Population_Size; ++i)
	{
		if((*EA_Info).Optimal_Fitness > (*EA_Info).cur_Fitness[i])
		{
			(*EA_Info).Optimal_Fitness = (*EA_Info).cur_Fitness[i];
			for(j=0; j < (*EA_Info).no_Dimension; ++j)
				(*EA_Info).Optimal_Individual[j] = (*EA_Info).cur_Population[i][j];
		}
	}

	return;
}

void EvolutionaryAlgorithm_Construction(EvolutionaryAlgorithm *cur_EA, int no_dimension, int cur_population_size, int nxt_population_size, double crossover_rate, double mutation_rate)
{
	int i;

	(*cur_EA).no_Dimension = no_dimension;
	(*cur_EA).SearchSpace = malloc(sizeof(double*) * no_dimension);
	for(i=0; i<no_dimension; ++i)
		(*cur_EA).SearchSpace[i] = malloc(sizeof(double) * 2);

	(*cur_EA).Mutation_Rate = mutation_rate;
	(*cur_EA).CrossOver_Rate = crossover_rate;

	(*cur_EA).no_CrossOver_Point = 0;

	(*cur_EA).cur_Population_Size = cur_population_size;
	(*cur_EA).nxt_Population_Size = nxt_population_size;

	(*cur_EA).cur_Population = malloc(sizeof(double*) * cur_population_size);
	for(i=0; i< (*cur_EA).cur_Population_Size; ++i)
		(*cur_EA).cur_Population[i] = malloc(sizeof(double) * no_dimension);

	(*cur_EA).tmp_Population = malloc(sizeof(double*) * cur_population_size);
	for(i=0; i< (*cur_EA).cur_Population_Size; ++i)
		(*cur_EA).tmp_Population[i] = malloc(sizeof(double) * no_dimension);

	(*cur_EA).nxt_Population = malloc(sizeof(double*) * nxt_population_size);
	for(i=0; i< (*cur_EA).nxt_Population_Size; ++i)
		(*cur_EA).nxt_Population[i] = malloc(sizeof(double) * no_dimension);

	(*cur_EA).cur_Fitness = malloc(sizeof(double) * cur_population_size);
	(*cur_EA).tmp_Fitness = malloc(sizeof(double) * cur_population_size);
	(*cur_EA).nxt_Fitness = malloc(sizeof(double) * nxt_population_size);

	(*cur_EA).Optimal_Individual = malloc(sizeof(double) * no_dimension);

	(*cur_EA).Chromosome_Index = malloc(sizeof(int) * (cur_population_size + nxt_population_size));
	(*cur_EA).Chromosome_Fitness = malloc(sizeof(double) * (cur_population_size + nxt_population_size));
	(*cur_EA).Chromosome_SelectionPressure = malloc(sizeof(double) * (cur_population_size + nxt_population_size));
	(*cur_EA).Chromosome_Probability = malloc(sizeof(double) * (cur_population_size + nxt_population_size));

	(*cur_EA).Processing_Time = malloc(sizeof(double) * HDEA_MAX_GENERATION);
	(*cur_EA).Convergence = malloc(sizeof(double) * HDEA_MAX_GENERATION);
	(*cur_EA).Diversity = malloc(sizeof(double) * HDEA_MAX_GENERATION);

	return;
}

void EvolutionaryAlgorithm_Destruction(EvolutionaryAlgorithm cur_EA)
{
	int i;

	for(i=0; i<cur_EA.no_Dimension; ++i)
		free(cur_EA.SearchSpace[i]);
	free(cur_EA.SearchSpace);

	for(i=0; i< cur_EA.cur_Population_Size; ++i)
		free(cur_EA.cur_Population[i]);
	free(cur_EA.cur_Population);

	for(i=0; i< cur_EA.cur_Population_Size; ++i)
		free(cur_EA.tmp_Population[i]);
	free(cur_EA.tmp_Population);

	for(i=0; i< cur_EA.nxt_Population_Size; ++i)
		free(cur_EA.nxt_Population[i]);
	free(cur_EA.nxt_Population);

	free(cur_EA.cur_Fitness);
	free(cur_EA.tmp_Fitness);
	free(cur_EA.nxt_Fitness);

	free(cur_EA.Optimal_Individual);

	free(cur_EA.Chromosome_Index);
	free(cur_EA.Chromosome_Fitness);
	free(cur_EA.Chromosome_SelectionPressure);
	free(cur_EA.Chromosome_Probability);

	free(cur_EA.Processing_Time);
	free(cur_EA.Convergence);
	free(cur_EA.Diversity);

	return;
}

void FitnessTree_Construction(FitnessTree *cur_Tree, int cur_Dimension, int interval_Size, int max_archive_size)
{
	int i;

	(*cur_Tree).no_Dimension = cur_Dimension;
	(*cur_Tree).no_Leaf = 0;
	(*cur_Tree).Root = malloc(sizeof(FitnessNode));
	(*(*cur_Tree).Root).Dimension = -1;
	(*(*cur_Tree).Root).Parent = NULL;
	(*(*cur_Tree).Root).Optimal_Data = malloc(sizeof(double) * cur_Dimension);
	(*(*cur_Tree).Root).Child_Left = NULL;
	(*(*cur_Tree).Root).Child_Right = NULL;
	(*(*cur_Tree).Root).no_Visit = 0;
	(*cur_Tree).Current_ID = 0;

	(*cur_Tree).AxisBoundary_Set = malloc(sizeof(int) * cur_Dimension);
	(*cur_Tree).Interval = malloc(sizeof(double*) * cur_Dimension);
	(*cur_Tree).cur_Interval = malloc(sizeof(double*) * cur_Dimension);
	for(i=0; i< cur_Dimension; ++i)
	{
		(*cur_Tree).Interval[i] = malloc(sizeof(double) * 2);
		(*cur_Tree).cur_Interval[i] = malloc(sizeof(double) * 2);
	}

	(*cur_Tree).no_Revisit = 0;

	return;
}

void FitnessTree_Destruction(FitnessTree cur_Tree)
{
	int i;

	FitnessNode_Destruction(*cur_Tree.Root);


	free(cur_Tree.AxisBoundary_Set);
	free(cur_Tree.Root);

	for(i=0; i< cur_Tree.no_Dimension; ++i)
	{
		free(cur_Tree.Interval[i]);
		free(cur_Tree.cur_Interval[i]);
	}
	free(cur_Tree.Interval);
	free(cur_Tree.cur_Interval);

	return;

}

void FitnessNode_Contruction(FitnessNode *parent_Node, FitnessNode *child_Node, int cur_Dimension)
{
	(*child_Node).ID_Self = -1;
	(*child_Node).ID_Parent = -1;
	(*child_Node).Dimension = -1;
	(*child_Node).Threshold = 0.0;
	(*child_Node).Parent = parent_Node;
	(*child_Node).Child_Left = NULL;
	(*child_Node).Child_Right = NULL;
	(*child_Node).no_Visit = 1;
	(*child_Node).Optimal_Data = malloc(sizeof(double) * cur_Dimension);

	return;
}

void FitnessNode_Destruction(FitnessNode cur_Node)
{
	if(cur_Node.Child_Left != NULL)
	{
		FitnessNode_Destruction(*cur_Node.Child_Left);
		free(cur_Node.Child_Left);
	}

	if(cur_Node.Child_Right != NULL)
	{
		FitnessNode_Destruction(*cur_Node.Child_Right);
		free(cur_Node.Child_Right);
	}

	free(cur_Node.Optimal_Data);

	return;
}

void FitnessTree_Insertion(FitnessTree *cur_Tree, double *cur_Data, double cur_Fitness)
{
	int i, cur_Dimension;
	double interval_diff;
	FitnessNode *cur_Node, *parent_Node;

	cur_Dimension = (*cur_Tree).no_Dimension;
	cur_Node = FitnessNode_Search((*cur_Tree).Root, &(*cur_Tree).cur_Interval, cur_Data);

	if((*cur_Node).Parent == NULL && (*cur_Node).no_Visit == 0)
	{
		//============ Root Node
		++(*cur_Node).no_Visit;
		for(i=0; i< cur_Dimension; ++i)
			(*cur_Node).Optimal_Data[i] = cur_Data[i];
		(*cur_Node).Optimal_Fitness = cur_Fitness;
	}
	else
	{
		for(i=0; i< cur_Dimension; ++i)
			if((*cur_Node).Optimal_Data[i] != cur_Data[i] &&
			   ((*cur_Node).Dimension == -1 || interval_diff < fabs((*cur_Node).Optimal_Data[i] - cur_Data[i])))
			{
				(*cur_Node).Dimension = i;
				(*cur_Node).Threshold = 0.5 * ((*cur_Node).Optimal_Data[i] + cur_Data[i]);
				interval_diff = fabs((*cur_Node).Optimal_Data[i] - cur_Data[i]);
			}

		(*cur_Node).Child_Left = malloc(sizeof(FitnessNode));
		(*cur_Node).Child_Right = malloc(sizeof(FitnessNode));

		FitnessNode_Contruction(cur_Node, (*cur_Node).Child_Left, cur_Dimension);
		FitnessNode_Contruction(cur_Node, (*cur_Node).Child_Right, cur_Dimension);

		(*cur_Tree).no_Leaf += 2;

		if((*cur_Node).Optimal_Data[(*cur_Node).Dimension] < cur_Data[(*cur_Node).Dimension])
		{
			for(i=0; i< cur_Dimension; ++i)
			{
				(*(*cur_Node).Child_Left).Optimal_Data[i] = (*cur_Node).Optimal_Data[i];
				(*(*cur_Node).Child_Right).Optimal_Data[i] = cur_Data[i];
			}
			(*(*cur_Node).Child_Left).Optimal_Fitness = (*cur_Node).Optimal_Fitness;
			(*(*cur_Node).Child_Right).Optimal_Fitness = cur_Fitness;
		}
		else
		{
			for(i=0; i< cur_Dimension; ++i)
			{
				(*(*cur_Node).Child_Left).Optimal_Data[i] = cur_Data[i];
				(*(*cur_Node).Child_Right).Optimal_Data[i] = (*cur_Node).Optimal_Data[i];
			}
			(*(*cur_Node).Child_Left).Optimal_Fitness = cur_Fitness;
			(*(*cur_Node).Child_Right).Optimal_Fitness = (*cur_Node).Optimal_Fitness;
		}

		//============ Path Back-tracking for optimal fitness
		parent_Node = cur_Node;
		 do {
			if((*parent_Node).Optimal_Fitness > cur_Fitness)
			{
				(*parent_Node).Optimal_Fitness = cur_Fitness;
				for(i=0; i< cur_Dimension; ++i)
					(*parent_Node).Optimal_Data[i] = cur_Data[i];
				parent_Node = (*parent_Node).Parent;
			}
			else
				break;
		 } while(parent_Node != NULL);
	}

	return;
}

void FitnessNode_Interval(FitnessNode *tgr_Node, FitnessTree *cur_Tree)
{
	int i;
	FitnessNode *cur_Node;

	for(i=0; i< (*cur_Tree).no_Dimension; ++i)
	{
		(*cur_Tree).cur_Interval[i][0] = (*cur_Tree).Interval[i][0];
		(*cur_Tree).cur_Interval[i][1] = (*cur_Tree).Interval[i][1];
	}

	cur_Node = (*cur_Tree).Root;
	while (cur_Node != tgr_Node && (*cur_Node).Dimension > -1)
	{
		if((*tgr_Node).Optimal_Data[(*cur_Node).Dimension] < (*cur_Node).Threshold)
		{
			(*cur_Tree).cur_Interval[(*cur_Node).Dimension][1] = (*cur_Node).Threshold;
			cur_Node = (*cur_Node).Child_Left;
		}
		else
		{
			(*cur_Tree).cur_Interval[(*cur_Node).Dimension][0] = (*cur_Node).Threshold;
			cur_Node = (*cur_Node).Child_Right;
		}
	}

	return;
}

FitnessNode *FitnessNode_Search(FitnessNode *root_Node, double ***cur_Interval, double *cur_Data)
{
	FitnessNode *cur_Node;

	cur_Node = root_Node;
	while ((*cur_Node).Dimension > -1)
	{
		if(cur_Data[(*cur_Node).Dimension] < (*cur_Node).Threshold)
		{
			(*cur_Interval)[(*cur_Node).Dimension][1] = (*cur_Node).Threshold;
			cur_Node = (*cur_Node).Child_Left;
		}
		else
		{
			(*cur_Interval)[(*cur_Node).Dimension][0] = (*cur_Node).Threshold;
			cur_Node = (*cur_Node).Child_Right;
		}
	}

	return cur_Node;
}

