#ifndef HDEA_KERNEL

#define HDEA_KERNEL

typedef struct EVOLUTIONARYALGORITHM {
	int no_Dimension;
	double **SearchSpace;

	int no_GeneBit;

	int Mutation_Mode;
	double Mutation_Rate;

	int CrossOver_Mode;
	int no_CrossOver_Point;
	double CrossOver_Rate;

	int Selection_Mode;
	int Selection_TournamentSize;

	int cur_Population_Size;
	int nxt_Population_Size;

	double **cur_Population;
	double **tmp_Population;
	double **nxt_Population;

	double *cur_Fitness;
	double *tmp_Fitness;
	double *nxt_Fitness;

	double *Optimal_Individual;
	double Optimal_Fitness;

	int *Chromosome_Index;
	double *Chromosome_Fitness;
	double *Chromosome_SelectionPressure;
	double *Chromosome_Probability;

	double *Convergence;
	double *Diversity;
	double *Processing_Time;

	int no_Generation;
} EvolutionaryAlgorithm;

struct FITNESSNODE {
	int ID_Self;
	int ID_Parent;

	double Optimal_Fitness;
	double *Optimal_Data;

	double no_Visit;
	int Dimension;
	double Threshold;

	struct FITNESSNODE *Parent;
	struct FITNESSNODE *Child_Left;
	struct FITNESSNODE *Child_Right;
};

typedef struct FITNESSNODE FitnessNode;

typedef struct FITNESSTREE {
	int Current_ID;

	int no_Dimension;
	int no_Leaf;
	double **Interval;

	int max_Archive_Size;
	int no_AxisBoundary;
	int *AxisBoundary_Set;

	FitnessNode *Root;
	double **cur_Interval;

	int no_Revisit;

	int no_Visit;
	int Max_no_Visit;
} FitnessTree;

typedef struct HDEA {

	EvolutionaryAlgorithm EA_Info;

	FitnessTree Fitness_Tree;

} HdEA;

#define HDEA_MAX_GENERATION 500000
#define HDEA_STOPPING_GENERATION 10

double (*HDEA_TESTFUNCTION)(double*);

void HdEA_Construction(HdEA*, int, int, double);
void HdEA_Destruction(HdEA);

void HdEA_Kernel(HdEA*, int, int, double, double (*fn_ptr)(double*));

void HdEA_Mutation(double**, int, double**, FitnessTree*);
void CrossOver(double*, double*, double**, double**, int, int);
void Parallel1Plus1_Selection(EvolutionaryAlgorithm*);

void EvolutionaryAlgorithm_Construction(EvolutionaryAlgorithm*, int, int, int, double, double);
void EvolutionaryAlgorithm_Destruction(EvolutionaryAlgorithm);

void FitnessTree_Construction(FitnessTree*, int, int, int);
void FitnessTree_Destruction(FitnessTreeNode);

void FitnessNode_Contruction(FitnessNode*, FitnessNode*, int);
void FitnessNode_Destruction(FitnessNode);

void FitnessTree_Insertion(FitnessTree*, double*, double);

void FitnessNode_Interval(FitnessNode*, FitnessTree*);

FitnessNode *FitnessNode_Search(FitnessNode*, double***, double*);

#endif 