#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>
#include<math.h>
#include<time.h>
#include"MyProblem.H"
#include"Optimization_TestFunction_Kernel.H"
#include"HdEA_Kernel.H"

void HdEA_IEEETransECTestFunction();
void HdEA_MyProblem();

int main()
{
	HdEA_IEEETransECTestFunction();

	HdEA_MyProblem();

	return 0;
}

void HdEA_IEEETransECTestFunction()
{
	int i;

	int testfunction_index;
	char testfunction_name[256];
	int no_dimension;
	int optimization_mode, max_generation;
	int population_size, no_evaluation;
	double crossover_rate;

	int terminate_mode;
	double terminate_parameter;

	HdEA cur_HdEA;

	srand((unsigned) time(NULL));
	

	//------------ Parameters of HdEA
	population_size = 20;
	crossover_rate = 0.95;

	//------------ Parameters of the test function
	testfunction_index = 1;		// test function 1 - 34

	no_evaluation = 40000;
	max_generation = (int) ceil(no_evaluation / population_size);

	no_dimension = 40;

	optimization_mode = 0;					// optimization_mode: 0 = minimization, 1 = maximization

	terminate_mode = 0;						// terminate_mode: 0 = terminate after 'terminate_parameter' generations
											//				   1 = terminate when the best-found fitness reaches 'terminate_parameter'
	terminate_parameter = max_generation;

	//------------ Initialization for using 'Optimization_TestFunction_Kernel': BEGIN
	Optimization_TestFunction_Dimension = no_dimension;
	Optimization_TestFunction_Construction();
	Optimization_TestFunction_Manager_RealValued(testfunction_index, testfunction_name);
	//------------ Initialization for using 'Optimization_TestFunction_Kernel': END



	//------------ Initialize HdEA: BEGIN
	HdEA_Construction(&cur_HdEA, no_dimension, population_size, crossover_rate);

	for(i=0; i< no_dimension; ++i)
	{
		cur_HdEA.EA_Info.SearchSpace[i][0] = 0.0;
		cur_HdEA.EA_Info.SearchSpace[i][1] = 1.0;
	}
	//------------ Initialize HdEA: END


	HdEA_Kernel(&cur_HdEA, optimization_mode, terminate_mode, terminate_parameter, Optimization_TestFunction_Pointer);

	printf("The optimal fitness value = %1.10lf\n", cur_HdEA.EA_Info.Optimal_Fitness);


	//------------ Free the memory occupied by HdEA
	HdEA_Destruction(cur_HdEA);
	

	//------------ Free the memory occupied by 'Optimization_TestFunction_Kernel'
	Optimization_TestFunction_Destruction();

	return;
}

void HdEA_MyProblem()
{
	int i;
	int no_dimension;
	int optimization_mode, max_generation;
	int population_size, no_evaluation;
	double crossover_rate;

	int terminate_mode;
	double terminate_parameter;

	HdEA cur_HdEA;

	srand((unsigned) time(NULL));
	

	//------------ Parameters of HdEA
	population_size = 20;
	crossover_rate = 0.95;

	no_evaluation = 40000;
	max_generation = (int) ceil(no_evaluation / population_size);

	no_dimension = 2;

	optimization_mode = 0;					// optimization_mode: 0 = minimization, 1 = maximization

	terminate_mode = 0;						// terminate_mode: 0 = terminate after 'terminate_parameter' generations
											//				   1 = terminate when the best-found fitness reaches 'terminate_parameter'
	terminate_parameter = max_generation;

	//------------ Initialize HdEA: BEGIN
	HdEA_Construction(&cur_HdEA, no_dimension, population_size, crossover_rate);

	for(i=0; i< no_dimension; ++i)
	{
		cur_HdEA.EA_Info.SearchSpace[i][0] = 0.0;
		cur_HdEA.EA_Info.SearchSpace[i][1] = 1.0;
	}
	//------------ Initialize HdEA: END

	MyProblem_Parameter[0] = 0.5;
	MyProblem_Parameter[1] = 0.5;

	HdEA_Kernel(&cur_HdEA, optimization_mode, terminate_mode, terminate_parameter, MyProblem);

	printf("The optimal fitness value = %1.10lf\n", cur_HdEA.EA_Info.Optimal_Fitness);


	//------------ Free the memory occupied by HdEA
	HdEA_Destruction(cur_HdEA);

	return;
}

