#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>
#include<math.h>
#include<time.h>
#include"Optimization_TestFunction_Kernel.H"

double Optimization_TestFunction_Foxholes_a1[] = {-32.0, -16.0, 0, 16.0, 32.0, -32.0,
										-32.0, -16.0, 0, 16.0, 32.0, -32.0,
										-32.0, -16.0, 0, 16.0, 32.0, -32.0,
										-32.0, -16.0, 0, 16.0, 32.0, -32.0,
										-32.0, -16.0, 0, 16.0, 32.0, -32.0};
double Optimization_TestFunction_Foxholes_a2[] = {-32.0, -32.0, -32.0, -32.0, -32.0,
										-16.0, -16.0, -16.0, -16.0, -16.0,
										0.0, 0.0, 0.0, 0.0, 0.0,
										16.0, 16.0, 16.0, 16.0, 16.0,
										32.0, 32.0, 32.0, 32.0, 32.0};

double Optimization_TestFunction_OddSquare_b[] = {1.0, 1.3, 0.8, -0.4, -1.3,
												  1.6, -2.0, -6.0, 0.5, 1.4};

void Optimization_TestFunction_Construction()
{
	Optimization_TestFunction_ScaledSolution = malloc(sizeof(double) * Optimization_TestFunction_Dimension);
	return;
}

void Optimization_TestFunction_Destruction()
{
	free(Optimization_TestFunction_ScaledSolution);
	return;
}

void Optimization_TestFunction_SolutionScaling(double *solution, double min_X, double dX)
{
	int i;

	for(i=0; i <Optimization_TestFunction_Dimension; ++i)
		Optimization_TestFunction_ScaledSolution[i] = solution[i]*dX - min_X;

	return;
}

void Optimization_TestFunction_Manager_RealValued(int Optimization_TestFunction_Index, char *Optimization_TestFunction_Name)
{
	switch(Optimization_TestFunction_Index)
	{
		case 1:			//------------ Sphereical
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Sphereical;
			sprintf(Optimization_TestFunction_Name, "Spherical");
			break;
		case 2:			//------------ Schwefel 2.22
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Schwefel2_22;
			sprintf(Optimization_TestFunction_Name, "Schwefel2-22");
			break;
		case 3:			//------------ Schwefel 1.02
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Schwefel1_02;
			sprintf(Optimization_TestFunction_Name, "Schwefel1-02");
			break;
		case 4:			//------------ Schwefel 2.21
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Schwefel2_21;
			sprintf(Optimization_TestFunction_Name, "Schwefel2-21");
			break;
		case 5:			//------------ Rosenbrock
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Rosenbrock;
			sprintf(Optimization_TestFunction_Name, "Rosenbrock");
			break;
		case 6:			//------------ Quartic
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Quartic;
			sprintf(Optimization_TestFunction_Name, "Quartic");
			break;
		case 7:			//------------ Generalized Rastrigin
			Optimization_TestFunction_Pointer = Optimization_TestFunction_GeneralizedRastrigin;
			sprintf(Optimization_TestFunction_Name, "GeneralizedRastrigin");
			break;
		case 8:			//------------ Generalized Griewank
			Optimization_TestFunction_Pointer = Optimization_TestFunction_GeneralizedGriewank;
			sprintf(Optimization_TestFunction_Name, "GeneralizedGriewank");
			break;
		case 9:			//------------ Schwefel 2.26
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Schwefel2_26;
			sprintf(Optimization_TestFunction_Name, "Schwefel2-26");
			break;
		case 10:			//------------ Ackley
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Ackley;
			sprintf(Optimization_TestFunction_Name, "Ackley");
			break;
		case 11:		//------------ Foxholes
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Foxholes;
			sprintf(Optimization_TestFunction_Name, "Foxholes");
			break;
		case 12:		//------------ Six-Hump Camel-Back
			Optimization_TestFunction_Pointer = Optimization_TestFunction_SixHumpCamelBack;
			sprintf(Optimization_TestFunction_Name, "SixHumpCamelBack");
			break;
		case 13:		//------------ Branin
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Branin;
			sprintf(Optimization_TestFunction_Name, "Branin");
			break;
		case 14:		//------------ Goldstein-Price
			Optimization_TestFunction_Pointer = Optimization_TestFunction_GoldsteinPrice;
			sprintf(Optimization_TestFunction_Name, "GoldsteinPrice");
			break;
		case 15:		//------------ High Conditioned Elliptic
			Optimization_TestFunction_Pointer = Optimization_TestFunction_HighConditionedElliptic;
			sprintf(Optimization_TestFunction_Name, "HighConditionedElliptic");
			break;
		case 16:		//------------ Weierstrass
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Weierstrass;
			sprintf(Optimization_TestFunction_Name, "Weierstrass");
			break;
		case 17:		//------------ Hybrid Composition 1
			Optimization_TestFunction_Pointer = Optimization_TestFunction_HybridComposition01;
			sprintf(Optimization_TestFunction_Name, "HybridComposition01");
			break;
		case 18:		//------------ Levy
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Levy;
			sprintf(Optimization_TestFunction_Name, "Levy");
			break;
		case 19:		//------------ Zakharov
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Zakharov;
			sprintf(Optimization_TestFunction_Name, "Zakharov");
			break;
		case 20:		//------------ Alpine
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Alpine;
			sprintf(Optimization_TestFunction_Name, "Alpine");
			break;
		case 21:		//------------ Pathological
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Pathological;
			sprintf(Optimization_TestFunction_Name, "Pathological");
			break;
		case 22:		//------------ InvertedCosineWave
			Optimization_TestFunction_Pointer = Optimization_TestFunction_InvertedCosineWave;
			sprintf(Optimization_TestFunction_Name, "InvertedCosineWave");
			break;
		case 23:		//------------ InvertedCosineMixture
			Optimization_TestFunction_Pointer = Optimization_TestFunction_InvertedCosineMixture;
			sprintf(Optimization_TestFunction_Name, "InvertedCosineMixture");
			break;
		case 24:		//------------ EpistaticMichalewicz
			Optimization_TestFunction_Pointer = Optimization_TestFunction_EpistaticMichalewicz;
			sprintf(Optimization_TestFunction_Name, "EpistaticMichalewicz");
			break;
		case 25:		//------------ LevyMontalvo
			Optimization_TestFunction_Pointer = Optimization_TestFunction_LevyMontalvo;
			sprintf(Optimization_TestFunction_Name, "LevyMontalvo");
			break;
		case 26:		//------------ Neumaier3
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Neumaier3;
			sprintf(Optimization_TestFunction_Name, "Neumaier3");
			break;
		case 27:		//------------ OddSquare
			Optimization_TestFunction_Pointer = Optimization_TestFunction_OddSquare;
			sprintf(Optimization_TestFunction_Name, "OddSquare");
			break;
		case 28:		//------------ Paviani
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Paviani;
			sprintf(Optimization_TestFunction_Name, "Paviani");
			break;
		case 29:		//------------ Periodic
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Periodic;
			sprintf(Optimization_TestFunction_Name, "Periodic");
			break;
		case 30:		//------------ Salomon
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Salomon;
			sprintf(Optimization_TestFunction_Name, "Salomon");
			break;
		case 31:		//------------ Shubert
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Shubert;
			sprintf(Optimization_TestFunction_Name, "Shubert");
			break;
		case 32:		//------------ Sinusoidal
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Sinusoidal;
			sprintf(Optimization_TestFunction_Name, "Sinusoidal");
			break;
		case 33:		//------------ Michalewicz
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Michalewicz;
			sprintf(Optimization_TestFunction_Name, "Michalewicz");
			break;
		case 34:		//------------ Whitely
			Optimization_TestFunction_Pointer = Optimization_TestFunction_Whitely;
			sprintf(Optimization_TestFunction_Name, "Whitely");
			break;
	}

	return;
}

//================================================================================================================
//==================================== Real Value Objective Function =============================================
//================================================================================================================

double Optimization_TestFunction_Sphereical(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 100.0, 200.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value += pow(Optimization_TestFunction_ScaledSolution[i], 2);

	return fitness_value;
}

double Optimization_TestFunction_Schwefel2_22(double *solution)
{
	int i;
	double sum_x, prd_x, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 10.0, 20.0);

	sum_x = 0.0;
	prd_x = 1.0;

	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		sum_x += fabs(Optimization_TestFunction_ScaledSolution[i]);
		prd_x *= fabs(Optimization_TestFunction_ScaledSolution[i]);
	}

	fitness_value = sum_x + prd_x;

	return fitness_value;
}

double Optimization_TestFunction_Schwefel1_02(double *solution)
{
	int i, j;
	double sum_x, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 100.0, 200.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		sum_x = 0.0;
		for(j=0; j <=i; ++j)
			sum_x += Optimization_TestFunction_ScaledSolution[j];
		fitness_value += pow(sum_x, 2);
	}

	return fitness_value;
}

double Optimization_TestFunction_Schwefel2_21(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 100.0, 200.0);

	fitness_value = fabs(Optimization_TestFunction_ScaledSolution[0]);
	for(i=1; i< Optimization_TestFunction_Dimension; ++i)
	{
		if(fitness_value < fabs(Optimization_TestFunction_ScaledSolution[i]))
			fitness_value = fabs(Optimization_TestFunction_ScaledSolution[i]);
	}

	return fitness_value;
}

double Optimization_TestFunction_Rosenbrock(double *solution)
{
	int i;
	double x1, x2, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 29.0, 60.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension-1; ++i)
	{
		x1 = Optimization_TestFunction_ScaledSolution[i];
		x2 = Optimization_TestFunction_ScaledSolution[i+1];

		fitness_value += 100.0 * pow(x2 - pow(x1, 2), 2) + pow(x1 - 1, 2);
	}

	return fitness_value;
}

double Optimization_TestFunction_Quartic(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 1.28, 2.56);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value += (i + 1) * pow(Optimization_TestFunction_ScaledSolution[i], 4) + (double) (rand() % 10000) / 10000.0;

	return fitness_value;
}

double Optimization_TestFunction_GeneralizedRastrigin(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 5.12, 10.24);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		fitness_value += (pow(Optimization_TestFunction_ScaledSolution[i], 2) -
						  10.0 * cos(2.0 * PI * Optimization_TestFunction_ScaledSolution[i]) +
						  10.0);
	}

	return fitness_value;
}

double Optimization_TestFunction_GeneralizedGriewank(double *solution)
{
	int i;
	double sum_x, product_cosx;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 600.0, 1200.0);

	sum_x = 0.0;
	product_cosx = 1.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		sum_x += pow(Optimization_TestFunction_ScaledSolution[i], 2);
		product_cosx *= cos(Optimization_TestFunction_ScaledSolution[i] / sqrt(i+1));
	}

	fitness_value = sum_x/4000.0 - product_cosx + 1.0;

	return fitness_value;
}

double Optimization_TestFunction_Schwefel2_26(double *solution)
{
	int i;
	double fitness_value;

	double sum_sinx;

	Optimization_TestFunction_SolutionScaling(solution, 500.0, 1000.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value -= Optimization_TestFunction_ScaledSolution[i] * sin(sqrt(fabs(Optimization_TestFunction_ScaledSolution[i])));

	sum_sinx = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		sum_sinx += (0.5 * (1.0 - cos(Optimization_TestFunction_ScaledSolution[i] * 1.0)));
	sum_sinx /= Optimization_TestFunction_Dimension;

	return fitness_value + 0.1 * sum_sinx * fitness_value;
}

double Optimization_TestFunction_Ackley(double *solution)
{
	int i;
	double sum_x, sum_cosx, fitness_value;

	double sum_sinx;

	Optimization_TestFunction_SolutionScaling(solution, 32.0, 64.0);

	sum_x = 0.0;
	sum_cosx = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		sum_x += pow(Optimization_TestFunction_ScaledSolution[i], 2);
		sum_cosx += cos(2.0 * PI * Optimization_TestFunction_ScaledSolution[i]);
	}

	fitness_value = -20.0 * exp(-0.2 * sqrt(sum_x / Optimization_TestFunction_Dimension)) -
					exp(sum_cosx / Optimization_TestFunction_Dimension) + 20.0 + exp(1);

	sum_sinx = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		sum_sinx += (0.5 * (1.0 - cos(Optimization_TestFunction_ScaledSolution[i] * 1.0)));
	sum_sinx /= Optimization_TestFunction_Dimension;

	return fitness_value + 0.1 * sum_sinx * fitness_value;
}

double Optimization_TestFunction_Foxholes(double *solution)
{
	int j;
	double x1, x2, fitness_value;

	x1 = 132.0 * solution[0] - 98.0;
	x2 = 132.0 * solution[1] - 98.0;

	fitness_value = 0.0;
	for(j=0; j< 25; ++j)
		fitness_value += 1.0 / ((j+1) +
								pow(x1 - Optimization_TestFunction_Foxholes_a1[j], 6) +
								pow(x2 - Optimization_TestFunction_Foxholes_a2[j], 6));

	fitness_value = 1.0 / (0.002 + fitness_value);

	return fitness_value;
}

double Optimization_TestFunction_SixHumpCamelBack(double *solution)
{
	double x1, x2, fitness_value;

	x1 = 10.0 * solution[0] - 4.91017;
	x2 = 10.0 * solution[1] - 5.7126;

	fitness_value = 4.0 * pow(x1, 2) -
					2.1 * pow(x1, 4) + 
					pow(x1, 6) / 3.0 +
					x1 * x2 -
					4.0 * pow(x2, 2) +
					4.0 * pow(x2, 4);

	return fitness_value;
}

double Optimization_TestFunction_Branin(double *solution)
{
	double x1, x2, fitness_value;

	x1 = 15.0 * solution[0] - 8.142;
	x2 = 15.0 * solution[1] - 12.275;

	fitness_value = pow(x2 -
						5 * pow(x1, 2) / (4.0 * pow(PI, 2)) +
						5.0 * x1 / PI -
						6.0, 2) +
					10.0 * (1.0 - 1.0 / (8.0 * PI)) * cos(x1) +
					10.0;

	return fitness_value;
}

double Optimization_TestFunction_GoldsteinPrice(double *solution)
{
	double x1, x2, g, h, fitness_value;

	x1 = 4.0 * solution[0] - 2.0;
	x2 = 4.0 * solution[1] - 2.0;

	g = 1.0 + pow(x1 + x2 +1.0, 2) * (19.0 - 14.0 * x1 + 3.0 * pow(x1, 2) - 14.0 * x2 + 6.0 * x1 * x2 + 3.0 * pow(x2, 2));
	h = 30.0 + pow(2.0 * x1 - 3.0 * x2, 2) * (18.0  - 32.0 * x1 + 12.0 * pow(x1, 2) + 48.0 * x2 - 36.0 * x1 * x2 + 27.0 * pow(x2, 2));
	
	fitness_value = g * h;

	return fitness_value;
}

double Optimization_TestFunction_HighConditionedElliptic(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 100.0, 200.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value += pow(10.0, 6 * (double) i / (Optimization_TestFunction_Dimension-1)) * pow(Optimization_TestFunction_ScaledSolution[i],2);

	return fitness_value;
}

double Optimization_TestFunction_Weierstrass(double *solution)
{
	int i, k;
	double a, b, fitness_value_1, fitness_value_2, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 0.5, 1.0);

	a = 0.5;
	b = 3.0;
	fitness_value_1 = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		for(k=0;k<=20; ++k)
			fitness_value_1 += (pow(a,k) * cos(2.0 * PI * pow(b,k) * (Optimization_TestFunction_ScaledSolution[i] + 0.5)));

	fitness_value_2 = -2.0;		//for k_max = 20;

	fitness_value = fitness_value_1 - Optimization_TestFunction_Dimension * fitness_value_2;

	return fitness_value;
}

double Optimization_TestFunction_Sinc(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 1.0, 2.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value += pow(Optimization_TestFunction_ScaledSolution[i], 2);

	fitness_value = sin(fitness_value * 7.0 * PI) / (fitness_value * 7.0 * PI);

	return fitness_value;
}

double Optimization_TestFunction_Levy(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 10.0, 20.0);

	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		Optimization_TestFunction_ScaledSolution[i] = 1.0 + (Optimization_TestFunction_ScaledSolution[i] - 1.0) / 4.0;

	fitness_value = pow(sin(PI * Optimization_TestFunction_ScaledSolution[0]), 2.0);

	for(i=0; i< Optimization_TestFunction_Dimension-1; ++i)
		fitness_value += (pow(Optimization_TestFunction_ScaledSolution[i] - 1.0, 2) *
						 (1.0 + 10.0 * pow(sin(PI * Optimization_TestFunction_ScaledSolution[i+1]), 2)));

	fitness_value += pow(Optimization_TestFunction_ScaledSolution[Optimization_TestFunction_Dimension-1] - 1.0, 2) *
					 (1.0 + 10.0 * pow(sin(2.0 * PI * Optimization_TestFunction_ScaledSolution[Optimization_TestFunction_Dimension-1]), 2));

	return fitness_value;
}

double Optimization_TestFunction_Zakharov(double *solution)
{
	int i;
	double cur_fitness_value, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 5.0, 15.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
			fitness_value += pow(Optimization_TestFunction_ScaledSolution[i], 2);

	cur_fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		cur_fitness_value += 0.5 * (i + 1) * Optimization_TestFunction_ScaledSolution[i];
	fitness_value += pow(cur_fitness_value, 2) + pow(cur_fitness_value, 4);

	return fitness_value;
}

double Optimization_TestFunction_Alpine(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 10.0, 20.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value += fabs(Optimization_TestFunction_ScaledSolution[i] * sin(Optimization_TestFunction_ScaledSolution[i]) + 0.1 * Optimization_TestFunction_ScaledSolution[i]);

	return fitness_value;
}

double Optimization_TestFunction_Pathological(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 100.0, 200.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension-1; ++i)
		fitness_value += 0.5 + (pow(sin(sqrt(100.0 * pow(Optimization_TestFunction_ScaledSolution[i],2) + pow(Optimization_TestFunction_ScaledSolution[i+1],2))), 2) - 0.5) /
							   (1.0 + 0.001 * pow(Optimization_TestFunction_ScaledSolution[i]-Optimization_TestFunction_ScaledSolution[i+1] ,4));

	return fitness_value;
}

double Optimization_TestFunction_InvertedCosineWave(double *solution)
{
	int i;
	double cur_fitness_value, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 5.0, 10.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension-1; ++i)
	{
		cur_fitness_value = pow(Optimization_TestFunction_ScaledSolution[i],2) + pow(Optimization_TestFunction_ScaledSolution[i+1],2) + 0.5 * Optimization_TestFunction_ScaledSolution[i] * Optimization_TestFunction_ScaledSolution[i+1];
		fitness_value -= exp(-cur_fitness_value / 8.0) *
						 cos(4.0 * sqrt(cur_fitness_value));
	}

	return fitness_value;
}

double Optimization_TestFunction_InvertedCosineMixture(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 1.0, 2.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value += 0.1 * cos(5.0 * PI * Optimization_TestFunction_ScaledSolution[i]);

	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value -= pow(Optimization_TestFunction_ScaledSolution[i], 2);

	fitness_value = 0.1 * Optimization_TestFunction_Dimension - fitness_value;

	return fitness_value;
}

double Optimization_TestFunction_EpistaticMichalewicz(double *solution)
{
	int i;
	double y, ph, m;
	double fitness_value;

	ph = PI / 6.0;
	m = 10;

	Optimization_TestFunction_SolutionScaling(solution, 0.0, PI);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		if(i == Optimization_TestFunction_Dimension - 1)
			y = Optimization_TestFunction_ScaledSolution[i];
		else if((i+1) % 2 == 1)
			y = Optimization_TestFunction_ScaledSolution[i] * cos(ph) - Optimization_TestFunction_ScaledSolution[i+1] * sin(ph);
		else
			y = Optimization_TestFunction_ScaledSolution[i] * sin(ph) + Optimization_TestFunction_ScaledSolution[i+1] * cos(ph);

		fitness_value -= sin(y) * pow(sin((i+1) * pow(y,2) / PI), 2.0 * m);
	}

	return fitness_value;
}

double Optimization_TestFunction_LevyMontalvo(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 5.0, 10.0);

	fitness_value = pow(sin(3.0 * PI * Optimization_TestFunction_ScaledSolution[0]), 2);
	for(i=0; i< Optimization_TestFunction_Dimension-1; ++i)
		fitness_value += pow(Optimization_TestFunction_ScaledSolution[i] - 1.0, 2) * (1.0 + pow(3.0 * PI * Optimization_TestFunction_ScaledSolution[i+1], 2));

	fitness_value += pow(Optimization_TestFunction_ScaledSolution[Optimization_TestFunction_Dimension-1] - 1.0, 2) * (1.0 + pow(2.0 * PI * Optimization_TestFunction_ScaledSolution[Optimization_TestFunction_Dimension-1], 2));

	return fitness_value;
}

double Optimization_TestFunction_Neumaier3(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, pow(Optimization_TestFunction_Dimension,2), 2.0*pow(Optimization_TestFunction_Dimension,2));

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value += pow(Optimization_TestFunction_ScaledSolution[i] - 1.0, 2);

	for(i=1; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value -= Optimization_TestFunction_ScaledSolution[i] * Optimization_TestFunction_ScaledSolution[i-1];

	return fitness_value;
}

double Optimization_TestFunction_OddSquare(double *solution)
{
	int i;
	double d, D, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 15.0, 30.0);

	d = 0.0;
	D = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		d += pow(Optimization_TestFunction_ScaledSolution[i] - Optimization_TestFunction_OddSquare_b[i % 10], 2);
		if(D < fabs(Optimization_TestFunction_ScaledSolution[i] - Optimization_TestFunction_OddSquare_b[i % 10]))
			D = fabs(Optimization_TestFunction_ScaledSolution[i] - Optimization_TestFunction_OddSquare_b[i % 10]);
	}
	d = sqrt(d);
	D *= sqrt(Optimization_TestFunction_Dimension);

	fitness_value = -(1.0 + 0.2*d / (D + 0.1)) * cos(D * PI) * exp(-D / (2.0 * PI));

	return fitness_value;
}

double Optimization_TestFunction_Paviani(double *solution)
{
	int i;
	double cur_fitness_value, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, -2.0, 8.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		if(Optimization_TestFunction_ScaledSolution[i] <= 2.0)
			fitness_value += pow(log(0.00000000000001), 2) + pow(log(10.0 - Optimization_TestFunction_ScaledSolution[i]), 2);
		else if(Optimization_TestFunction_ScaledSolution[i] >= 10.0)
			fitness_value += pow(log(Optimization_TestFunction_ScaledSolution[i] - 2.0), 2) + pow(log(0.00000000000001), 2);
		else
			fitness_value += pow(log(Optimization_TestFunction_ScaledSolution[i] - 2.0), 2) + pow(log(10.0 - Optimization_TestFunction_ScaledSolution[i]), 2);
	}

	cur_fitness_value = 1.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		cur_fitness_value *= Optimization_TestFunction_ScaledSolution[i];

	fitness_value = fitness_value - pow(cur_fitness_value, 0.2);

	return fitness_value;
}

double Optimization_TestFunction_Periodic(double *solution)
{
	int i;
	double cur_fitness_value, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 10.0, 20.0);

	fitness_value = 1.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value += pow(sin(Optimization_TestFunction_ScaledSolution[i]), 2);

	cur_fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		cur_fitness_value -= pow(Optimization_TestFunction_ScaledSolution[i], 2);

	fitness_value -= 0.1 * exp(cur_fitness_value);

	return fitness_value;
}

double Optimization_TestFunction_Salomon(double *solution)
{
	int i;
	double fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 100.0, 200.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value += pow(Optimization_TestFunction_ScaledSolution[i], 2);
	fitness_value = sqrt(fitness_value);

	fitness_value = 1.0 - cos(2.0 * PI * fitness_value) + 0.1 * fitness_value;

	return fitness_value;
}

double Optimization_TestFunction_Shubert(double *solution)
{
	int i, j;
	double cur_fitness_value, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 10.0, 20.0);

	fitness_value = 1.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		cur_fitness_value = 0.0;
		for(j=0; j< 5; ++j)
			cur_fitness_value += (j + 1.0) * cos((j + 2.0) * Optimization_TestFunction_ScaledSolution[i] + (j + 1.0));
		fitness_value *= cur_fitness_value;
	}

	return fitness_value;
}

double Optimization_TestFunction_Sinusoidal(double *solution)
{
	int i;
	double A, B, z;
	double f1, f2, fitness_value;

	A = 2.5;
	B = 5.0;
	z = 30.0;

	Optimization_TestFunction_SolutionScaling(solution, 0.0, 180.0);

	f1 = f2 = 1.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		f1 *= sin((Optimization_TestFunction_ScaledSolution[i] - z) * PI / 180.0);
		f2 *= sin(B * (Optimization_TestFunction_ScaledSolution[i] - z) * PI / 180.0);
	}

	fitness_value = -(A*f1 + f2);

	return fitness_value;
}

double Optimization_TestFunction_Michalewicz(double *solution)
{
	int i;
	double m, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 0.0, PI);

	m = 10.0;

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		fitness_value -= sin(Optimization_TestFunction_ScaledSolution[i]) * pow(sin((i+1.0) * pow(Optimization_TestFunction_ScaledSolution[i], 2) / PI), 2.0 * m);

	return fitness_value;
}

double Optimization_TestFunction_Whitely(double *solution)
{
	int i, j;
	double one_x2, y_ij, fitness_value;

	Optimization_TestFunction_SolutionScaling(solution, 100.0, 200.0);

	fitness_value = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		one_x2 = pow(1.0 - Optimization_TestFunction_ScaledSolution[i], 2);
		for(j=0; j< Optimization_TestFunction_Dimension; ++j)
		{
			y_ij = 100.0 * pow(Optimization_TestFunction_ScaledSolution[j] - pow(Optimization_TestFunction_ScaledSolution[i], 2), 2) + one_x2;
			fitness_value += y_ij / 4000 - cos(y_ij) + 1.0;
		}
	}

	return fitness_value;
}

double Optimization_TestFunction_HybridComposition01(double *solution)
{
	int i, j, k;
	double a, b, C;
	double x, sum_x, sum_cosx, product_cosx; 
	double *cur_solution;
	double w[5], max_w, sum_w, w_weight;
	double cur_f, cur_f1, cur_f2, f[10], f_max;
	double fitness_value;

	cur_solution = malloc(sizeof(double) * Optimization_TestFunction_Dimension);

	C = 2000.0;

	for(i=0; i< 5; ++i)
	{
		w[i] = 0.0;
		for(j=0; j< Optimization_TestFunction_Dimension; ++j)
			w[i] += pow((10.0*solution[j]-5.0) - i*0.5, 2);
		w[i] = exp(-1.0 * w[i] / (2 * Optimization_TestFunction_Dimension * pow(1, 2)));

		if(i==0 || max_w < w[i])
			max_w = w[i];
	}

	sum_w = 0.0;
	w_weight = 1.0 - pow(max_w, 10);
	for(i=0; i< 5; ++i)
	{
		if(w[i] < max_w)
			w[i] = w[i] * w_weight;

		sum_w += w[i];
	}

	for(i=0; i< 5; ++i)
		w[i] /= sum_w;

	//------------ f1 - f2
	cur_f = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 10.0 * solution[i] - 5.0 + 0.0;
		cur_f += (pow(x, 2) -
			      10.0 * cos(2.0 * PI * x) +
			 	 10.0);
	}

	f_max = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 5.0 + 0.0;
		f_max += (pow(x, 2) -
			      10.0 * cos(2.0 * PI * 5.0) +
			 	 10.0);
	}

	f[0] = w[0] * (C*cur_f/f_max + 0.0);
	f[1] = w[0] * (C*cur_f/f_max + 100.0);

	//------------ f3 - f4
	a = 0.5;
	b = 3.0;
	cur_f1 = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 10.0 * (10.0 * solution[i] - 5.0 + 0.5);

		for(k=0;k<=20; ++k)
			cur_f1 += (pow(a,k) * cos(2.0 * PI * pow(b,k) * (x + 0.5)));
	}

	cur_f2 = 0.0;
	for(k=0;k<=20; ++k)
		cur_f2 += (pow(a,k) * cos(2.0 * PI * pow(b,k) *  0.5));

	cur_f = cur_f1 - Optimization_TestFunction_Dimension * cur_f2;

	cur_f1 = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 10.0 * (5.0 + 0.5);

		for(k=0;k<=20; ++k)
			cur_f1 += (pow(a,k) * cos(2.0 * PI * pow(b,k) * (x + 0.5)));
	}

	cur_f2 = 0.0;
	for(k=0;k<=20; ++k)
		cur_f2 += (pow(a,k) * cos(2.0 * PI * pow(b,k) *  0.5));

	f_max = cur_f1 - Optimization_TestFunction_Dimension * cur_f2;

	f[2] = w[1] * (C*cur_f/f_max + 200.0);
	f[3] = w[1] * (C*cur_f/f_max + 300.0);

	//------------ f5 - f6
	sum_x = 0.0;
	product_cosx = 1.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 12.0 * (10.0 * solution[i] - 5.0 + 1.0);
		sum_x += pow(x, 2);
		product_cosx *= cos(x / sqrt(i+1));
	}

	cur_f = sum_x/4000.0 - product_cosx + 1.0;

	sum_x = 0.0;
	product_cosx = 1.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 12.0 * (5.0 + 1.0);
		sum_x += pow(x, 2);
		product_cosx *= cos(x / sqrt(i+1));
	}

	f_max = sum_x/4000.0 - product_cosx + 1.0;

	f[4] = w[2] * (C*cur_f/f_max + 400.0);
	f[5] = w[2] * (C*cur_f/f_max + 500.0);

	//------------ f7 - f8
	sum_x = 0.0;
	sum_cosx = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 6.4 * (10.0 * solution[i] - 5.0 + 1.5);
		sum_x += pow(x, 2);
		sum_cosx += cos(2.0 * PI * x);
	}

	cur_f = -20.0 * exp(-0.2 * sqrt(sum_x / 30.0)) -
			exp(sum_cosx / 30.0) + 20.0 + exp(1);

	sum_x = 0.0;
	sum_cosx = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 6.4 * (5.0 + 1.5);

		sum_x += pow(x, 2);
		sum_cosx += cos(2.0 * PI * x);
	}

	f_max = -20.0 * exp(-0.2 * sqrt(sum_x / 30.0)) -
			exp(sum_cosx / 30.0) + 20.0 + exp(1);

	f[6] = w[3] * (C*cur_f/f_max + 600.0);
	f[7] = w[3] * (C*cur_f/f_max + 700.0);

	//------------ f9 - f10
	cur_f = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 20.0 * (10.0 * solution[i] - 5.0 + 2.0);
		cur_f += pow(x, 2);
	}

	f_max = 0.0;
	for(i=0; i< Optimization_TestFunction_Dimension; ++i)
	{
		x = 20.0 * (5.0 + 2.0);
		f_max += pow(x, 2);
	}

	f[8] = w[4] * (C*cur_f/f_max + 800.0);
	f[9] = w[4] * (C*cur_f/f_max + 900.0);

	free(cur_solution);

	fitness_value = 0.0;
	for(i=0; i < 10; ++i)
		fitness_value += f[i];

	return fitness_value;
}
