#ifndef OPTIMIZATION_TESTFUNCTION_KERNEL

#define OPTIMIZATION_TESTFUNCTION_KERNEL

#define PI 3.14159265

int Optimization_TestFunction_Dimension;

double (*Optimization_TestFunction_Pointer)(double*);
double *Optimization_TestFunction_ScaledSolution;

void	Optimization_TestFunction_Manager_RealValued(int, char*);
void	Optimization_TestFunction_Construction();
void	Optimization_TestFunction_Destruction();

//========= Uni-modal Function
double Optimization_TestFunction_Sphereical(double*);
double Optimization_TestFunction_Schwefel2_22(double*);
double Optimization_TestFunction_Schwefel1_02(double*);
double Optimization_TestFunction_Schwefel2_21(double*);
double Optimization_TestFunction_Rosenbrock(double*);
double Optimization_TestFunction_Quartic(double*);

//========= Multi-modal Function
double Optimization_TestFunction_GeneralizedRastrigin(double*);
double Optimization_TestFunction_GeneralizedGriewank(double*);
double Optimization_TestFunction_Schwefel2_26(double*);
double Optimization_TestFunction_Ackley(double*);
double Optimization_TestFunction_Foxholes(double*);
double Optimization_TestFunction_SixHumpCamelBack(double*);
double Optimization_TestFunction_Branin(double*);
double Optimization_TestFunction_GoldsteinPrice(double*);
double Optimization_TestFunction_HighConditionedElliptic(double*);
double Optimization_TestFunction_Weierstrass(double*);
double Optimization_TestFunction_Sinc(double*);
double Optimization_TestFunction_Levy(double*);
double Optimization_TestFunction_Pern(double*);
double Optimization_TestFunction_Zakharov(double*);
double Optimization_TestFunction_Alpine(double*);
double Optimization_TestFunction_Pathological(double*);
double Optimization_TestFunction_InvertedCosineWave(double*);
double Optimization_TestFunction_InvertedCosineMixture(double*);
double Optimization_TestFunction_EpistaticMichalewicz(double*);
double Optimization_TestFunction_LevyMontalvo(double*);
double Optimization_TestFunction_Neumaier3(double*);
double Optimization_TestFunction_OddSquare(double*);
double Optimization_TestFunction_Paviani(double*);
double Optimization_TestFunction_Periodic(double*);
double Optimization_TestFunction_Salomon(double*);
double Optimization_TestFunction_Shubert(double*);
double Optimization_TestFunction_Sinusoidal(double*);
double Optimization_TestFunction_Michalewicz(double*);
double Optimization_TestFunction_Whitely(double*);
double Optimization_TestFunction_Whitely(double*);
double Optimization_TestFunction_Easom(double*);

//========= Hybrid Composition Function
double Optimization_TestFunction_HybridComposition01(double*);

#endif