#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>
#include<math.h>
#include<time.h>
#include"MultiObjective_Kernel.H"
#include"MODdEA_Kernel.H"

void MODdEA_Construction(MODdEA *cur_MODdEA, int cur_population_size, int nxt_population_size, int no_dimension, int no_function, int max_no_solution)
{
	MOEA_Construction(&(*cur_MODdEA).MOEA_Info, no_dimension, no_function, cur_population_size, nxt_population_size, max_no_solution);

	DensityTree_Construction(&(*cur_MODdEA).Density_Tree, no_dimension, 1, 0);

	return;
}

void MODdEA_Destruction(MODdEA cur_MODdEA)
{
	MOEA_Destruction(cur_MODdEA.MOEA_Info);

	DensityTree_Destruction(cur_MODdEA.Density_Tree);

	return;
}

void MODdEA_Selection_SpatialProbabilistic(MODdEA *cur_MODdEA)
{
	int i, j, k;
	int pool_size, cur_ParetoFront;
	int ParetoFront_noPoint, *ParetoFront_index;
	double *ParetoFront_probability, ParetoFront_sumprobability, *ParetoFront_cumsumprobability;
	double cur_prob;

	DensityNode *cur_Node;

	ParetoFront_index = malloc(sizeof(int) * (*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution);
	ParetoFront_probability = malloc(sizeof(double) * (*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution);
	ParetoFront_cumsumprobability = malloc(sizeof(double) * (*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution);

    pool_size = 0;
    cur_ParetoFront = 0;

    while(pool_size < (*cur_MODdEA).MOEA_Info.cur_Population_Size)
	{
        ++cur_ParetoFront;
		ParetoFront_noPoint = 0;
        for(i=0; i< (*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution; ++i)
			if((*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Rank[i] == cur_ParetoFront)
			{
				ParetoFront_index[ParetoFront_noPoint] = i;
				++ParetoFront_noPoint;
			}
        
//		printf("%d %d %d\n", cur_ParetoFront, pool_size, ParetoFront_noPoint);
        if(pool_size+ParetoFront_noPoint <= (*cur_MODdEA).MOEA_Info.cur_Population_Size)
		{
//			printf("Mode 1\n");
            for(i=0; i< ParetoFront_noPoint; ++i)
			{
	            for(j=0; j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
					(*cur_MODdEA).MOEA_Info.cur_Population[pool_size+i][j] = (*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Solution[ParetoFront_index[i]][j];
	            for(j=0; j< (*cur_MODdEA).MOEA_Info.no_Function; ++j)
					(*cur_MODdEA).MOEA_Info.cur_Fitness[pool_size+i][j] = (*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Fitness[ParetoFront_index[i]][j];
            }
            
            pool_size += ParetoFront_noPoint;
		}
        else
		{
//			printf("Mode 2\n");
            for(i=0; i< ParetoFront_noPoint; ++i)
			{
				for(j=0; j< (*cur_MODdEA).Density_Tree.no_Dimension; ++j)
				{
					(*cur_MODdEA).Density_Tree.cur_Interval[j][0] = (*cur_MODdEA).Density_Tree.Interval[j][0];
					(*cur_MODdEA).Density_Tree.cur_Interval[j][1] = (*cur_MODdEA).Density_Tree.Interval[j][1];
				}

				cur_Node = DensityNode_Search((*cur_MODdEA).Density_Tree.Root, &(*cur_MODdEA).Density_Tree.cur_Interval, (*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Solution[i]);

				ParetoFront_probability[i] = 1.0;
	            for(j=0; j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
	                ParetoFront_probability[i] *= ((*cur_MODdEA).Density_Tree.cur_Interval[j][1] - (*cur_MODdEA).Density_Tree.cur_Interval[j][0]);
//	                ParetoFront_probability[i] *= ((*cur_MODdEA).Density_Tree.cur_Interval[j][1] - (*cur_MODdEA).Density_Tree.cur_Interval[j][0]) / ((*cur_MODdEA).MOEA_Info.SearchSpace[j][1] - (*cur_MODdEA).MOEA_Info.SearchSpace[j][0]);
				ParetoFront_probability[i] += 1e-10;
//				printf("%1.3lf ", ParetoFront_probability[i]);
            }

			ParetoFront_cumsumprobability[0] = ParetoFront_probability[0];
            for(i=1; i< ParetoFront_noPoint; ++i)
				ParetoFront_cumsumprobability[i] = ParetoFront_probability[i] + ParetoFront_cumsumprobability[i-1];
			ParetoFront_sumprobability = ParetoFront_cumsumprobability[ParetoFront_noPoint-1];
            
            for(i=0; i< ParetoFront_noPoint; ++i)
				ParetoFront_cumsumprobability[i] /= ParetoFront_sumprobability;

            for(i=pool_size; i< (*cur_MODdEA).MOEA_Info.cur_Population_Size; ++i)
			{
                cur_prob = (double) rand() / RAND_MAX;
                for(k=0; k < ParetoFront_noPoint-1; ++k)
                    if(cur_prob < ParetoFront_cumsumprobability[k])
                        break;

				for(j=0; j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
					(*cur_MODdEA).MOEA_Info.cur_Population[i][j] = (*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Solution[ParetoFront_index[k]][j];
				for(j=0; j< (*cur_MODdEA).MOEA_Info.no_Function; ++j)
					(*cur_MODdEA).MOEA_Info.cur_Fitness[i][j] = (*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Fitness[ParetoFront_index[k]][j];

				ParetoFront_probability[k] = 0.0;
				ParetoFront_cumsumprobability[0] = ParetoFront_probability[0];
				for(j=1; j< ParetoFront_noPoint; ++j)
					ParetoFront_cumsumprobability[j] = ParetoFront_probability[j] + ParetoFront_cumsumprobability[j-1];
				ParetoFront_sumprobability = ParetoFront_cumsumprobability[ParetoFront_noPoint-1];
            }
            
            pool_size = (*cur_MODdEA).MOEA_Info.cur_Population_Size;
        }
    }

	free(ParetoFront_index);
	free(ParetoFront_probability);
	free(ParetoFront_cumsumprobability);

	return;
}

void MODdEA_Kernel(MODdEA *cur_MODdEA, int terminate_mode, double terminate_parameter, void (*fn_ptr)(double *individual, double **fitness))
{
	//============ terminate_mode: 0 = Fixed Generation    (terminate_parameter = max. no. of iteration)
	//
	//============ optimization_mode: 0 = Minization, 1: Maximization

	int i, j;
	int individual_index_1, individual_index_2, optimal_individual_index;
	long clock_begin;

	int out_bound_flag, mutate_gene;
	double mutate_ap;

	double Ap;

	(*cur_MODdEA).MOEA_Info.no_Generation = 0;
	clock_begin = clock();

	//============ Density Tree Initialization
	for(i=0; i< (*cur_MODdEA).MOEA_Info.no_Dimension; ++i)
		for(j=0; j< 2; ++j)
			(*cur_MODdEA).Density_Tree.Interval[i][j] = (*cur_MODdEA).MOEA_Info.SearchSpace[i][j];

	//============ Population Initialization
	optimal_individual_index = 0;
	for(i=0;i< (*cur_MODdEA).MOEA_Info.cur_Population_Size; ++i)
	{
		for(j=0;j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
			(*cur_MODdEA).MOEA_Info.cur_Population[i][j] = (double) rand() / RAND_MAX * ((*cur_MODdEA).MOEA_Info.SearchSpace[j][1] - (*cur_MODdEA).MOEA_Info.SearchSpace[j][0]) + (*cur_MODdEA).MOEA_Info.SearchSpace[j][0];

		(*fn_ptr)((*cur_MODdEA).MOEA_Info.cur_Population[i], &(*cur_MODdEA).MOEA_Info.cur_Fitness[i]);
//		for(j=0;j< (*cur_MODdEA).MOEA_Info.no_Function; ++j)
//			(*cur_MODdEA).MOEA_Info.cur_Fitness[i][j] *= (1.0 - 2.0*(*cur_MODdEA).MOEA_Info.Optimization_Mode[j]);

		DensityTree_Insertion(&(*cur_MODdEA).Density_Tree, (*cur_MODdEA).MOEA_Info.cur_Population[i], 0, (*cur_MODdEA).MOEA_Info.no_Generation);
	}

	//------------ Optimal ParetoFront
	for(i=0;i< (*cur_MODdEA).MOEA_Info.cur_Population_Size; ++i)
	{
		for(j=0;j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
			(*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Solution[(*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution][j] = (*cur_MODdEA).MOEA_Info.cur_Population[i][j];
		for(j=0;j< (*cur_MODdEA).MOEA_Info.no_Function; ++j)
			(*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Fitness[(*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution][j] = (*cur_MODdEA).MOEA_Info.cur_Fitness[i][j];
		++(*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution;
	}

	ParetoFront_Construction(&(*cur_MODdEA).MOEA_Info.ParetoFront_Info, (*cur_MODdEA).MOEA_Info.Optimization_Mode);
	if((*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution + (*cur_MODdEA).MOEA_Info.nxt_Population_Size > (*cur_MODdEA).MOEA_Info.ParetoFront_Info.Max_no_Solution)
		ParetoFront_Info_Expansion(&(*cur_MODdEA).MOEA_Info.ParetoFront_Info,
								   (*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution + (*cur_MODdEA).MOEA_Info.nxt_Population_Size - (*cur_MODdEA).MOEA_Info.ParetoFront_Info.Max_no_Solution);

	++(*cur_MODdEA).MOEA_Info.no_Generation;

	if(MODdEA_IGD_Convergence_Flag == 1)
	{
		ParetoFront_IGD(&((*cur_MODdEA).MOEA_Info.ParetoFront_Info), MODdEA_OptimalParetoFront);
		(*cur_MODdEA).MOEA_Info.IGD_Convergence[(*cur_MODdEA).MOEA_Info.no_Generation - 1] = (*cur_MODdEA).MOEA_Info.ParetoFront_Info.IGD;
	}

	(*cur_MODdEA).MOEA_Info.Processing_Time = realloc((*cur_MODdEA).MOEA_Info.Processing_Time, sizeof(double) * (*cur_MODdEA).MOEA_Info.no_Generation);
	(*cur_MODdEA).MOEA_Info.Processing_Time[(*cur_MODdEA).MOEA_Info.no_Generation - 1] = (double) (clock() - clock_begin) / CLOCKS_PER_SEC;
	//===================================================================================================

	//============ Evoluation
	do {
		//============ Reproduction
		//------------ Adaptive Mutation
		for(i=0; i< (*cur_MODdEA).MOEA_Info.cur_Population_Size; ++i)
		{
			out_bound_flag = 1;
			while(out_bound_flag == 1)
			{
				out_bound_flag = 0;

				mutate_gene = rand() % (*cur_MODdEA).MOEA_Info.no_Dimension;
				mutate_ap = (double) rand() / RAND_MAX * ((*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][1] - (*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][0]);
				if((*cur_MODdEA).MOEA_Info.cur_Population[i][mutate_gene] - (*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][0] > (*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][1] - (*cur_MODdEA).MOEA_Info.cur_Population[i][mutate_gene])
				{
					if(mutate_ap > (*cur_MODdEA).MOEA_Info.cur_Population[i][mutate_gene] - (*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][0])
						mutate_ap = (*cur_MODdEA).MOEA_Info.cur_Population[i][mutate_gene] - (*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][0];
				}
				else
				{
					if(mutate_ap > (*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][1] - (*cur_MODdEA).MOEA_Info.cur_Population[i][mutate_gene])
						mutate_ap = (*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][1] - (*cur_MODdEA).MOEA_Info.cur_Population[i][mutate_gene];
				}

				for(j=0; j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
						(*cur_MODdEA).MOEA_Info.tmp_Population[i][j] = (*cur_MODdEA).MOEA_Info.cur_Population[i][j];

				(*cur_MODdEA).MOEA_Info.tmp_Population[i][mutate_gene] = randn(0.0, mutate_ap) + (*cur_MODdEA).MOEA_Info.cur_Population[i][mutate_gene];
				if((*cur_MODdEA).MOEA_Info.tmp_Population[i][mutate_gene] < (*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][0] ||
				   (*cur_MODdEA).MOEA_Info.tmp_Population[i][mutate_gene] > (*cur_MODdEA).MOEA_Info.SearchSpace[mutate_gene][1])
					out_bound_flag = 1;
			}
		}

		//------------ Cross-Over
		for(i=0; i< (*cur_MODdEA).MOEA_Info.nxt_Population_Size; ++i)
		{
			individual_index_1 = rand() % (*cur_MODdEA).MOEA_Info.cur_Population_Size;
			individual_index_2 = rand() % (*cur_MODdEA).MOEA_Info.cur_Population_Size;
			while(individual_index_2 == individual_index_1)
				individual_index_2 = rand() % (*cur_MODdEA).MOEA_Info.cur_Population_Size;

			Ap = (double) rand() / RAND_MAX * 3.0 - 1.0;
			for(j=0; j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
			{
				if((*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_2][j]-(*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j] > 0.0)
				{
					if((*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j] +
						Ap * ((*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_2][j]-(*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j]) >
						(*cur_MODdEA).MOEA_Info.SearchSpace[j][1])
						Ap = ((*cur_MODdEA).MOEA_Info.SearchSpace[j][1] - (*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j]) / ((*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_2][j]-(*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j]);
				}
				else
				{
					if((*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j] +
						Ap * ((*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_2][j]-(*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j]) <
						(*cur_MODdEA).MOEA_Info.SearchSpace[j][0])
						Ap = ((*cur_MODdEA).MOEA_Info.SearchSpace[j][0] - (*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j]) / ((*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_2][j]-(*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j]);
				}
			}

			for(j=0; j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
				(*cur_MODdEA).MOEA_Info.nxt_Population[i][j] = (*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j] + 
															   Ap * ((*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_2][j]-(*cur_MODdEA).MOEA_Info.tmp_Population[individual_index_1][j]);
		}

		//------------ Bounadry Enforcement
		for(i=0; i< (*cur_MODdEA).MOEA_Info.nxt_Population_Size; ++i)
			for(j=0; j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
				if((*cur_MODdEA).MOEA_Info.nxt_Population[i][j] < (*cur_MODdEA).MOEA_Info.SearchSpace[j][0])
					(*cur_MODdEA).MOEA_Info.nxt_Population[i][j] = (*cur_MODdEA).MOEA_Info.SearchSpace[j][0];
				else if((*cur_MODdEA).MOEA_Info.nxt_Population[i][j] > (*cur_MODdEA).MOEA_Info.SearchSpace[j][1])
					(*cur_MODdEA).MOEA_Info.nxt_Population[i][j] = (*cur_MODdEA).MOEA_Info.SearchSpace[j][1];

		//------------ Fitness Measurement
		for(i=0; i< (*cur_MODdEA).MOEA_Info.nxt_Population_Size; ++i)
		{
			(*fn_ptr)((*cur_MODdEA).MOEA_Info.nxt_Population[i], &(*cur_MODdEA).MOEA_Info.nxt_Fitness[i]);
//			for(j=0;j< (*cur_MODdEA).MOEA_Info.no_Function; ++j)
//				(*cur_MODdEA).MOEA_Info.nxt_Fitness[i][j] *= (1.0 - 2.0*(*cur_MODdEA).MOEA_Info.Optimization_Mode[j]);

			DensityTree_Insertion(&(*cur_MODdEA).Density_Tree, (*cur_MODdEA).MOEA_Info.nxt_Population[i], 0, (*cur_MODdEA).MOEA_Info.no_Generation);
		}

		//------------ Optimal ParetoFront
		for(i=0;i< (*cur_MODdEA).MOEA_Info.nxt_Population_Size; ++i)
		{
			for(j=0;j< (*cur_MODdEA).MOEA_Info.no_Dimension; ++j)
				(*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Solution[(*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution][j] = (*cur_MODdEA).MOEA_Info.nxt_Population[i][j];
			for(j=0;j< (*cur_MODdEA).MOEA_Info.no_Function; ++j)
				(*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Fitness[(*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution][j] = (*cur_MODdEA).MOEA_Info.nxt_Fitness[i][j];
			++(*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution;
		}
		ParetoFront_Construction(&(*cur_MODdEA).MOEA_Info.ParetoFront_Info, (*cur_MODdEA).MOEA_Info.Optimization_Mode);

		//------------ ParetoFront Truncate
		ParetoFrontTruncation(&(*cur_MODdEA).MOEA_Info.ParetoFront_Info, (*cur_MODdEA).MOEA_Info.cur_Population_Size);
		if((*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution + (*cur_MODdEA).MOEA_Info.nxt_Population_Size > (*cur_MODdEA).MOEA_Info.ParetoFront_Info.Max_no_Solution)
			ParetoFront_Info_Expansion(&(*cur_MODdEA).MOEA_Info.ParetoFront_Info,
									   (*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution + (*cur_MODdEA).MOEA_Info.nxt_Population_Size - (*cur_MODdEA).MOEA_Info.ParetoFront_Info.Max_no_Solution);

		//------------ Selection
		MODdEA_Selection_SpatialProbabilistic(cur_MODdEA);

		++(*cur_MODdEA).MOEA_Info.no_Generation;

		(*cur_MODdEA).MOEA_Info.Processing_Time = realloc((*cur_MODdEA).MOEA_Info.Processing_Time, sizeof(double) * (*cur_MODdEA).MOEA_Info.no_Generation);
		(*cur_MODdEA).MOEA_Info.Processing_Time[(*cur_MODdEA).MOEA_Info.no_Generation - 1] = (double) (clock() - clock_begin) / CLOCKS_PER_SEC;

		if(MODdEA_IGD_Convergence_Flag == 1)
		{
			ParetoFront_IGD(&((*cur_MODdEA).MOEA_Info.ParetoFront_Info), MODdEA_OptimalParetoFront);
			(*cur_MODdEA).MOEA_Info.IGD_Convergence[(*cur_MODdEA).MOEA_Info.no_Generation - 1] = (*cur_MODdEA).MOEA_Info.ParetoFront_Info.IGD;
		}

		if((*cur_MODdEA).MOEA_Info.no_Generation % 100 == 0)
			printf("%dth iteration = %d\n", (*cur_MODdEA).MOEA_Info.no_Generation, (*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution);

	} while(terminate_mode == 0 && terminate_parameter > (*cur_MODdEA).MOEA_Info.no_Generation);

	for(i=0; i< (*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution; ++i)
		if((*cur_MODdEA).MOEA_Info.ParetoFront_Info.ParetoFront_Rank[i] > 1)
			break;

	(*cur_MODdEA).MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution = i;

	return;
}

void MOEA_Construction(MOEA *cur_MOEA, int no_dimension, int no_function, int cur_population_size, int nxt_population_size, int max_no_solution)
{
	int i;

	(*cur_MOEA).no_Dimension = no_dimension;
	(*cur_MOEA).no_Function = no_function;

	(*cur_MOEA).SearchSpace = malloc(sizeof(double*) * no_dimension);
	for(i=0; i<no_dimension; ++i)
		(*cur_MOEA).SearchSpace[i] = malloc(sizeof(double) * 2);

	(*cur_MOEA).cur_Population_Size = cur_population_size;
	(*cur_MOEA).nxt_Population_Size = nxt_population_size;

	(*cur_MOEA).cur_Population = malloc(sizeof(double*) * cur_population_size);
	for(i=0; i< (*cur_MOEA).cur_Population_Size; ++i)
		(*cur_MOEA).cur_Population[i] = malloc(sizeof(double) * no_dimension);

	(*cur_MOEA).tmp_Population = malloc(sizeof(double*) * cur_population_size);
	for(i=0; i< (*cur_MOEA).cur_Population_Size; ++i)
		(*cur_MOEA).tmp_Population[i] = malloc(sizeof(double) * no_dimension);

	(*cur_MOEA).nxt_Population = malloc(sizeof(double*) * nxt_population_size);
	for(i=0; i< (*cur_MOEA).nxt_Population_Size; ++i)
		(*cur_MOEA).nxt_Population[i] = malloc(sizeof(double) * no_dimension);

	(*cur_MOEA).cur_Fitness = malloc(sizeof(double*) * cur_population_size);
	for(i=0; i< (*cur_MOEA).cur_Population_Size; ++i)
		(*cur_MOEA).cur_Fitness[i] = malloc(sizeof(double) * no_function);

	(*cur_MOEA).tmp_Fitness = malloc(sizeof(double*) * cur_population_size);
	for(i=0; i< (*cur_MOEA).cur_Population_Size; ++i)
		(*cur_MOEA).tmp_Fitness[i] = malloc(sizeof(double) * no_function);

	(*cur_MOEA).nxt_Fitness = malloc(sizeof(double*) * nxt_population_size);
	for(i=0; i< (*cur_MOEA).nxt_Population_Size; ++i)
		(*cur_MOEA).nxt_Fitness[i] = malloc(sizeof(double) * no_function);

	(*cur_MOEA).Processing_Time = malloc(sizeof(double) * MOEA_MAX_GENERATION);

	(*cur_MOEA).Optimization_Mode = malloc(sizeof(int) * no_function);

	(*cur_MOEA).IGD_Convergence = malloc(sizeof(double) * MOEA_MAX_GENERATION);

	ParetoFront_Info_Construction(&(*cur_MOEA).ParetoFront_Info, max_no_solution, no_dimension, no_function);

	return;
}

void MOEA_Destruction(MOEA cur_MOEA)
{
	int i;

	for(i=0; i<cur_MOEA.no_Dimension; ++i)
		free(cur_MOEA.SearchSpace[i]);
	free(cur_MOEA.SearchSpace);

	for(i=0; i< cur_MOEA.cur_Population_Size; ++i)
		free(cur_MOEA.cur_Population[i]);
	free(cur_MOEA.cur_Population);

	for(i=0; i< cur_MOEA.cur_Population_Size; ++i)
		free(cur_MOEA.tmp_Population[i]);
	free(cur_MOEA.tmp_Population);

	for(i=0; i< cur_MOEA.nxt_Population_Size; ++i)
		free(cur_MOEA.nxt_Population[i]);
	free(cur_MOEA.nxt_Population);

	for(i=0; i< cur_MOEA.cur_Population_Size; ++i)
		free(cur_MOEA.cur_Fitness[i]);
	free(cur_MOEA.cur_Fitness);

	for(i=0; i< cur_MOEA.cur_Population_Size; ++i)
		free(cur_MOEA.tmp_Fitness[i]);
	free(cur_MOEA.tmp_Fitness);

	for(i=0; i< cur_MOEA.nxt_Population_Size; ++i)
		free(cur_MOEA.nxt_Fitness[i]);
	free(cur_MOEA.nxt_Fitness);

	free(cur_MOEA.Processing_Time);

	free(cur_MOEA.Optimization_Mode);

	free(cur_MOEA.IGD_Convergence);

	ParetoFront_Info_Destruction(cur_MOEA.ParetoFront_Info);

	return;
}

void DensityTree_Construction(DensityTree *cur_Tree, int cur_Dimension, int interval_Size, int max_archive_size)
{
	int i;

	(*cur_Tree).no_Dimension = cur_Dimension;
	(*cur_Tree).no_Leaf = 0;
	(*cur_Tree).Root = malloc(sizeof(DensityNode));
	(*(*cur_Tree).Root).Dimension = -1;
	(*(*cur_Tree).Root).Parent = NULL;
	(*(*cur_Tree).Root).Optimal_Data = malloc(sizeof(double) * cur_Dimension);
	(*(*cur_Tree).Root).Child_Left = NULL;
	(*(*cur_Tree).Root).Child_Right = NULL;
	(*(*cur_Tree).Root).no_Visit = 0;
	(*cur_Tree).Current_ID = 0;

	(*cur_Tree).AxisBoundary_Set = malloc(sizeof(int) * cur_Dimension);
	(*cur_Tree).Interval = malloc(sizeof(double*) * cur_Dimension);
	(*cur_Tree).cur_Interval = malloc(sizeof(double*) * cur_Dimension);
	for(i=0; i< cur_Dimension; ++i)
	{
		(*cur_Tree).Interval[i] = malloc(sizeof(double) * 2);
		(*cur_Tree).cur_Interval[i] = malloc(sizeof(double) * 2);
	}

	(*cur_Tree).no_Revisit = 0;

	return;
}

void DensityTree_Destruction(DensityTree cur_Tree)
{
	int i;

	DensityNode_Destruction(*cur_Tree.Root);


	free(cur_Tree.AxisBoundary_Set);
	free(cur_Tree.Root);

	for(i=0; i< cur_Tree.no_Dimension; ++i)
	{
		free(cur_Tree.Interval[i]);
		free(cur_Tree.cur_Interval[i]);
	}
	free(cur_Tree.Interval);
	free(cur_Tree.cur_Interval);

	return;

}

void DensityNode_Contruction(DensityNode *parent_Node, DensityNode *child_Node, int cur_Dimension)
{
	(*child_Node).ID_Self = -1;
	(*child_Node).ID_Parent = -1;
	(*child_Node).Dimension = -1;
	(*child_Node).Threshold = 0.0;
	(*child_Node).Parent = parent_Node;
	(*child_Node).Child_Left = NULL;
	(*child_Node).Child_Right = NULL;
	(*child_Node).no_Visit = 1;
	(*child_Node).Optimal_Data = malloc(sizeof(double) * cur_Dimension);

	return;
}

void DensityNode_Destruction(DensityNode cur_Node)
{
	if(cur_Node.Child_Left != NULL)
	{
		DensityNode_Destruction(*cur_Node.Child_Left);
		free(cur_Node.Child_Left);
	}

	if(cur_Node.Child_Right != NULL)
	{
		DensityNode_Destruction(*cur_Node.Child_Right);
		free(cur_Node.Child_Right);
	}

	free(cur_Node.Optimal_Data);

	return;
}

void DensityNode_Interval(DensityNode *tgr_Node, DensityTree *cur_Tree)
{
	int i;
	DensityNode *cur_Node;

	for(i=0; i< (*cur_Tree).no_Dimension; ++i)
	{
		(*cur_Tree).cur_Interval[i][0] = (*cur_Tree).Interval[i][0];
		(*cur_Tree).cur_Interval[i][1] = (*cur_Tree).Interval[i][1];
	}

	cur_Node = (*cur_Tree).Root;
	while (cur_Node != tgr_Node && (*cur_Node).Dimension > -1)
	{
		if((*tgr_Node).Optimal_Data[(*cur_Node).Dimension] < (*cur_Node).Threshold)
		{
			(*cur_Tree).cur_Interval[(*cur_Node).Dimension][1] = (*cur_Node).Threshold;
			cur_Node = (*cur_Node).Child_Left;
		}
		else
		{
			(*cur_Tree).cur_Interval[(*cur_Node).Dimension][0] = (*cur_Node).Threshold;
			cur_Node = (*cur_Node).Child_Right;
		}
	}

	return;
}

DensityNode *DensityNode_Search(DensityNode *root_Node, double ***cur_Interval, double *cur_Data)
{
	DensityNode *cur_Node;

	cur_Node = root_Node;
	while ((*cur_Node).Dimension > -1)
	{
		if(cur_Data[(*cur_Node).Dimension] < (*cur_Node).Threshold)
		{
			(*cur_Interval)[(*cur_Node).Dimension][1] = (*cur_Node).Threshold;
			cur_Node = (*cur_Node).Child_Left;
		}
		else
		{
			(*cur_Interval)[(*cur_Node).Dimension][0] = (*cur_Node).Threshold;
			cur_Node = (*cur_Node).Child_Right;
		}
	}

	return cur_Node;
}

void DensityTree_Insertion(DensityTree *cur_Tree, double *cur_Data, double cur_Fitness, int Blockader)
{
	int i, cur_Dimension;
	double interval_diff;
	DensityNode *cur_Node;

	cur_Dimension = (*cur_Tree).no_Dimension;
	cur_Node = DensityNode_Search((*cur_Tree).Root, &(*cur_Tree).cur_Interval, cur_Data);

	if((*cur_Node).Parent == NULL && (*cur_Node).no_Visit == 0)
	{
		//============ Root Node
		++(*cur_Node).no_Visit;
		for(i=0; i< cur_Dimension; ++i)
			(*cur_Node).Optimal_Data[i] = cur_Data[i];
		(*cur_Node).Optimal_Fitness = cur_Fitness;
	}
	else
	{
		for(i=0; i< cur_Dimension; ++i)
			if((*cur_Node).Optimal_Data[i] != cur_Data[i] &&
			   ((*cur_Node).Dimension == -1 || interval_diff < fabs((*cur_Node).Optimal_Data[i] - cur_Data[i])))
			{
				(*cur_Node).Dimension = i;
				(*cur_Node).Threshold = 0.5 * ((*cur_Node).Optimal_Data[i] + cur_Data[i]);
				interval_diff = fabs((*cur_Node).Optimal_Data[i] - cur_Data[i]);
			}

		(*cur_Node).Child_Left = malloc(sizeof(DensityNode));
		(*cur_Node).Child_Right = malloc(sizeof(DensityNode));

		DensityNode_Contruction(cur_Node, (*cur_Node).Child_Left, cur_Dimension);
		DensityNode_Contruction(cur_Node, (*cur_Node).Child_Right, cur_Dimension);

		if((*cur_Node).Optimal_Data[(*cur_Node).Dimension] < cur_Data[(*cur_Node).Dimension])
		{
			for(i=0; i< cur_Dimension; ++i)
			{
				(*(*cur_Node).Child_Left).Optimal_Data[i] = (*cur_Node).Optimal_Data[i];
				(*(*cur_Node).Child_Right).Optimal_Data[i] = cur_Data[i];
			}
			(*(*cur_Node).Child_Left).Optimal_Fitness = (*cur_Node).Optimal_Fitness;
			(*(*cur_Node).Child_Right).Optimal_Fitness = cur_Fitness;
		}
		else
		{
			for(i=0; i< cur_Dimension; ++i)
			{
				(*(*cur_Node).Child_Left).Optimal_Data[i] = cur_Data[i];
				(*(*cur_Node).Child_Right).Optimal_Data[i] = (*cur_Node).Optimal_Data[i];
			}
			(*(*cur_Node).Child_Left).Optimal_Fitness = cur_Fitness;
			(*(*cur_Node).Child_Right).Optimal_Fitness = (*cur_Node).Optimal_Fitness;
		}
	}

	return;
}

double randn(double mean, double stdev)
{
	int i;
	double randn_value = 0;

	for(i=0; i< 12; ++i)
		randn_value += ((double) rand() / RAND_MAX - 0.5);
	
	return mean + stdev * randn_value;
}
