#ifndef MODDEA_KERNEL

#define MODDEA_KERNEL

typedef struct MOEA {
	int no_Dimension;
	int no_Function;
	double **SearchSpace;

	int Mutation_Mode;

	int CrossOver_Mode;
	double CrossOver_Rate;

	int Selection_Mode;

	int cur_Population_Size;
	int nxt_Population_Size;

	double **cur_Population;
	double **tmp_Population;
	double **nxt_Population;

	double **cur_Fitness;
	double **tmp_Fitness;
	double **nxt_Fitness;

	double *Processing_Time;

	int no_Generation;

	ParetoFront ParetoFront_Info;

	int *Optimization_Mode;

	double *IGD_Convergence;

} MOEA;

struct DENSITYNODE {
	int ID_Self;
	int ID_Parent;

	double Optimal_Fitness;
	double *Optimal_Data;

	double no_Visit;
	int Dimension;
	double Threshold;

	struct DENSITYNODE *Parent;
	struct DENSITYNODE *Child_Left;
	struct DENSITYNODE *Child_Right;
};

typedef struct DENSITYNODE DensityNode;

typedef struct DENSITYTREE {
	int Current_ID;

	int no_Dimension;
	int no_Leaf;
	double **Interval;

	int max_Archive_Size;
	int no_AxisBoundary;
	int *AxisBoundary_Set;

	DensityNode *Root;
	double **cur_Interval;

	int no_Revisit;

	int no_Visit;
	int Max_no_Visit;
} DensityTree;

typedef struct MODDEA {

	MOEA MOEA_Info;

	DensityTree Density_Tree;

} MODdEA;

#define MOEA_MAX_GENERATION 50000
#define MOEA_STOPPING_GENERATION 10

int MODdEA_IGD_Convergence_Flag;
ParetoFront MODdEA_OptimalParetoFront;

void MODdEA_Construction(MODdEA*, int, int, int, int, int);
void MODdEA_Destruction(MODdEA);

void MODdEA_Selection_SpatialProbabilistic(MODdEA*);

void MODdEA_Kernel(MODdEA*, int, double, void (*fn_ptr)(double*, double**));

void MOEA_Construction(MOEA*, int, int, int, int, int);
void MOEA_Destruction(MOEA);

void DensityTree_Construction(DensityTree*, int, int, int);
void DensityTree_Destruction(DensityTree);

void DensityNode_Contruction(DensityNode*, DensityNode*, int);
void DensityNode_Destruction(DensityNode);

void DensityNode_Interval(DensityNode*, DensityTree*);
DensityNode *DensityNode_Search(DensityNode*, double***, double*);

void DensityTree_Insertion(DensityTree*, double*, double, int);

double randn(double, double);

#endif

