#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<malloc.h>
#include<time.h>
#include"MultiObjective_Kernel.H"
#include"MultiObjective_TestFunction_Kernel.H"
#include"MyProblem.H"
#include"MODdEA_Kernel.H"
#include"MODdEA_Main.H"

int main()
{
	MODdEA_IEEETransEC();
	
	MODdEA_MyProblem();

	return 0;
}

void MODdEA_IEEETransEC()
{
	int i;
	int testfunction_index;
	int population_size, max_no_generation, no_evaluation;

	MODdEA cur_MODdEA;

	srand((unsigned) time(NULL));


	//============  STEP 1) Define test function index
	testfunction_index = 7;



	//============  STEP 2) Parameter setting for current run:
	//						i)  Population size
	//						ii) Number of evaluations

	switch (testfunction_index)
	{
		case 1:	//------ SCH
			population_size = 10;
			no_evaluation = 10000;
			break;
		case 2:	//------ FON
			population_size = 10;
			no_evaluation = 10000;
			break;
		case 3:	//------ POL
			population_size = 10;
			no_evaluation = 10000;
			break;
		case 4:	//------ KUR
			population_size = 10;
			no_evaluation = 10000;
			break;
		case 5:	//------ ZDT1
		case 6:	//------ ZDT2
		case 7:	//------ ZDT3
			population_size = 10;
			no_evaluation = 30000;
			break;
		case 8:	//------ ZDT4
			population_size = 10;
			no_evaluation = 10000;
			break;
		case 9:	//------ ZDT6
			population_size = 10;
			no_evaluation = 10000;
			break;
		case 10:	//------ CEC UnConstrained Problem 01
		case 11:	//------ CEC UnConstrained Problem 02
		case 12:	//------ CEC UnConstrained Problem 03
		case 13:	//------ CEC UnConstrained Problem 04
		case 14:	//------ CEC UnConstrained Problem 05
		case 15:	//------ CEC UnConstrained Problem 06
		case 16:	//------ CEC UnConstrained Problem 07
		case 17:	//------ CEC UnConstrained Problem 08
			population_size = 10;
			no_evaluation = 300000;
			break;
		case 18:	//------ CEC UnConstrained Problem 09
		case 19:	//------ CEC UnConstrained Problem 10
			population_size = 10;
			no_evaluation = 300000;
			break;
		case 20:	//------ DTLZ1
			population_size = 10;
			no_evaluation = 45000;
			break;
		case 21:	//------ DTLZ2
			population_size = 10;
			no_evaluation = 30000;
			break;
		case 32:	//------ Truly Disconnected 01
		case 33:	//------ Truly Disconnected 02
		case 34:	//------ Truly Disconnected 03
		case 35:	//------ Truly Disconnected 04
		case 36:	//------ Truly Disconnected 05
		case 37:	//------ Truly Disconnected 06
			population_size = 10;
			no_evaluation = 30000;
			break;
	}


	//============  STEP 3) Obtain the parameters of the tested MO function:
	//						i)    Number of dimensions
	//						ii)   Number of objectives
	//						iii)  Search space
	//						iv)   Function pointer
	//						v)    Function name
	//						vi)   Optimal Paretofront
	//						vii)  Optimization mode of each objective

	MultiObjective_TestFunction_Information(testfunction_index);
	MultiObjective_TestFunction_OptimalParetoFront_Construction(testfunction_index);



	//============  STEP 4) Construct a structure of MODdEA
	MODdEA_Construction(&cur_MODdEA, population_size, population_size,
						MultiObjective_TestFunction_no_Dimension,
						MultiObjective_TestFunction_no_Function, no_evaluation);



	//============  STEP 5) MODdEA parameter assignment
	//						i)   Search space
	//						ii)  Crossover rate
	//						iii) Ooptimization mode of each objective

	for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
	{
		cur_MODdEA.MOEA_Info.SearchSpace[i][0] = MultiObjective_TestFunction_SearchSpace[i][0];
		cur_MODdEA.MOEA_Info.SearchSpace[i][1] = MultiObjective_TestFunction_SearchSpace[i][1];
	}

	for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
		cur_MODdEA.MOEA_Info.Optimization_Mode[i] = MultiObjective_TestFunction_OptimizationMode[i];

	cur_MODdEA.MOEA_Info.CrossOver_Rate = 0.1;



	//============  STEP 6) Run MODdEA
	max_no_generation = no_evaluation / population_size;

	MODdEA_Kernel(&cur_MODdEA, 0, max_no_generation, MultiObjective_TestFunction_Pointer);



	//============  STEP 7) Compute and display IGD
	ParetoFront_IGD(&(cur_MODdEA.MOEA_Info.ParetoFront_Info), MultiObjective_TestFunction_OptimalParetoFront);

	printf("%d %d:  %d | %lf\n", testfunction_index, MultiObjective_TestFunction_no_Dimension, cur_MODdEA.MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution, cur_MODdEA.MOEA_Info.ParetoFront_Info.IGD);



	//============  STEP 8) Destruct the structures of MODdEA and Optimal paretofront
	MODdEA_Destruction(cur_MODdEA);

	ParetoFront_Info_Destruction(MultiObjective_TestFunction_OptimalParetoFront);

	return;
}


void MODdEA_MyProblem()
{
	int i, j;
	int no_dimension, no_function;
	int population_size, max_no_generation, no_evaluation;

	int no_OPF_solution;
	double cur_objective;
	FILE *OPF_ptr;

	MODdEA cur_MODdEA;

	ParetoFront MyProblem_OptimalParetoFront;

	srand((unsigned) time(NULL));


	//============  STEP 1) Parameter setting for current run:
	//						i)  Population size
	//						ii) Number of evaluations

	population_size = 10;
	no_evaluation = 3000;

	//============  STEP 2) Define the parameters of the tested MO function
	no_dimension = 2;
	no_function = 2;

	MyProblem_Bias[0][0] = 0.33;
	MyProblem_Bias[0][1] = 0.33;
	MyProblem_Bias[1][0] = 0.66;
	MyProblem_Bias[1][1] = 0.66;

	//============  STEP 3) Obtain the parameters of the tested MO function (Optimal)
	//						Load from the file "MyProblem_OptimalParetofront"
	OPF_ptr = fopen("MyProblem_OptimalParetofront", "r");

	fscanf(OPF_ptr, "%d", &no_OPF_solution);
	ParetoFront_Info_Construction(&MyProblem_OptimalParetoFront, no_OPF_solution,
								  no_dimension,
								  no_function);

	MyProblem_OptimalParetoFront.no_ParetoFront_Solution = no_OPF_solution;
	for(i=0; i< no_OPF_solution; ++i)
	{
		for(j=0; j< no_function; ++j)
		{
			fscanf(OPF_ptr, "%lf", &cur_objective);
			MyProblem_OptimalParetoFront.ParetoFront_Fitness[i][j] = cur_objective;
		}
		MyProblem_OptimalParetoFront.ParetoFront_Rank[i] = 1;
	}

	fclose(OPF_ptr);


	//============  STEP 3) Construct a structure of MODdEA
	MODdEA_Construction(&cur_MODdEA, population_size, population_size,
						no_dimension,
						no_function, no_evaluation);



	//============  STEP 4) MODdEA parameter assignment
	//						i)   Search space
	//						ii)  Crossover rate
	//						iii) Ooptimization mode of each objective

	for(i=0; i< no_dimension; ++i)
	{
		cur_MODdEA.MOEA_Info.SearchSpace[i][0] = 0.0;
		cur_MODdEA.MOEA_Info.SearchSpace[i][1] = 1.0;
	}

	cur_MODdEA.MOEA_Info.Optimization_Mode[0] = 0;
	cur_MODdEA.MOEA_Info.Optimization_Mode[1] = 1;

	cur_MODdEA.MOEA_Info.CrossOver_Rate = 0.1;



	//============  STEP 6) Run MODdEA
	max_no_generation = no_evaluation / population_size;

	MODdEA_Kernel(&cur_MODdEA, 0, max_no_generation, MyProblem);


	//============  STEP 7) Compute and display IGD  (Optimal)
	ParetoFront_IGD(&(cur_MODdEA.MOEA_Info.ParetoFront_Info), MyProblem_OptimalParetoFront);

	printf("IGD = %lf\n", cur_MODdEA.MOEA_Info.ParetoFront_Info.IGD);



	OPF_ptr = fopen("MyProblem_Result", "w");

	for(i=0; i< cur_MODdEA.MOEA_Info.ParetoFront_Info.no_ParetoFront_Solution; ++i)
	{
		if(cur_MODdEA.MOEA_Info.ParetoFront_Info.ParetoFront_Rank[i] == 1)
		{
			for(j=0; j< no_function; ++j)
				fprintf(OPF_ptr, "%lf ", cur_MODdEA.MOEA_Info.ParetoFront_Info.ParetoFront_Fitness[i][j]);
			fprintf(OPF_ptr, "\n");
		}
	}

	fclose(OPF_ptr);


	//============  STEP 8) Destruct the structure of MODdEA
	MODdEA_Destruction(cur_MODdEA);

	//============  STEP 9) Destruct the structure of the optimal paretofront (Optimal)
	ParetoFront_Info_Destruction(MyProblem_OptimalParetoFront);

	return;
}
