#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>
#include<math.h>
#include<time.h>
#include"MultiObjective_Kernel.H"

void ParetoFront_Info_Construction(ParetoFront *cur_ParetoFront, int max_no_solution, int no_dimension, int no_function)
{
	int i;

	(*cur_ParetoFront).Max_no_Solution = max_no_solution;

	(*cur_ParetoFront).no_ParetoFront_Solution = 0;
	(*cur_ParetoFront).no_Dimension = no_dimension;
	(*cur_ParetoFront).no_Function = no_function;

	(*cur_ParetoFront).IGD = -1.0;

	(*cur_ParetoFront).ParetoFront_Solution = malloc(sizeof(double*) * max_no_solution);
	(*cur_ParetoFront).ParetoFront_Fitness = malloc(sizeof(double*) * max_no_solution);
	(*cur_ParetoFront).ParetoFront_Rank = malloc(sizeof(int) * max_no_solution);
	for(i=0; i< max_no_solution; ++i)
	{
		(*cur_ParetoFront).ParetoFront_Solution[i] = malloc(sizeof(double) * no_dimension);
		(*cur_ParetoFront).ParetoFront_Fitness[i] = malloc(sizeof(double) * no_function);
	}

	return;
}

void ParetoFront_Info_Destruction(ParetoFront cur_ParetoFront)
{
	int i;

	for(i=0; i< cur_ParetoFront.Max_no_Solution; ++i)
	{
		free(cur_ParetoFront.ParetoFront_Solution[i]);
		free(cur_ParetoFront.ParetoFront_Fitness[i]);
	}
	free(cur_ParetoFront.ParetoFront_Solution);
	free(cur_ParetoFront.ParetoFront_Fitness);
	free(cur_ParetoFront.ParetoFront_Rank);

	return;
}

void ParetoFront_Info_Expansion(ParetoFront *cur_ParetoFront, int added_no_Solution)
{
	int i;
	int updated_Max_no_Solution;

	updated_Max_no_Solution = (*cur_ParetoFront).Max_no_Solution + added_no_Solution;

	(*cur_ParetoFront).ParetoFront_Solution = realloc((*cur_ParetoFront).ParetoFront_Solution, sizeof(double*) * updated_Max_no_Solution);
	(*cur_ParetoFront).ParetoFront_Fitness = realloc((*cur_ParetoFront).ParetoFront_Fitness, sizeof(double*) * updated_Max_no_Solution);
	(*cur_ParetoFront).ParetoFront_Rank = realloc((*cur_ParetoFront).ParetoFront_Rank, sizeof(int) * updated_Max_no_Solution);
	
	for(i=(*cur_ParetoFront).Max_no_Solution; i < updated_Max_no_Solution; ++i)
	{
		(*cur_ParetoFront).ParetoFront_Solution[i] = malloc(sizeof(double) * (*cur_ParetoFront).no_Dimension);
		(*cur_ParetoFront).ParetoFront_Fitness[i] = malloc(sizeof(double) * (*cur_ParetoFront).no_Function);
	}

	(*cur_ParetoFront).Max_no_Solution = updated_Max_no_Solution;

	return;
}

void ParetoFront_Construction(ParetoFront *cur_ParetoFront, int *OptimizationMode)
{
	int i, j, k;
	int no_paretofront, no_invalid_paretofront;
	int *invalid_paretofront_index;
	int dominant_flag_ij, dominant_flag_ji;

	ParetoFront upd_ParetoFront;

	invalid_paretofront_index = malloc(sizeof(int) * (*cur_ParetoFront).no_ParetoFront_Solution);

	no_invalid_paretofront = (*cur_ParetoFront).no_ParetoFront_Solution;
	for(i=0; i< (*cur_ParetoFront).no_ParetoFront_Solution; ++i)
	{
		(*cur_ParetoFront).ParetoFront_Rank[i] = 0;
		invalid_paretofront_index[i] = i;
	}

	for(j=0; j< (*cur_ParetoFront).no_Function; ++j)
		if(OptimizationMode[j] == 1)
			for(i=0; i< (*cur_ParetoFront).no_ParetoFront_Solution; ++i)
				(*cur_ParetoFront).ParetoFront_Fitness[i][j] *= -1.0;

	no_paretofront = 0;
	while(no_invalid_paretofront > 0)
	{
		++no_paretofront;
		for(i=0; i< no_invalid_paretofront; ++i)
			(*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[i]] = no_paretofront;

		for(i=0; i< no_invalid_paretofront; ++i)
		{
			if((*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[i]] == no_paretofront)
			{
				for(j=i+1; j<no_invalid_paretofront; ++j)
				{
					if((*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[j]] == no_paretofront)
					{
						dominant_flag_ji = 1;
						for(k=0; k< (*cur_ParetoFront).no_Function; ++k)
							if((*cur_ParetoFront).ParetoFront_Fitness[invalid_paretofront_index[i]][k] < (*cur_ParetoFront).ParetoFront_Fitness[invalid_paretofront_index[j]][k])
							{
								dominant_flag_ji = 0;
								break;
							}

						if(dominant_flag_ji == 1)
						{
							(*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[i]] = 0;
							break;
						}
						else
						{
							dominant_flag_ij = 1;
							for(k=0; k< (*cur_ParetoFront).no_Function; ++k)
								if((*cur_ParetoFront).ParetoFront_Fitness[invalid_paretofront_index[j]][k] < (*cur_ParetoFront).ParetoFront_Fitness[invalid_paretofront_index[i]][k])
								{
									dominant_flag_ij = 0;
									break;
								}

							if(dominant_flag_ij == 1)
								(*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[j]] = 0;
						}
					}
				}
			}
		}
    
		no_invalid_paretofront = 0;
		for(i=0; i< (*cur_ParetoFront).no_ParetoFront_Solution; ++i)
		{
			if((*cur_ParetoFront).ParetoFront_Rank[i] == 0)
			{
				invalid_paretofront_index[no_invalid_paretofront] = i;
				++no_invalid_paretofront;
			}
		}
	}

	ParetoFront_Info_Construction(&upd_ParetoFront, (*cur_ParetoFront).Max_no_Solution, (*cur_ParetoFront).no_Dimension, (*cur_ParetoFront).no_Function);

	for(i=1; i<= no_paretofront; ++i)
		for(j=0; j< (*cur_ParetoFront).no_ParetoFront_Solution; ++j)
			if((*cur_ParetoFront).ParetoFront_Rank[j] == i)
			{
				for(k=0; k< (*cur_ParetoFront).no_Dimension; ++k)
					upd_ParetoFront.ParetoFront_Solution[upd_ParetoFront.no_ParetoFront_Solution][k] = (*cur_ParetoFront).ParetoFront_Solution[j][k];
				for(k=0; k< (*cur_ParetoFront).no_Function; ++k)
					upd_ParetoFront.ParetoFront_Fitness[upd_ParetoFront.no_ParetoFront_Solution][k] = (*cur_ParetoFront).ParetoFront_Fitness[j][k];
				upd_ParetoFront.ParetoFront_Rank[upd_ParetoFront.no_ParetoFront_Solution] = (*cur_ParetoFront).ParetoFront_Rank[j];
				++upd_ParetoFront.no_ParetoFront_Solution;
			}

	ParetoFront_Info_Destruction((*cur_ParetoFront));

	(*cur_ParetoFront).ParetoFront_Solution = upd_ParetoFront.ParetoFront_Solution;
	(*cur_ParetoFront).ParetoFront_Fitness = upd_ParetoFront.ParetoFront_Fitness;
	(*cur_ParetoFront).ParetoFront_Rank = upd_ParetoFront.ParetoFront_Rank;
	
	free(invalid_paretofront_index);

	for(j=0; j< (*cur_ParetoFront).no_Function; ++j)
		if(OptimizationMode[j] == 1)
			for(i=0; i< (*cur_ParetoFront).no_ParetoFront_Solution; ++i)
				(*cur_ParetoFront).ParetoFront_Fitness[i][j] *= -1.0;

	return;
}

void ParetoFront_OptimalConstruction(ParetoFront *cur_ParetoFront, int *OptimizationMode)
{
	int i, j, k;
	int no_paretofront, no_invalid_paretofront;
	int *invalid_paretofront_index;
	int dominant_flag_ij, dominant_flag_ji;

	ParetoFront upd_ParetoFront;

	invalid_paretofront_index = malloc(sizeof(int) * (*cur_ParetoFront).no_ParetoFront_Solution);

	no_invalid_paretofront = (*cur_ParetoFront).no_ParetoFront_Solution;
	for(i=0; i< (*cur_ParetoFront).no_ParetoFront_Solution; ++i)
	{
		(*cur_ParetoFront).ParetoFront_Rank[i] = 2;
		invalid_paretofront_index[i] = i;
	}

	for(j=0; j< (*cur_ParetoFront).no_Function; ++j)
		if(OptimizationMode[j] == 1)
			for(i=0; i< (*cur_ParetoFront).no_ParetoFront_Solution; ++i)
				(*cur_ParetoFront).ParetoFront_Fitness[i][j] *= -1.0;

	no_paretofront = 0;
	while(no_invalid_paretofront > 0 && no_paretofront < 1)
	{
		++no_paretofront;
		for(i=0; i< no_invalid_paretofront; ++i)
			(*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[i]] = no_paretofront;

		for(i=0; i< no_invalid_paretofront; ++i)
		{
			if((*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[i]] == no_paretofront)
			{
				for(j=i+1; j<no_invalid_paretofront; ++j)
				{
					if((*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[j]] == no_paretofront)
					{
						dominant_flag_ji = 1;
						for(k=0; k< (*cur_ParetoFront).no_Function; ++k)
							if((*cur_ParetoFront).ParetoFront_Fitness[invalid_paretofront_index[i]][k] < (*cur_ParetoFront).ParetoFront_Fitness[invalid_paretofront_index[j]][k])
							{
								dominant_flag_ji = 0;
								break;
							}

						if(dominant_flag_ji == 1)
						{
							(*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[i]] = 0;
							break;
						}
						else
						{
							dominant_flag_ij = 1;
							for(k=0; k< (*cur_ParetoFront).no_Function; ++k)
								if((*cur_ParetoFront).ParetoFront_Fitness[invalid_paretofront_index[j]][k] < (*cur_ParetoFront).ParetoFront_Fitness[invalid_paretofront_index[i]][k])
								{
									dominant_flag_ij = 0;
									break;
								}

							if(dominant_flag_ij == 1)
								(*cur_ParetoFront).ParetoFront_Rank[invalid_paretofront_index[j]] = 0;
						}
					}
				}
			}
		}
    
		no_invalid_paretofront = 0;
		for(i=0; i< (*cur_ParetoFront).no_ParetoFront_Solution; ++i)
		{
			if((*cur_ParetoFront).ParetoFront_Rank[i] == 0)
			{
				invalid_paretofront_index[no_invalid_paretofront] = i;
				++no_invalid_paretofront;
			}
		}
	}

	ParetoFront_Info_Construction(&upd_ParetoFront, (*cur_ParetoFront).Max_no_Solution, (*cur_ParetoFront).no_Dimension, (*cur_ParetoFront).no_Function);

	for(i=0; i< (*cur_ParetoFront).no_ParetoFront_Solution; ++i)
		upd_ParetoFront.ParetoFront_Rank[i] = 2;

	for(i=1; i<= no_paretofront; ++i)
		for(j=0; j< (*cur_ParetoFront).no_ParetoFront_Solution; ++j)
			if((*cur_ParetoFront).ParetoFront_Rank[j] == i)
			{
				for(k=0; k< (*cur_ParetoFront).no_Dimension; ++k)
					upd_ParetoFront.ParetoFront_Solution[upd_ParetoFront.no_ParetoFront_Solution][k] = (*cur_ParetoFront).ParetoFront_Solution[j][k];
				for(k=0; k< (*cur_ParetoFront).no_Function; ++k)
					upd_ParetoFront.ParetoFront_Fitness[upd_ParetoFront.no_ParetoFront_Solution][k] = (*cur_ParetoFront).ParetoFront_Fitness[j][k];
				upd_ParetoFront.ParetoFront_Rank[upd_ParetoFront.no_ParetoFront_Solution] = (*cur_ParetoFront).ParetoFront_Rank[j];
				++upd_ParetoFront.no_ParetoFront_Solution;
			}

	ParetoFront_Info_Destruction((*cur_ParetoFront));

	(*cur_ParetoFront).ParetoFront_Solution = upd_ParetoFront.ParetoFront_Solution;
	(*cur_ParetoFront).ParetoFront_Fitness = upd_ParetoFront.ParetoFront_Fitness;
	(*cur_ParetoFront).ParetoFront_Rank = upd_ParetoFront.ParetoFront_Rank;
	
	free(invalid_paretofront_index);

	for(j=0; j< (*cur_ParetoFront).no_Function; ++j)
		if(OptimizationMode[j] == 1)
			for(i=0; i< (*cur_ParetoFront).no_ParetoFront_Solution; ++i)
				(*cur_ParetoFront).ParetoFront_Fitness[i][j] *= -1.0;

	return;
}

void ParetoFrontTruncation(ParetoFront *cur_ParetoFront, int min_no_Point)
{
	int cur_no_point;

	if((*cur_ParetoFront).no_ParetoFront_Solution > min_no_Point)
	{
		cur_no_point = 1;
		while(cur_no_point < min_no_Point || (*cur_ParetoFront).ParetoFront_Rank[cur_no_point] == (*cur_ParetoFront).ParetoFront_Rank[cur_no_point-1])
			++cur_no_point;

		(*cur_ParetoFront).no_ParetoFront_Solution = cur_no_point;
	}

	return;
}

void ParetoFront_Save(ParetoFront cur_ParetoFront, FILE *ptr, int mode)
{
	int i, j;

	fprintf(ptr, "%d %d %d\n", cur_ParetoFront.no_Dimension, cur_ParetoFront.no_Function, cur_ParetoFront.no_ParetoFront_Solution);
	for(i=0; i <cur_ParetoFront.no_ParetoFront_Solution; ++i)
	{
		if(mode == 1)
			for(j=0; j< cur_ParetoFront.no_Dimension; ++j)
				fprintf(ptr, "%lf ", cur_ParetoFront.ParetoFront_Solution[i][j]);

		for(j=0; j< cur_ParetoFront.no_Function; ++j)
			fprintf(ptr, "%lf ", cur_ParetoFront.ParetoFront_Fitness[i][j]);

		if(mode == 1)
			fprintf(ptr, "%d\n", cur_ParetoFront.ParetoFront_Rank[i]);
		else
			fprintf(ptr, "\n");
	}
	
	if(mode == 1)
		fprintf(ptr, "%lf\n", cur_ParetoFront.IGD);

	return;
}

void ParetoFront_IGD(ParetoFront *est_ParetoFront, ParetoFront dsr_ParetoFront)
{
	int i, j, k;
	int no_est_PF_solution, no_dsr_PF_solution;
	double cur_distance, min_distance;

	for(no_est_PF_solution=0; no_est_PF_solution < (*est_ParetoFront).no_ParetoFront_Solution; ++no_est_PF_solution)
		if((*est_ParetoFront).ParetoFront_Rank[no_est_PF_solution] > 1)
			break;

	for(no_dsr_PF_solution=0; no_dsr_PF_solution < dsr_ParetoFront.no_ParetoFront_Solution; ++no_dsr_PF_solution)
		if(dsr_ParetoFront.ParetoFront_Rank[no_dsr_PF_solution] > 1)
			break;

	(*est_ParetoFront).IGD =0.0;
	for(i=0; i < no_dsr_PF_solution; ++i)
	{
		min_distance = 0.0;
		for(k=0; k< (*est_ParetoFront).no_Function; ++k)
			min_distance += pow(dsr_ParetoFront.ParetoFront_Fitness[i][k] - (*est_ParetoFront).ParetoFront_Fitness[0][k], 2);

		for(j=1; j< no_est_PF_solution; ++j)
		{
			cur_distance = 0.0;
			for(k=0; k< (*est_ParetoFront).no_Function; ++k)
				cur_distance += pow(dsr_ParetoFront.ParetoFront_Fitness[i][k] - (*est_ParetoFront).ParetoFront_Fitness[j][k], 2);

			if(min_distance > cur_distance)
				min_distance = cur_distance;
		}

		(*est_ParetoFront).IGD += sqrt(min_distance);
	}

	(*est_ParetoFront).IGD /= no_dsr_PF_solution;

	return;
}

void ParetoFront_Testing()
{
	int i, no_sample, no_dimension, no_function;
	int *OptimizationMode;
	ParetoFront cur_ParetoFront;
	FILE *ptr;

	no_sample = 100;
	no_function = 2;
	no_dimension = 1;

	OptimizationMode = malloc(sizeof(int) * no_function);

	ParetoFront_Info_Construction(&cur_ParetoFront, no_sample, no_dimension, no_function);

	OptimizationMode[0] = 0;
	OptimizationMode[1] = 0;

	for(i=0; i< no_sample; ++i)
	{
		cur_ParetoFront.ParetoFront_Solution[i][0] = i;
		cur_ParetoFront.ParetoFront_Fitness[i][0] = (double) rand() / RAND_MAX;
		cur_ParetoFront.ParetoFront_Fitness[i][1] = (double) rand() / RAND_MAX;
		while (cur_ParetoFront.ParetoFront_Fitness[i][0] + cur_ParetoFront.ParetoFront_Fitness[i][1] < 1.0)
		{
			cur_ParetoFront.ParetoFront_Fitness[i][0] = (double) rand() / RAND_MAX;
			cur_ParetoFront.ParetoFront_Fitness[i][1] = (double) rand() / RAND_MAX;
		}

		cur_ParetoFront.ParetoFront_Rank[i] = i;
	}

	cur_ParetoFront.no_ParetoFront_Solution = no_sample;

	ParetoFront_Construction(&cur_ParetoFront, OptimizationMode);

	ptr = fopen("ParetoFront_Sample", "w");
	ParetoFront_Save(cur_ParetoFront, ptr, 1);
	fclose(ptr);

	ParetoFront_Info_Destruction(cur_ParetoFront);

	free(OptimizationMode);

	return;
}