#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>
#include<math.h>
#include<time.h>
#include"MultiObjective_TestFunction_Kernel.H"

void MultiObjective_TestFunction_Information(int MultiObjective_TestFunction_Index)
{
	int i;

	switch(MultiObjective_TestFunction_Index)
	{
		case 1:			//------------ SCH
			MultiObjective_TestFunction_no_Dimension = 1;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_SCH;
			sprintf(MultiObjective_TestFunction_Name, "SCH");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -1000.0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1000.0;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 2:			//------------ FON
			MultiObjective_TestFunction_no_Dimension = 3;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_FON;
			sprintf(MultiObjective_TestFunction_Name, "FON");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -4.0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 4.0;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 3:			//------------ POL
			MultiObjective_TestFunction_no_Dimension = 2;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_POL;
			sprintf(MultiObjective_TestFunction_Name, "POL");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -PI;
				MultiObjective_TestFunction_SearchSpace[i][1] = PI;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 4:			//------------ KUR
			MultiObjective_TestFunction_no_Dimension = 3;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_KUR;
			sprintf(MultiObjective_TestFunction_Name, "KUR");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -5;
				MultiObjective_TestFunction_SearchSpace[i][1] = 5;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 5:			//------------ ZDT1
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_ZDT1;
			sprintf(MultiObjective_TestFunction_Name, "ZDT1");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 6:			//------------ ZDT2
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_ZDT2;
			sprintf(MultiObjective_TestFunction_Name, "ZDT2");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 7:			//------------ ZDT3
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_ZDT3;
			sprintf(MultiObjective_TestFunction_Name, "ZDT3");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 8:			//------------ ZDT4
			MultiObjective_TestFunction_no_Dimension = 10;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_ZDT4;
			sprintf(MultiObjective_TestFunction_Name, "ZDT4");
			MultiObjective_TestFunction_SearchSpace[0][0] = 0;
			MultiObjective_TestFunction_SearchSpace[0][1] = 1;
			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -5;
				MultiObjective_TestFunction_SearchSpace[i][1] = 5;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 9:			//------------ ZDT6
			MultiObjective_TestFunction_no_Dimension = 10;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_ZDT6;
			sprintf(MultiObjective_TestFunction_Name, "ZDT6");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 10:		//------------ CEC UnConstrained Problem 01
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem01;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem01");
			MultiObjective_TestFunction_SearchSpace[0][0] = 0;
			MultiObjective_TestFunction_SearchSpace[0][1] = 1;
			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -1;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 11:		//------------ CEC UnConstrained Problem 02
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem02;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem02");
			MultiObjective_TestFunction_SearchSpace[0][0] = 0;
			MultiObjective_TestFunction_SearchSpace[0][1] = 1;
			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -1;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 12:		//------------ CEC UnConstrained Problem 03
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem03;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem03");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 13:		//------------ CEC UnConstrained Problem 04
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem04;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem04");
			MultiObjective_TestFunction_SearchSpace[0][0] = 0;
			MultiObjective_TestFunction_SearchSpace[0][1] = 1;
			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -2;
				MultiObjective_TestFunction_SearchSpace[i][1] = 2;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 14:		//------------ CEC UnConstrained Problem 05
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_CECUnConstrainedProblem05_N = 10;
			MultiObjective_TestFunction_CECUnConstrainedProblem05_e = 0.1;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem05;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem05");
			MultiObjective_TestFunction_SearchSpace[0][0] = 0;
			MultiObjective_TestFunction_SearchSpace[0][1] = 1;
			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -1;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 15:		//------------ CEC UnConstrained Problem 06
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_CECUnConstrainedProblem06_N = 2;
			MultiObjective_TestFunction_CECUnConstrainedProblem06_e = 0.1;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem06;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem06");
			MultiObjective_TestFunction_SearchSpace[0][0] = 0;
			MultiObjective_TestFunction_SearchSpace[0][1] = 1;
			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -1;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 16:		//------------ CEC UnConstrained Problem 07
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem07;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem07");
			MultiObjective_TestFunction_SearchSpace[0][0] = 0;
			MultiObjective_TestFunction_SearchSpace[0][1] = 1;
			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -1;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 17:		//------------ CEC UnConstrained Problem 08
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 3;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem08;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem08");
			for(i=0; i< 2; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}
			for(i=2; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -2;
				MultiObjective_TestFunction_SearchSpace[i][1] = 2;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 18:		//------------ CEC UnConstrained Problem 09
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 3;
			MultiObjective_TestFunction_CECUnConstrainedProblem09_e = 0.1;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem09;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem09");
			for(i=0; i< 2; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}
			for(i=2; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -2;
				MultiObjective_TestFunction_SearchSpace[i][1] = 2;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 19:		//------------ CEC UnConstrained Problem 10
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 3;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_CECUnConstrainedProblem10;
			sprintf(MultiObjective_TestFunction_Name, "CECUnConstrainedProblem10");
			for(i=0; i< 2; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}
			for(i=2; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -2;
				MultiObjective_TestFunction_SearchSpace[i][1] = 2;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 20:		//------------ DTLZ1
			MultiObjective_TestFunction_no_Dimension = 10;
			MultiObjective_TestFunction_no_Function = 3;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_DTLZ1;
			sprintf(MultiObjective_TestFunction_Name, "DTLZ1");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 21:		//------------ DTLZ2
			MultiObjective_TestFunction_no_Dimension = 10;
			MultiObjective_TestFunction_no_Function = 3;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_DTLZ2;
			sprintf(MultiObjective_TestFunction_Name, "DTLZ2");
			for(i=0; i< 2; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}
			for(i=2; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = -1;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 32:		//------------ Truly Disconnected 01
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_TrulyDisconnected01;
			sprintf(MultiObjective_TestFunction_Name, "TrulyDisconnected01");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1.5;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 33:		//------------ Truly Disconnected 02
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_TrulyDisconnected02;
			sprintf(MultiObjective_TestFunction_Name, "TrulyDisconnected02");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 1.46;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 34:		//------------ Truly Disconnected 03
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_TrulyDisconnected03;
			sprintf(MultiObjective_TestFunction_Name, "TrulyDisconnected03");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 2.0;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 35:		//------------ Truly Disconnected 04
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_TrulyDisconnected04;
			sprintf(MultiObjective_TestFunction_Name, "TrulyDisconnected04");
			for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 2.0;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 36:		//------------ Truly Disconnected 05
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_TrulyDisconnected05;
			sprintf(MultiObjective_TestFunction_Name, "TrulyDisconnected05");
			MultiObjective_TestFunction_SearchSpace[0][0] = 0.6;
			MultiObjective_TestFunction_SearchSpace[0][1] = 4.6;
			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0.0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 3.0;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
		case 37:		//------------ Truly Disconnected 06
			MultiObjective_TestFunction_no_Dimension = 30;
			MultiObjective_TestFunction_no_Function = 2;
			MultiObjective_TestFunction_Pointer = MultiObjective_TestFunction_TrulyDisconnected06;
			sprintf(MultiObjective_TestFunction_Name, "TrulyDisconnected06");
			MultiObjective_TestFunction_SearchSpace[0][0] = 0.7;
			MultiObjective_TestFunction_SearchSpace[0][1] = 4.6;
			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
			{
				MultiObjective_TestFunction_SearchSpace[i][0] = 0.0;
				MultiObjective_TestFunction_SearchSpace[i][1] = 3.0;
			}

			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				MultiObjective_TestFunction_OptimizationMode[i] = 0;
			break;
	}

	return;
}

//================================================================================================================
//======================== Real Valued UnConstrained MultiObjective Function =====================================
//================================================================================================================
void MultiObjective_TestFunction_OptimalParetoFront_Construction(int testfunction_index)
{
	char OptimalParetoSolution_filename[256];
	int i, j, k;
	int no_OPF_solution, no_OPF_subsolution, *OptimizationMode;
	double lb, ub, f3;
	double *OPF_solution;

	FILE *ptr;

	switch(testfunction_index)
	{
		case 1:		//------------ SCH
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);
			
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				OPF_solution[0] = (double) i / (no_OPF_solution-1) * 2.0;
				MultiObjective_TestFunction_SCH(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i]);
			}

			free(OPF_solution);

			break;
		case 2:		//------------ FON
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);
			
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				OPF_solution[0] = OPF_solution[1] = OPF_solution[2] = (double) i / (no_OPF_solution-1) * 2.0 / sqrt(3) - 1.0 / sqrt(3);
				MultiObjective_TestFunction_FON(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i]);
			}

			free(OPF_solution);

			break;
		case 3:		//------------ POL
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);

			ptr = fopen("MultiObjective_Testfunction_POL_OptimalParetofront", "r");
			fscanf(ptr, "%d", &no_OPF_solution);

			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				for(j=0; j< MultiObjective_TestFunction_no_Dimension; ++j)
					fscanf(ptr, "%lf", &OPF_solution[j]);

				MultiObjective_TestFunction_POL(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i]);
			}

			free(OPF_solution);
			fclose(ptr);

			break;
		case 4:		//------------ KUR
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);

			ptr = fopen("MultiObjective_Testfunction_KUR_OptimalParetofront", "r");
			fscanf(ptr, "%d", &no_OPF_solution);

			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				for(j=0; j< MultiObjective_TestFunction_no_Dimension; ++j)
					fscanf(ptr, "%lf", &OPF_solution[j]);

				MultiObjective_TestFunction_KUR(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i]);
			}

			free(OPF_solution);
			fclose(ptr);

			break;
		case 5:		//------------ ZDT1
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);
			
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
				OPF_solution[i] = 0.0;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				OPF_solution[0] = (double) i / (no_OPF_solution-1) ;
				MultiObjective_TestFunction_ZDT1(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i]);
			}

			free(OPF_solution);

			break;
		case 6:		//------------ ZDT2
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);
			
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
				OPF_solution[i] = 0.0;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				OPF_solution[0] = (double) i / (no_OPF_solution-1) ;
				MultiObjective_TestFunction_ZDT2(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i]);
			}

			free(OPF_solution);

			break;
		case 7:		//------------ ZDT3
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);
			
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
				OPF_solution[i] = 0.0;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				OPF_solution[0] = (double) i / (no_OPF_solution-1) ;
				MultiObjective_TestFunction_ZDT3(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i]);
			}

			OptimizationMode = malloc(sizeof(int) * MultiObjective_TestFunction_no_Function);
			for(i=0; i< MultiObjective_TestFunction_no_Function; ++i)
				OptimizationMode[i] = 0;

			ParetoFront_Construction(&MultiObjective_TestFunction_OptimalParetoFront, OptimizationMode);
			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
				if(MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Rank[i] > 1)
					break;
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = i;

			free(OPF_solution);
			free(OptimizationMode);

			break;
		case 8:		//------------ ZDT4
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);
			
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
				OPF_solution[i] = 0.0;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				OPF_solution[0] = (double) i / (no_OPF_solution-1) ;
				MultiObjective_TestFunction_ZDT4(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i]);
			}

			free(OPF_solution);

			break;
		case 9:		//------------ ZDT6
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);
			
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
				OPF_solution[i] = 0.0;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				OPF_solution[0] = (double) i / (no_OPF_solution-1) ;
				MultiObjective_TestFunction_ZDT6(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i]);
			}

			free(OPF_solution);

			break;
		case 10:	//------------ CEC UnConstrained Problem 01
		case 11:	//------------ CEC UnConstrained Problem 02
		case 12:	//------------ CEC UnConstrained Problem 03
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][0] = (double) i / (no_OPF_solution-1);
				MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][1] = 1.0 - sqrt(MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][0]);
			}

			break;
		case 13:	//------------ CEC UnConstrained Problem 04
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][0] = (double) i / (no_OPF_solution-1);
				MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][1] = 1.0 - pow(MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][0], 2);
			}

			break;
		case 14:	//------------ CEC UnConstrained Problem 05
			no_OPF_solution = 2*MultiObjective_TestFunction_CECUnConstrainedProblem05_N + 1;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][0] = (double) i / (2*MultiObjective_TestFunction_CECUnConstrainedProblem05_N);
				MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][1] = 1.0 - MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][0];
			}

			break;
		case 15:	//------------ CEC UnConstrained Problem 06
			no_OPF_subsolution = (int) ceil(5000.0 / MultiObjective_TestFunction_CECUnConstrainedProblem06_N);
			no_OPF_solution = no_OPF_subsolution * MultiObjective_TestFunction_CECUnConstrainedProblem06_N;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=1; i<= MultiObjective_TestFunction_CECUnConstrainedProblem06_N; ++i)
			{
				lb = (double) (2.0*i-1) / (2*MultiObjective_TestFunction_CECUnConstrainedProblem06_N);
				ub = (double) (2.0*i) / (2*MultiObjective_TestFunction_CECUnConstrainedProblem06_N);
				for(j=0; j< no_OPF_subsolution; ++j)
					MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[(i-1)*no_OPF_subsolution+j][0] = (double) j / (no_OPF_subsolution-1) * (ub-lb) + lb;
			}

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
				MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][1] = 1.0 - MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][0];

			break;
		case 16:	//------------ CEC UnConstrained Problem 07
			no_OPF_solution = 5000;
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][0] = (double) i / (no_OPF_solution-1);
				MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][1] = 1.0 - MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][0];
			}

			break;
		case 17:	//------------ CEC UnConstrained Problem 08
		case 19:	//------------ CEC UnConstrained Problem 10
		case 21:	//------------ DTLZ2
			no_OPF_subsolution = (int) ceil(sqrt(5000));
			no_OPF_solution = (int) pow(no_OPF_subsolution,2);
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< no_OPF_subsolution; ++i)
			{
				lb = (double) i / (no_OPF_subsolution-1) * PI / 2.0;
				for(j=0; j< no_OPF_subsolution; ++j)
				{
					ub = (double) j / (no_OPF_subsolution-1) * PI / 2.0;
					MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i*no_OPF_subsolution+j][0] = cos(lb)*cos(ub);
					MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i*no_OPF_subsolution+j][1] = cos(lb)*sin(ub);
					MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i*no_OPF_subsolution+j][2] = sin(lb);
				}
			}

			break;
		case 18:	//------------ CEC UnConstrained Problem 09
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);

			no_OPF_subsolution = (int) ceil(sqrt(5000.0 / 2.0));
			no_OPF_solution = 2 * (int) pow(no_OPF_subsolution,2);
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< no_OPF_subsolution; ++i)
			{
				OPF_solution[0] = (double) i / (no_OPF_subsolution-1) * 0.25;
				for(j=0; j< no_OPF_subsolution; ++j)
				{
					OPF_solution[1]= (double) j / (no_OPF_subsolution-1);

					for(k=2; k< MultiObjective_TestFunction_no_Dimension; ++k)
						OPF_solution[k] = 2.0 * OPF_solution[1] * sin(2.0*PI*OPF_solution[0] + (k+1)*PI/MultiObjective_TestFunction_no_Dimension);

					MultiObjective_TestFunction_CECUnConstrainedProblem09(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i*no_OPF_subsolution+j]);
				}
			}

			for(i=0; i< no_OPF_subsolution; ++i)
			{
				OPF_solution[0] = (double) i / (no_OPF_subsolution-1) * 0.25 + 0.75;
				for(j=0; j< no_OPF_subsolution; ++j)
				{
					OPF_solution[1]= (double) j / (no_OPF_subsolution-1);

					for(k=2; k< MultiObjective_TestFunction_no_Dimension; ++k)
						OPF_solution[k] = 2.0 * OPF_solution[1] * sin(2.0*PI*OPF_solution[0] + (k+1)*PI/MultiObjective_TestFunction_no_Dimension);

					MultiObjective_TestFunction_CECUnConstrainedProblem09(OPF_solution, &MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i*no_OPF_subsolution+j + (int) pow(no_OPF_subsolution,2)]);
				}
			}

			free(OPF_solution);

			break;
		case 20:	//------------ DTLZ1
			no_OPF_subsolution = (int) ceil(sqrt(5000));
			no_OPF_solution = (int) pow(no_OPF_subsolution,2);
			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< no_OPF_subsolution; ++i)
			{
				lb = (double) i / (no_OPF_subsolution-1);
				for(j=0; j< no_OPF_subsolution; ++j)
				{
					ub = (double) j / (no_OPF_subsolution-1) * (1.0 - lb);
					MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i*no_OPF_subsolution+j][0] = lb;
					MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i*no_OPF_subsolution+j][1] = ub;
					MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i*no_OPF_subsolution+j][2] = 1.0 - lb - ub;
				}
			}

			break;
		case 32:		//------------ Truly Disconnected 01
		case 33:		//------------ Truly Disconnected 02
		case 34:		//------------ Truly Disconnected 03
		case 35:		//------------ Truly Disconnected 04
		case 36:		//------------ Truly Disconnected 05
		case 37:		//------------ Truly Disconnected 06
			OPF_solution = malloc(sizeof(double) * MultiObjective_TestFunction_no_Dimension);

			sprintf(OptimalParetoSolution_filename, "MultiObjective_Testfunction_TYD0%d_OptimalParetofront", testfunction_index - 31);

			ptr = fopen(OptimalParetoSolution_filename, "r");
			fscanf(ptr, "%d", &no_OPF_solution);

			ParetoFront_Info_Construction(&MultiObjective_TestFunction_OptimalParetoFront, no_OPF_solution,
										  MultiObjective_TestFunction_no_Dimension,
										  MultiObjective_TestFunction_no_Function);
			MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution = MultiObjective_TestFunction_OptimalParetoFront.Max_no_Solution;

			for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
			{
				for(j=0; j< MultiObjective_TestFunction_no_Function; ++j)
				{
					fscanf(ptr, "%lf", &f3);
					MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Fitness[i][j] = f3;
				}
			}

			free(OPF_solution);
			fclose(ptr);

			break;
	}

	//------------ Pre-set the Optimal ParetoFront Solution(s)
	for(i=0; i< MultiObjective_TestFunction_OptimalParetoFront.no_ParetoFront_Solution; ++i)
	{
		for(j=0; j< MultiObjective_TestFunction_no_Dimension; ++j)
			MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Solution[i][j] = 0.0;
		MultiObjective_TestFunction_OptimalParetoFront.ParetoFront_Rank[i] = 1;
	}

	return;
}

void MultiObjective_TestFunction_SCH(double *solution, double **fitness)
{
	(*fitness)[0] = pow(solution[0], 2);
	(*fitness)[1] = pow(solution[0] - 2, 2);

	return;
}

void MultiObjective_TestFunction_FON(double *solution, double **fitness)
{
	int i;
	double bias, sum_shifted_x1, sum_shifted_x2;

	bias = 1.0 / sqrt(3.0);

	sum_shifted_x1 = sum_shifted_x2 = 0.0;
	for(i=0; i< 3; ++i)
	{
		sum_shifted_x1 += pow(solution[i] - bias, 2);
		sum_shifted_x2 += pow(solution[i] + bias, 2);
	}

	(*fitness)[0] = 1.0 - exp(-sum_shifted_x1);
	(*fitness)[1] = 1.0 - exp(-sum_shifted_x2);

	return;
}

void MultiObjective_TestFunction_POL(double *solution, double **fitness)
{
	double A1, A2, B1, B2;

	A1 = 0.5*sin(1.0) - 2.0*cos(1.0) + sin(2.0) - 1.5*cos(2.0);
	A2 = 1.5*sin(1) - cos(1.0) + 2.0*sin(2.0) - 0.5*cos(2.0);

	B1 = 0.5*sin(solution[0]) - 2.0*cos(solution[0]) + sin(solution[1]) - 1.5*cos(solution[1]);
	B2 = 1.5*sin(solution[0]) - cos(solution[0]) + 2.0*sin(solution[1]) - 0.5*cos(solution[1]);

	(*fitness)[0] = 1.0 + pow(A1-B1,2) + pow(A2-B2,2);
	(*fitness)[1] = pow(solution[0]+3.0,2) + pow(solution[1]+1.0,2);

	return;
}

void MultiObjective_TestFunction_KUR(double *solution, double **fitness)
{
	int i;

	(*fitness)[0] = 0.0;
	for(i=0; i< MultiObjective_TestFunction_no_Dimension-1; ++i)
		(*fitness)[0] -= 10.0 * exp(-0.2*sqrt(pow(solution[i],2) + pow(solution[i+1],2)));

	(*fitness)[1] = 0.0;
	for(i=0; i< MultiObjective_TestFunction_no_Dimension; ++i)
		(*fitness)[1] += (pow(fabs(solution[i]),0.8) + 5.0*sin(pow(solution[i],3)));

	return;
}

void MultiObjective_TestFunction_ZDT1(double *solution, double **fitness)
{
	int i;
	double g;

	(*fitness)[0] = solution[0];

	g = 0.0;
	for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
		g += solution[i];
	g = 1 + 9.0 * g / (MultiObjective_TestFunction_no_Dimension-1);

	(*fitness)[1] = g * (1.0 - sqrt(solution[0] / g));

	return;
}

void MultiObjective_TestFunction_ZDT2(double *solution, double **fitness)
{
	int i;
	double g;

	(*fitness)[0] = solution[0];

	g = 0.0;
	for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
		g += solution[i];
	g = 1 + 9.0 * g / (MultiObjective_TestFunction_no_Dimension-1);

	(*fitness)[1] = g * (1.0 -pow(solution[0] / g,2));

	return;
}

void MultiObjective_TestFunction_ZDT3(double *solution, double **fitness)
{
	int i;
	double g;

	(*fitness)[0] = solution[0];

	g = 0.0;
	for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
		g += solution[i];
	g = 1 + 9.0 * g / (MultiObjective_TestFunction_no_Dimension-1);

	(*fitness)[1] = g * (1.0 - sqrt(solution[0]/g) - solution[0]*sin(10.0*PI*solution[0])/g);

	return;
}

void MultiObjective_TestFunction_ZDT4(double *solution, double **fitness)
{
	int i;
	double g;

	(*fitness)[0] = solution[0];

	g = 0.0;
	for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
		g += (pow(solution[i],2) - 10.0*cos(4.0*PI*solution[i]));
	g = 1 + 10.0*(MultiObjective_TestFunction_no_Dimension-1) + g;

	(*fitness)[1] = g * (1.0 - sqrt(solution[0]/g));

	return;
}

void MultiObjective_TestFunction_ZDT6(double *solution, double **fitness)
{
	int i;
	double g;

	(*fitness)[0] = 1.0 - exp(-4.0*solution[0])*pow(sin(4.0*PI*solution[0]),6);

	g = 0.0;
	for(i=1; i< MultiObjective_TestFunction_no_Dimension; ++i)
		g += solution[i];
	g = 1.0 + 9.0 * pow(g / (MultiObjective_TestFunction_no_Dimension-1), 0.25);

	(*fitness)[1] = g * (1.0 - pow((*fitness)[0]/g,2));

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem01(double *solution, double **fitness)
{
	int j, J1_size, J2_size;
	double sum_J1, sum_J2;

	J1_size = 0;
	sum_J1 = 0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		sum_J1 += pow(solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension),2);
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0;
	for(j=2; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		sum_J2 += pow(solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension),2);
		++J2_size;
	}

	(*fitness)[0] = solution[0] + 2.0 / J1_size * sum_J1;
	(*fitness)[1] = 1.0 - sqrt(solution[0]) + 2.0 / J2_size * sum_J2;

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem02(double *solution, double **fitness)
{
	int j, J1_size, J2_size;
	double yj;
	double sum_J1, sum_J2;

	J1_size = 0;
	sum_J1 = 0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - (0.3 * pow(solution[0],2) * cos(24.0*PI*solution[0] + 4.0*j*PI/MultiObjective_TestFunction_no_Dimension) + 0.6*solution[0]) * cos(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J1 += pow(yj,2);
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0;
	for(j=2; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - (0.3 * pow(solution[0],2) * cos(24.0*PI*solution[0] + 4.0*j*PI/MultiObjective_TestFunction_no_Dimension) + 0.6*solution[0]) * sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J2 += pow(yj,2);
		++J2_size;
	}

	(*fitness)[0] = solution[0] + 2.0 / J1_size * sum_J1;
	(*fitness)[1] = 1.0 - sqrt(solution[0]) + 2.0 / J2_size * sum_J2;

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem03(double *solution, double **fitness)
{
	int j, J1_size, J2_size;
	double yj;
	double sum_J1, sum_J2;
	double prd_J1, prd_J2;

	J1_size = 0;
	sum_J1 = 0;
	prd_J1 =1.0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - pow(solution[0], 0.5*(1.0 + 3.0*(j-2)/(MultiObjective_TestFunction_no_Dimension-2)));
		sum_J1 += pow(yj,2);
		prd_J1 *= cos(20.0*yj*PI/sqrt(j));
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0.0;
	prd_J2 = 1.0;
	for(j=2; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - pow(solution[0], 0.5*(1.0 + 3.0*(j-2)/(MultiObjective_TestFunction_no_Dimension-2)));
		sum_J2 += pow(yj,2);
		prd_J2 *= cos(20.0*yj*PI/sqrt(j));
		++J2_size;
	}

	(*fitness)[0] = solution[0] + 2.0 / J1_size * (4.0*sum_J1 - 2*prd_J1 + 2.0);
	(*fitness)[1] = 1.0 - sqrt(solution[0]) + 2.0 / J2_size * (4.0*sum_J2 - 2*prd_J2 + 2.0);

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem04(double *solution, double **fitness)
{
	int j, J1_size, J2_size;
	double yj, hj;
	double sum_J1, sum_J2;

	J1_size = 0;
	sum_J1 = 0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		hj = fabs(yj) / (1.0 + exp(2.0*fabs(yj)));
		sum_J1 += hj;
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0;
	for(j=2; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		hj = fabs(yj) / (1.0 + exp(2.0*fabs(yj)));
		sum_J2 += hj;
		++J2_size;
	}

	(*fitness)[0] = solution[0] + 2.0 / J1_size * sum_J1;
	(*fitness)[1] = 1.0 - pow(solution[0],2) + 2.0 / J2_size * sum_J2;

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem05(double *solution, double **fitness)
{
	int j, J1_size, J2_size;
	double yj, hj;
	double sum_J1, sum_J2;

	int N;
	double e;

	N = MultiObjective_TestFunction_CECUnConstrainedProblem05_N;
	e = MultiObjective_TestFunction_CECUnConstrainedProblem05_e;

	J1_size = 0;
	sum_J1 = 0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		hj = 2.0*pow(yj,2) - cos(4.0*PI*yj) + 1.0;
		sum_J1 += hj;
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0;
	for(j=2; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		hj = 2.0*pow(yj,2) - cos(4.0*PI*yj) + 1.0;
		sum_J2 += hj;
		++J2_size;
	}

	(*fitness)[0] = solution[0] + (1.0/(2.0*N) + e) * fabs(sin(2.0*N*PI*solution[0])) + 2.0 / J1_size * sum_J1;
	(*fitness)[1] = 1.0 - solution[0] + (1.0/(2.0*N) + e) * fabs(sin(2.0*N*PI*solution[0])) + 2.0 / J2_size * sum_J2;

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem06(double *solution, double **fitness)
{
	int j, J1_size, J2_size;
	double yj;
	double sum_J1, sum_J2;
	double prd_J1, prd_J2;

	int N;
	double e;

	N = MultiObjective_TestFunction_CECUnConstrainedProblem06_N;
	e = MultiObjective_TestFunction_CECUnConstrainedProblem06_e;

	J1_size = 0;
	sum_J1 = 0;
	prd_J1 =1.0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J1 += pow(yj,2);
		prd_J1 *= cos(20.0*yj*PI/sqrt(j));
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0.0;
	prd_J2 = 1.0;
	for(j=2; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J2 += pow(yj,2);
		prd_J2 *= cos(20.0*yj*PI/sqrt(j));
		++J2_size;
	}

	(*fitness)[0] = solution[0] + 2.0 / J1_size * (4.0*sum_J1 - 2*prd_J1 + 2.0);
	(*fitness)[1] = 1.0 - solution[0] + 2.0 / J2_size * (4.0*sum_J2 - 2*prd_J2 + 2.0);
	if(2.0 * (1.0/(2.0*N) + e) * sin(2.0*N*PI*solution[0]) > 0)
	{
		(*fitness)[0] += 2.0 * (1.0/(2.0*N) + e) * sin(2.0*N*PI*solution[0]);
		(*fitness)[1] += 2.0 * (1.0/(2.0*N) + e) * sin(2.0*N*PI*solution[0]);
	}

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem07(double *solution, double **fitness)
{
	int j, J1_size, J2_size;
	double yj;
	double sum_J1, sum_J2;

	J1_size = 0;
	sum_J1 = 0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J1 += pow(yj,2);
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0;
	for(j=2; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		yj = solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J2 += pow(yj,2);
		++J2_size;
	}

	(*fitness)[0] = pow(solution[0], 1.0/5.0) + 2.0 / J1_size * sum_J1;
	(*fitness)[1] = 1 - pow(solution[0], 1.0/5.0) + 2.0 / J2_size * sum_J2;

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem08(double *solution, double **fitness)
{
	int j, J1_size, J2_size, J3_size;
	double yj;
	double sum_J1, sum_J2, sum_J3;

	J1_size = 0;
	sum_J1 = 0;
	for(j=4; j <= MultiObjective_TestFunction_no_Dimension; j+=3)
	{
		yj = solution[j-1] - 2.0*solution[1]*sin(2.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J1 += pow(yj,2);
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0;
	for(j=5; j <= MultiObjective_TestFunction_no_Dimension; j+=3)
	{
		yj = solution[j-1] - 2.0*solution[1]*sin(2.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J2 += pow(yj,2);
		++J2_size;
	}

	J3_size = 0;
	sum_J3 = 0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=3)
	{
		yj = solution[j-1] - 2.0*solution[1]*sin(2.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J3 += pow(yj,2);
		++J3_size;
	}

	(*fitness)[0] = cos(0.5*solution[0]*PI) * cos(0.5*solution[1]*PI) + 2.0 / J1_size * sum_J1;
	(*fitness)[1] = cos(0.5*solution[0]*PI) * sin(0.5*solution[1]*PI) + 2.0 / J2_size * sum_J2;
	(*fitness)[2] = sin(0.5*solution[0]*PI) + 2.0 / J3_size * sum_J3;

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem09(double *solution, double **fitness)
{
	int j, J1_size, J2_size, J3_size;
	double yj, c;
	double sum_J1, sum_J2, sum_J3;

	double e;

	e = MultiObjective_TestFunction_CECUnConstrainedProblem09_e;

	J1_size = 0;
	sum_J1 = 0;
	for(j=4; j <= MultiObjective_TestFunction_no_Dimension; j+=3)
	{
		yj = solution[j-1] - 2.0*solution[1]*sin(2.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J1 += pow(yj,2);
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0;
	for(j=5; j <= MultiObjective_TestFunction_no_Dimension; j+=3)
	{
		yj = solution[j-1] - 2.0*solution[1]*sin(2.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J2 += pow(yj,2);
		++J2_size;
	}

	J3_size = 0;
	sum_J3 = 0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=3)
	{
		yj = solution[j-1] - 2.0*solution[1]*sin(2.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J3 += pow(yj,2);
		++J3_size;
	}

	c = (1.0+e) * (1.0 - 4.0*pow(2.0*solution[0]-1.0, 2));
	if(c > 0)
	{
		(*fitness)[0] = 0.5*(c + 2.0*solution[0])*solution[1] + 2.0 / J1_size * sum_J1;
		(*fitness)[1] = 0.5*(c - 2.0*solution[0] + 2.0)*solution[1] + 2.0 / J2_size * sum_J2;
	}
	else
	{
		(*fitness)[0] = 0.5* 2.0*solution[0] *solution[1] + 2.0 / J1_size * sum_J1;
		(*fitness)[1] = 0.5* (-2.0*solution[0] + 2.0) *solution[1] + 2.0 / J2_size * sum_J2;
	}

	(*fitness)[2] = 1.0 - solution[1] + 2.0 / J3_size * sum_J3;

	return;
}

void MultiObjective_TestFunction_CECUnConstrainedProblem10(double *solution, double **fitness)
{
	int j, J1_size, J2_size, J3_size;
	double yj;
	double sum_J1, sum_J2, sum_J3;

	J1_size = 0;
	sum_J1 = 0;
	for(j=4; j <= MultiObjective_TestFunction_no_Dimension; j+=3)
	{
		yj = solution[j-1] - 2.0*solution[1]*sin(2.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J1 += (4.0*pow(yj,2) - cos(8.0*PI*yj) + 1.0);
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0;
	for(j=5; j <= MultiObjective_TestFunction_no_Dimension; j+=3)
	{
		yj = solution[j-1] - 2.0*solution[1]*sin(2.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J2 += (4.0*pow(yj,2) - cos(8.0*PI*yj) + 1.0);
		++J2_size;
	}

	J3_size = 0;
	sum_J3 = 0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=3)
	{
		yj = solution[j-1] - 2.0*solution[1]*sin(2.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension);
		sum_J3 += (4.0*pow(yj,2) - cos(8.0*PI*yj) + 1.0);
		++J3_size;
	}

	(*fitness)[0] = cos(0.5*solution[0]*PI) * cos(0.5*solution[1]*PI) + 2.0 / J1_size * sum_J1;
	(*fitness)[1] = cos(0.5*solution[0]*PI) * sin(0.5*solution[1]*PI) + 2.0 / J2_size * sum_J2;
	(*fitness)[2] = sin(0.5*solution[0]*PI) + 2.0 / J3_size * sum_J3;

	return;
}

void MultiObjective_TestFunction_DTLZ1(double *solution, double **fitness)
{
	int i;
	double g;

	g = 0.0;
	for(i=2; i < MultiObjective_TestFunction_no_Dimension; ++i)
		g += (pow(solution[i]-0.5,2) - cos(20.0*PI*(solution[i]-0.5)));
	g = 100.0*(MultiObjective_TestFunction_no_Dimension-2) + 100.0*g;

	(*fitness)[0] = (1.0+g)*solution[0]*solution[1];
	(*fitness)[1] = (1.0+g)*solution[0]*(1.0-solution[1]);
	(*fitness)[2] = (1.0+g)*(1.0-solution[0]);

	return;
}

void MultiObjective_TestFunction_DTLZ2(double *solution, double **fitness)
{
	int i;
	double g;

	g = 0.0;
	for(i=2; i < MultiObjective_TestFunction_no_Dimension; ++i)
		g += pow(solution[i],2);

	(*fitness)[0] = (1.0+g)*cos(solution[0]*PI*0.5)*cos(solution[1]*PI*0.5);
	(*fitness)[1] = (1.0+g)*cos(solution[0]*PI*0.5)*sin(solution[1]*PI*0.5);
	(*fitness)[2] = (1.0+g)*sin(solution[0]*PI*0.5);

	return;
}

void MultiObjective_TestFunction_TrulyDisconnected01(double *solution, double **fitness)
{
	int j, J1_size, J2_size;
	double sum_J1, sum_J2;
	double h;

	J1_size = 0;
	sum_J1 = 0;
	for(j=3; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		sum_J1 += pow(solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension),2);
		++J1_size;
	}

	J2_size = 0;
	sum_J2 = 0;
	for(j=4; j <= MultiObjective_TestFunction_no_Dimension; j+=2)
	{
		sum_J2 += pow(solution[j-1] - sin(6.0*PI*solution[0] + j*PI/MultiObjective_TestFunction_no_Dimension),2);
		++J2_size;
	}

	h = (solution[0] + solution[1]) / 2.0;

	(*fitness)[0] = -(h + fabs(cos(h*PI/0.6))) + 2.0 / J1_size * sum_J1;
	(*fitness)[1] = -(1.0 - h + fabs(cos(h*PI/0.6))) + 2.0 / J2_size * sum_J2;

	return;
}

void MultiObjective_TestFunction_TrulyDisconnected02(double *solution, double **fitness)
{
	int j;
	double g, h;

	g = 0.0;
	for(j=1; j < MultiObjective_TestFunction_no_Dimension; ++j)
		g += pow(solution[j],2);
	g = 1.0 + 9.0*g / (MultiObjective_TestFunction_no_Dimension-1.0);

	h = solution[0];

  	(*fitness)[0] = 2.0*h + 4*sin(8.0*PI*h) + pow(g,2);
	(*fitness)[1] = 8.0*exp(-pow(h,2.0)/(2*pow(0.5,2))) + pow(g,2);

	return;
}

void MultiObjective_TestFunction_TrulyDisconnected03(double *solution, double **fitness)
{
	int j;
	double g, h;

	g = 0.0;
	for(j=1; j < MultiObjective_TestFunction_no_Dimension; ++j)
		g += solution[j];
	g = 1.0 + 9.0*g / (MultiObjective_TestFunction_no_Dimension-1.0);

	h = solution[0];

	(*fitness)[0] = 1.0*h + 2.0*sin(8.0*PI*h) + 1.0*sin(4.0*PI*h) + pow(g,2);
	(*fitness)[1] = 8.0*exp(-pow(h,2.0)/(2*pow(0.5,2))) + 4.0*exp(-pow(h-0.2,2.0)/(2*pow(0.5,2))) + pow(g,2);

	return;
}

void MultiObjective_TestFunction_TrulyDisconnected04(double *solution, double **fitness)
{
	int j;
	double g, h;

	g = 0.0;
	for(j=1; j < MultiObjective_TestFunction_no_Dimension; ++j)
		g += solution[j];
	g = 1.0 + 9.0*g / (MultiObjective_TestFunction_no_Dimension-1.0);

	h = solution[0];

  	(*fitness)[0] = -2.0*h +  pow(g,2);
	(*fitness)[1] = 2.0*h + 32.0*pow(sin(2.0*PI*h),2) +  pow(g,2);

	return;
}

void MultiObjective_TestFunction_TrulyDisconnected05(double *solution, double **fitness)
{
	int j;
	double g, x1, y;

	g = 0.0;
	for(j=1; j < MultiObjective_TestFunction_no_Dimension; ++j)
		g += solution[j];
	g = 1.0 + 9.0*g / (MultiObjective_TestFunction_no_Dimension-1.0);

	x1 = solution[0];
	y = pow(x1,0.7);

  	(*fitness)[0] = x1 + pow(g,2);
	(*fitness)[1] = exp(-y) + sin(2.0*PI*y) + pow(g,2);

	return;
}

void MultiObjective_TestFunction_TrulyDisconnected06(double *solution, double **fitness)
{
	int j;
	double g, x1, y;

	g = 0.0;
	for(j=1; j < MultiObjective_TestFunction_no_Dimension; ++j)
		g += solution[j];
	g = 1.0 + 9.0*g / (MultiObjective_TestFunction_no_Dimension-1.0);

	x1 = solution[0];
	y = log(x1);

  	(*fitness)[0] = x1 + pow(g,2);
	(*fitness)[1] = -0.5*y + sin(4.0*PI*y) + pow(g,2);

	return;
}
