#ifndef CLUSTERTREE_KERNEL

#define CLUSTERTREE_KERNEL

// * = 1-D array without fixed dimension
// ** = 2-D array without fixed dimension

struct CLUSTER_NODE {
	int ID_Self;			//The ID of the Current Node
	int ID_Parent;			//The ID of the Parent Node

	double Optimal_Fitness;	
	double *Optimal_Data;

	double no_Visit;		//No. of Visit
	int Dimension;			//Dimension Size
	double Threshold;		// <= ?

	double Survival_Rate;

	struct CLUSTER_NODE *Parent;
	struct CLUSTER_NODE *Child_Left;
	struct CLUSTER_NODE *Child_Right;

	//------------ For 'Blockader'
	int Blockader;

	//------------ For 'Local Basin'
	struct CLUSTER_NODE *Basin_Node;
};

typedef struct CLUSTER_NODE Cluster_Node;

typedef struct CLUSTER_TREE {
	int Current_ID;

	int no_Dimension;
	int no_Leaf;
	double **Interval;

	int max_Archive_Size;
	int no_AxisBoundary;
	int *AxisBoundary_Set;

	Cluster_Node *Root;
	double **cur_Interval;
} Cluster_Tree;


void Cluster_Tree_Insertion(Cluster_Tree*, double*, double, Cluster_Node**);
void Cluster_Tree_SearchInterval_Set(Cluster_Tree*);
void Cluster_Tree_Write(Cluster_Tree*, char*);
void Cluster_Tree_Construction(Cluster_Tree*, int, int, int);
void Cluster_Tree_Destruction(Cluster_Tree);

void Cluster_Node_Path(Cluster_Node*, int*, int);
void Cluster_Node_Insertion(Cluster_Node*, double**, double*, double, int*, int, int*, int**, int*);
void Cluster_Node_Interval(Cluster_Node*, Cluster_Tree*);
void Cluster_Node_Write(Cluster_Node*, double***, int, FILE*);
void Cluster_Node_Contruction(Cluster_Node*, Cluster_Node*, int);
void Cluster_Node_Destruction(Cluster_Node);

double Cluster_Node_Difference(Cluster_Node*, double*, int);

Cluster_Node *Cluster_Node_Search(Cluster_Node*, double***, double*);

#endif