/******************************************************************************************/
//	Program Name	:	Non-Revisiting Genetic Algorithm (NrGA)
//	File Name		:	NonRevisitingScheme_Kernel.c
//	Auther			:	Dr. Chow Chi Kin, Dr. Yuen Shiu Yin
//	Edit by			:	Leung Shing Wa
//	University		:	City University of Hong Kong
//	Department		:	Electronic Engineering
//	Last Update		:	10 Sep 2009
//	Reference		:	A Genetic Algorithm that Adaptively Mutates and Never Revisits, 
//						IEEE Transactions on Evolutionary Computation, 
//						Vol 13(2) (April 2009) 454-472.
//
//	Discription		:	The functions to maintain (update / use) the BSP tree can be found in this file.
#include<stdio.h>
#include<stdlib.h>
#include<stdarg.h>
#include<malloc.h>
#include<math.h>
#include<time.h>
#include"..\ACC_Math_Kernel\ACC_Math_Kernel.H"
#include"..\ClusterTree_Kernel\ClusterTree_Kernel.H"
#include"NonRevisitingScheme_Kernel.H"


/*The TreePruning fucntion, it will prune the space that is fully filled*/
void NonRevisitingScheme_TreePruning(Cluster_Node *cur_Node, int *no_Leaf, int cur_Dimension)
{
	int i;

	while (cur_Node != NULL)
	{
		++(*cur_Node).no_Visit;

		if((*cur_Node).Optimal_Fitness < (*(*cur_Node).Child_Left).Optimal_Fitness)
		{
			(*cur_Node).Optimal_Fitness = (*(*cur_Node).Child_Left).Optimal_Fitness;
			for(i=0; i< cur_Dimension; ++i)
				(*cur_Node).Optimal_Data[i] = (*(*cur_Node).Child_Left).Optimal_Data[i];
		}
		else
		{
			(*cur_Node).Optimal_Fitness = (*(*cur_Node).Child_Right).Optimal_Fitness;
			for(i=0; i< cur_Dimension; ++i)
				(*cur_Node).Optimal_Data[i] = (*(*cur_Node).Child_Right).Optimal_Data[i];
		}

		if((*(*cur_Node).Child_Left).Dimension == -2 && (*(*cur_Node).Child_Right).Dimension == -2)
		{
			--(*no_Leaf);

			free((*(*cur_Node).Child_Left).Optimal_Data);
			free((*cur_Node).Child_Left);
			free((*(*cur_Node).Child_Right).Optimal_Data);
			free((*cur_Node).Child_Right);

			(*cur_Node).Dimension = -2;			// Dimension  = -2 means it is leaf node
			(*cur_Node).Child_Left = NULL;
			(*cur_Node).Child_Right = NULL;
		}

		cur_Node = (*cur_Node).Parent;
	}

	return;
}



void NonRevisitingScheme_UnConstraint_Update(NonRevisitingScheme *cur_NRS, double *cur_Solution, double cur_Goodness)
{
	Cluster_Node *target_Node;

	if((*cur_NRS).Activate == 1 && (*(*cur_NRS).Solution_Tree.Root).Dimension != -2)
	{

		Cluster_Tree_Insertion(&(*cur_NRS).Solution_Tree, cur_Solution, cur_Goodness, &target_Node);

		NonRevisitingScheme_UnConstraint_TreePath(target_Node, (*cur_NRS).Solution_Tree.cur_Interval, &(*cur_NRS).Solution_Tree.no_Leaf, (*cur_NRS).Solution_Tree.no_Dimension);

		if((*cur_NRS).Max_no_Leaf < (*cur_NRS).Solution_Tree.no_Leaf)
			(*cur_NRS).Max_no_Leaf = (*cur_NRS).Solution_Tree.no_Leaf;
	}

	return;
}

void NonRevisitingScheme_UnConstraint_NodeSearch(double **cur_Chromosome, int no_gene, Cluster_Tree *population_Tree, Cluster_Node **cur_Node)
{
	double min_bound, max_bound;

	//============ Initialization
	Cluster_Tree_SearchInterval_Set(population_Tree);
	
	(*cur_Node) = (*population_Tree).Root;
	do {
		//============ Serach the leaf
		while ((*(*cur_Node)).Dimension > -1)
		{
			min_bound = (*population_Tree).cur_Interval[(*(*cur_Node)).Dimension][0];
			max_bound = (*population_Tree).cur_Interval[(*(*cur_Node)).Dimension][1];

			if((*cur_Chromosome)[(*(*cur_Node)).Dimension] < (*(*cur_Node)).Threshold)
			{
				(*population_Tree).cur_Interval[(*(*cur_Node)).Dimension][1] = (*(*cur_Node)).Threshold;
				(*cur_Node) = (*(*cur_Node)).Child_Left;
			}
			else
			{
				(*population_Tree).cur_Interval[(*(*cur_Node)).Dimension][0] = (*(*cur_Node)).Threshold;
				(*cur_Node) = (*(*cur_Node)).Child_Right;
			}
		}

		if((*(*cur_Node)).Dimension == -2)
		{
			//============ Mutate Gene
			if((*cur_Node) == (*(*(*cur_Node)).Parent).Child_Left)
			{
				(*cur_Chromosome)[(*(*(*cur_Node)).Parent).Dimension] = (*(*(*cur_Node)).Parent).Threshold + 0.5;

				(*population_Tree).cur_Interval[(*(*(*cur_Node)).Parent).Dimension][0] = (*(*(*cur_Node)).Parent).Threshold;
				(*population_Tree).cur_Interval[(*(*(*cur_Node)).Parent).Dimension][1] = max_bound;
				(*cur_Node) = (*(*(*cur_Node)).Parent).Child_Right;
			}
			else
			{
				(*cur_Chromosome)[(*(*(*cur_Node)).Parent).Dimension] = (*(*(*cur_Node)).Parent).Threshold - 0.5;

				(*population_Tree).cur_Interval[(*(*(*cur_Node)).Parent).Dimension][0] = min_bound;
				(*population_Tree).cur_Interval[(*(*(*cur_Node)).Parent).Dimension][1] = (*(*(*cur_Node)).Parent).Threshold;
				(*cur_Node) = (*(*(*cur_Node)).Parent).Child_Left;
			}
		}
	} while ((*(*cur_Node)).Dimension > -1);

	return;
}

void NonRevisitingScheme_UnConstraint_TreePath(Cluster_Node *leaf_Node, double **cur_Interval, int *no_Leaf, int cur_Dimension)
{
	double min_range, max_range;
	Cluster_Node *parent_Node;

	if(leaf_Node == NULL)
		return;

	parent_Node = leaf_Node;

	min_range = cur_Interval[(*parent_Node).Dimension][0];
	max_range = cur_Interval[(*parent_Node).Dimension][1];

	//============ Verify if the left child is saturated
	cur_Interval[(*parent_Node).Dimension][0] = min_range;
	cur_Interval[(*parent_Node).Dimension][1] = (*parent_Node).Threshold;
	(*(*parent_Node).Child_Left).Dimension = NonRevisitingScheme_UnConstraint_SaturateVerification(cur_Interval, cur_Dimension);

	//============ Verify if the right child is saturated
	cur_Interval[(*parent_Node).Dimension][0] = (*parent_Node).Threshold;
	cur_Interval[(*parent_Node).Dimension][1] = max_range;
	(*(*parent_Node).Child_Right).Dimension = NonRevisitingScheme_UnConstraint_SaturateVerification(cur_Interval, cur_Dimension);

	cur_Interval[(*parent_Node).Dimension][0] = min_range;
	cur_Interval[(*parent_Node).Dimension][1] = max_range;

		//============ Tree Pruning from 'parent_node'
	NonRevisitingScheme_TreePruning(parent_Node, no_Leaf, cur_Dimension);
	
	return;
}

//Function to check whether the cur_Interval is full (saturated) or not
int NonRevisitingScheme_UnConstraint_SaturateVerification(double **cur_Interval, int cur_Dimension)
{
	int i;

	for(i=0; i< cur_Dimension; ++i)
		if(cur_Interval[i][1] - cur_Interval[i][0] > 1)
			return -1;

	return -2;
}
