/******************************************************************************************/
//	Program Name	:	Non-Revisiting Genetic Algorithm (NrGA)
//	File Name		:	NonRevisitingGA_Main.c
//	Auther			:	Dr. Chow Chi Kin, Dr. Yuen Shiu Yin
//	Edit by			:	Leung Shing Wa
//	University		:	City University of Hong Kong
//	Department		:	Electronic Engineering
//	Last Update		:	10 Sep 2009
//	Reference		:	A Genetic Algorithm that Adaptively Mutates and Never Revisits, 
//						IEEE Transactions on Evolutionary Computation, 
//						Vol 13(2) (April 2009) 454-472.
//
//	Discription		:	The initization part of NrGA. Parameters can be set in this file.
#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>
#include<math.h>
#include<time.h>
#include"..\Kernel_Lib\ACC_Math_Kernel\ACC_Math_Kernel.H"
#include"..\Kernel_Lib\ClusterTree_Kernel\ClusterTree_Kernel.H"
#include"..\Kernel_Lib\GeneticAlgorithm_Kernel\GeneticAlgorithm_Kernel.H"
#include"..\Kernel_Lib\NonRevisitingScheme_Kernel\NonRevisitingScheme_Kernel.H"
#include"..\Kernel_Lib\NonRevisitingGA_Kernel\NonRevisitingGA_Kernel.H"
#include"..\Kernel_Lib\Optimization_TestFunction_Kernel\Optimization_TestFunction_Kernel.H"
#include"NonRevisitingGA_Main.H"

int main()
{
	NonRevisitingGA_Performance_Single();

	return 0;
}

void NonRevisitingGA_Performance_Single()
{
	char GA_Evaluation_Info[256];
	int no_trial, testfunction_index, axis_range;
	int optimization_mode, max_generation;
	int population_size, max_archive_size;
	time_t begin_time, end_time;
	int test_mode, activate_mode;
	double test_parameter, mutation_range;

	GA_Performance_Info cur_Performance;

	srand((unsigned) time(NULL));

	begin_time = time((unsigned) NULL);

	//============ test_mode: 0 = Fixed Generation, 1 = Fixed Accuracy
	optimization_mode = 0;
	max_generation = 400;
	no_trial = 100;
	
	//============ Customer defined parameters
	population_size = 100;

	max_archive_size = 2 * population_size * NONREVISITINGGA_MAX_GENERATION;
	mutation_range = 0.05;

	//The index of test functions. The reference index are defined in Optimization_TestFunction_Kernal.c
	testfunction_index = 7;	

	//Dimension of the Test Function
	Optimization_TestFunction_Dimension = 30;

	axis_range = 100;

	test_mode = 0; 
	activate_mode =1;   
	sprintf(GA_Evaluation_Info, "F");
	test_parameter = max_generation;

	cur_Performance = NonRevisitingGA_Performance(testfunction_index,
												  axis_range,
												  mutation_range,
												  population_size,
												  max_archive_size,
												  optimization_mode,
												  test_mode,
												  test_parameter,
												  activate_mode,
												  no_trial,
												  GA_Evaluation_Info);

	end_time = time((unsigned) NULL);	
	printf("Processing time = %d sec.\n", (int) difftime(end_time, begin_time));

	return;
}


GA_Performance_Info NonRevisitingGA_Performance(int testfunction_index, int axis_range, double mutation_range, int population_size, int max_archive_size, int optimization_mode, int test_mode, double test_parameter, int activate_mode, int no_trial, char *GA_Evaluation_Info)
{
	char NonRevisiting_GA_filename[256], testfunction_name[256];
	int full_unsuccess, t, i;
	int success_mode, no_etrial[2];
	double sum_fitness[2], sum_fitness2[2], *fitness_list[2];
	double sum_generation[2], sum_generation2[2], *generation_list[2];
	double sum_leaf[2], sum_leaf2[2], *leaf_list[2];
	double sum_time[2], sum_time2[2], *time_list[2];
	NonRevisiting_GA cur_GA;
	GA_Performance_Info cur_Performance;
	double (*GA_TESTFUNCTION)(double*);
	FILE *NonRevisiting_GA_ptr;

	Optimization_TestFunction_NoiseLevel = 0.0;
	Optimization_TestFunction_RotationMatrix_Construction();

	for(i=0; i<2; ++i)
	{
		fitness_list[i] = malloc(sizeof(double) * no_trial);
		generation_list[i] = malloc(sizeof(double) * no_trial);
		leaf_list[i] = malloc(sizeof(double) * no_trial);
		time_list[i] = malloc(sizeof(double) * no_trial);
	}
	
	Optimization_TestFunction_Manager_RealValued(testfunction_index, testfunction_name);
	GA_TESTFUNCTION = Optimization_TestFunction_Pointer;
	sprintf(NonRevisiting_GA_filename, "NonRevisiting_GA_Result_%s_%s", testfunction_name, GA_Evaluation_Info);

	NonRevisiting_GA_ptr = fopen(NonRevisiting_GA_filename, "a+");
	Optimization_TestFunction_AxisRange = axis_range;

	for(i=0; i< 2; ++i)
	{
		no_etrial[i] = 0;
		sum_fitness[i] = sum_fitness2[i] = 0.0;
		sum_generation[i] = sum_generation2[i] = 0.0;
		sum_leaf[i] = sum_leaf2[i] = 0.0;
		sum_time[i] = sum_time2[i] = 0.0;
	}

	//-------Start running
	for(t=0; t < no_trial; ++t)
	{	//Build the NrGA
		NonRevisitingGA_Construction(&cur_GA, Optimization_TestFunction_Dimension, population_size, population_size, 0.5, mutation_range, max_archive_size, activate_mode);

		for(i=0; i< Optimization_TestFunction_Dimension; ++i)
		{
			cur_GA.GA_Info.SearchSpace[i][0] = 0.0 - 0.5;
			cur_GA.GA_Info.SearchSpace[i][1] = axis_range - 0.5;
		}
		//Number of crossover points
		cur_GA.GA_Info.no_CrossOver_Point = 0;
		//Switch of NrGA and GA. NrGA: active_mode = 1, GA: active_mode = 0
		cur_GA.NRS_Info.Activate = activate_mode;

		if(activate_mode == 1)
			NonRevisitingGA_UnConstraint_Standard(&cur_GA, optimization_mode, test_mode, test_parameter, 0, GA_TESTFUNCTION);
		else
			GeneticAlgorithm_UnConstraint_Standard(&cur_GA.GA_Info, optimization_mode, test_mode, test_parameter, GA_TESTFUNCTION);

		if(t % 1 == 0)
			printf("%d %d %d %d %d = %d %1.2lf: The %dth trial ...... %d, %1.4lf %d\n", testfunction_index, test_mode, activate_mode, Optimization_TestFunction_Dimension, axis_range,
																								 test_mode, test_parameter, t,
																								 cur_GA.GA_Info.no_Generation, cur_GA.GA_Info.Optimal_Fitness, cur_GA.NRS_Info.Max_no_Leaf);
		if(cur_GA.GA_Info.no_Generation < NONREVISITINGGA_MAX_GENERATION - 1)
			success_mode = 0;
		else
			success_mode = 1;

		fitness_list[success_mode][no_etrial[success_mode]] = cur_GA.GA_Info.Optimal_Fitness;
		generation_list[success_mode][no_etrial[success_mode]] = cur_GA.GA_Info.no_Generation;
		leaf_list[success_mode][no_etrial[success_mode]] = cur_GA.NRS_Info.Max_no_Leaf;
		time_list[success_mode][no_etrial[success_mode]] = (double) cur_GA.GA_Info.Processing_Time[cur_GA.GA_Info.no_Generation-1];
		++no_etrial[success_mode];

		sum_fitness[success_mode] += cur_GA.GA_Info.Optimal_Fitness;
		sum_fitness2[success_mode] += pow(cur_GA.GA_Info.Optimal_Fitness, 2);
		
		sum_generation[success_mode] += cur_GA.GA_Info.no_Generation;
		sum_generation2[success_mode] += pow(cur_GA.GA_Info.no_Generation, 2);
		
		sum_leaf[success_mode] += cur_GA.NRS_Info.Max_no_Leaf;
		sum_leaf2[success_mode] += pow(cur_GA.NRS_Info.Max_no_Leaf, 2);
		
		sum_time[success_mode] += (double) cur_GA.GA_Info.Processing_Time[cur_GA.GA_Info.no_Generation-1];
		sum_time2[success_mode] += pow((double) cur_GA.GA_Info.Processing_Time[cur_GA.GA_Info.no_Generation-1], 2);

		NonRevisitingGA_Destruction(cur_GA);
	}

	//---------------Print out results
	for(i=0; i< 2; ++i)
	{
		full_unsuccess = 0;
		if(no_etrial[i] == 0)
		{
			no_etrial[i] = 1;
			full_unsuccess = 1;

			fitness_list[i][0] = 0.0;
			generation_list[i][0] = 0.0;
			leaf_list[i][0] = 0.0;
			time_list[i][0] = 0.0;
		}

		Sorting_UnIndexed(&fitness_list[i], no_etrial[i]);
		cur_Performance.Fitness_Median[i] = fitness_list[i][no_etrial[i]/2];
		cur_Performance.Fitness_Mean[i] = sum_fitness[i]/no_etrial[i];
		cur_Performance.Fitness_Stdev[i] = sum_fitness2[i] / no_etrial[i] - pow(cur_Performance.Fitness_Mean[i], 2);
		if(fabs(cur_Performance.Fitness_Stdev[i]) < 0.00000001)
			cur_Performance.Fitness_Stdev[i] = 0.0;
		else
			cur_Performance.Fitness_Stdev[i] = sqrt(cur_Performance.Fitness_Stdev[i]);
		cur_Performance.Fitness_Min[i] = fitness_list[i][0];
		cur_Performance.Fitness_Max[i] = fitness_list[i][no_etrial[i] - 1];
		
		Sorting_UnIndexed(&generation_list[i], no_etrial[i]);
		cur_Performance.Generation_Median[i] = generation_list[i][no_etrial[i]/2];
		cur_Performance.Generation_Mean[i] = sum_generation[i]/no_etrial[i];
		cur_Performance.Generation_Stdev[i] = sum_generation2[i] / no_etrial[i] - pow(cur_Performance.Generation_Mean[i], 2);
		if(fabs(cur_Performance.Generation_Stdev[i]) < 0.00000001)
			cur_Performance.Generation_Stdev[i] = 0.0;
		else
			cur_Performance.Generation_Stdev[i] = sqrt(cur_Performance.Generation_Stdev[i]);
		cur_Performance.Generation_Stdev[i] = sqrt(sum_generation2[i] / no_etrial[i] - pow(cur_Performance.Generation_Mean[i], 2));
		cur_Performance.Generation_Min[i] = generation_list[i][0];
		cur_Performance.Generation_Max[i] = generation_list[i][no_etrial[i] - 1];
		
		Sorting_UnIndexed(&leaf_list[i], no_etrial[i]);
		cur_Performance.Leaf_Median[i] = leaf_list[i][no_etrial[i]/2];
		cur_Performance.Leaf_Mean[i] = sum_leaf[i]/no_etrial[i];
		cur_Performance.Leaf_Stdev[i] = sum_leaf2[i] / no_etrial[i] - pow(cur_Performance.Leaf_Mean[i], 2);
		if(fabs(cur_Performance.Leaf_Stdev[i]) < 0.00000001)
			cur_Performance.Leaf_Stdev[i] = 0.0;
		else
			cur_Performance.Leaf_Stdev[i] = sqrt(cur_Performance.Leaf_Stdev[i]);
		cur_Performance.Leaf_Min[i] = leaf_list[i][0];
		cur_Performance.Leaf_Max[i] = leaf_list[i][no_etrial[i] - 1];
		
		Sorting_UnIndexed(&time_list[i], no_etrial[i]);
		cur_Performance.Time_Median[i] = time_list[i][no_etrial[i]/2];
		cur_Performance.Time_Mean[i] = sum_time[i]/no_etrial[i];
		cur_Performance.Time_Stdev[i] = sum_time2[i] / no_etrial[i] - pow(cur_Performance.Time_Mean[i], 2);
		if(fabs(cur_Performance.Time_Stdev[i]) < 0.00000001)
			cur_Performance.Time_Stdev[i] = 0.0;
		else
			cur_Performance.Time_Stdev[i] = sqrt(cur_Performance.Time_Stdev[i]);
		cur_Performance.Time_Min[i] = time_list[i][0];
		cur_Performance.Time_Max[i] = time_list[i][no_etrial[i] - 1];

		if(full_unsuccess == 1)
			no_etrial[i] = 0;

		printf("Success Mode = %d\n", i);
		printf("Optimal Fitness:\n");
		printf("Mean - %1.4lf, Stdev. - %1.4lf, Median - %1.4lf\n", cur_Performance.Fitness_Mean[i], cur_Performance.Fitness_Stdev[i], cur_Performance.Fitness_Median[i]);
		printf("No. Generation:\n");
		printf("Mean - %1.4lf, Stdev. - %1.4lf, Median - %1.4lf\n", cur_Performance.Generation_Mean[i], cur_Performance.Generation_Stdev[i], cur_Performance.Generation_Median[i]);
		printf("Max. No. Leaf:\n");
		printf("Mean - %1.4lf, Stdev. - %1.4lf, Median - %1.4lf\n", cur_Performance.Leaf_Mean[i], cur_Performance.Leaf_Stdev[i], cur_Performance.Leaf_Median[i]);

		fprintf(NonRevisiting_GA_ptr, "%d %d %d %d ", Optimization_TestFunction_Dimension, axis_range, activate_mode, i);
		fprintf(NonRevisiting_GA_ptr, "%lf %lf %lf %lf %lf ", cur_Performance.Fitness_Mean[i], cur_Performance.Fitness_Stdev[i], cur_Performance.Fitness_Median[i], cur_Performance.Fitness_Min[i], cur_Performance.Fitness_Max[i]);
		fprintf(NonRevisiting_GA_ptr, "%lf %lf %lf %lf %lf ", cur_Performance.Generation_Mean[i], cur_Performance.Generation_Stdev[i], cur_Performance.Generation_Median[i], cur_Performance.Generation_Min[i], cur_Performance.Generation_Max[i]);
		fprintf(NonRevisiting_GA_ptr, "%lf %lf %lf %lf %lf ", cur_Performance.Leaf_Mean[i], cur_Performance.Leaf_Stdev[i], cur_Performance.Leaf_Median[i], cur_Performance.Leaf_Min[i], cur_Performance.Leaf_Max[i]);
		fprintf(NonRevisiting_GA_ptr, "%lf %lf %lf %lf %lf ", cur_Performance.Time_Mean[i], cur_Performance.Time_Stdev[i], cur_Performance.Time_Median[i], cur_Performance.Time_Min[i], cur_Performance.Time_Max[i]);
		fprintf(NonRevisiting_GA_ptr, "%d %lf\n", no_etrial[i], mutation_range);
	}

	fclose(NonRevisiting_GA_ptr);

	for(i=0; i<2; ++i)
	{
		free(fitness_list[i]);
		free(generation_list[i]);
		free(leaf_list[i]);
		free(time_list[i]);
	}

	Optimization_TestFunction_RotationMatrix_Destruction();

	return cur_Performance;
}

