package onePositionInheritanceABC.CEC2008;

public class Benchmark
{
	public Benchmark(int funID, int xdim, double fbias)
	{
		this.funID = funID;
		this.xdim = xdim;
		this.fbias = fbias;
	}// constructor
	
	public double f(double[] x, double[] o)
	{
		double result = 0.0;
		
		// F1: Shifted Sphere function, unimodal
		if(funID == 1)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				result += ((x[ix] - o[ix]) * (x[ix] - o[ix]));
			}
		}
		
		// F2: Shifted Schwefel's Problem 2.21, unimodal
		if(funID == 2)
		{
			result = Math.abs(x[0] - o[0]);
			for(int ix = 1; ix < xdim; ix++)
			{
				double tmp = Math.abs(x[ix] - o[ix]);
				if(tmp > result)
				{
					result = tmp; 
				}
			}
		}
		
		// F3: Shifted Rosenbrock's Function, multimodal
		if(funID == 3)
		{
			double[] z = new double[xdim];
			for(int ix = 0; ix < xdim; ix++)
			{
				z[ix] = x[ix] - o[ix] + 1.0;
			}
			for(int ix = 0; ix < (xdim - 1); ix++)
			{
				result += (100.0 * (z[ix] * z[ix] - z[ix + 1]) * (z[ix] * z[ix] - z[ix + 1]) + 
				(z[ix] - 1.0) * (z[ix] - 1.0));
			}
		}
		
		// F4: Shifted Rastrign's Function, multimodal
		if(funID == 4)
		{
			double[] z = new double[xdim];
			for(int ix = 0; ix < xdim; ix++)
			{
				z[ix] = x[ix] - o[ix];
			}
			for(int ix = 0; ix < xdim; ix++)
			{
				result += (z[ix] * z[ix] - 10.0 * Math.cos(2.0 * Math.PI * z[ix]) + 10.0);
			}
		}
		
		// F5: Shifted Griewank's Function, multimodal
		if(funID == 5)
		{
			double[] z = new double[xdim];
			for(int ix = 0; ix < xdim; ix++)
			{
				z[ix] = x[ix] - o[ix];
			}
			double result1 = 1.0;
			double result2 = 0.0;
			for(int ix = 0; ix < xdim; ix++)
			{
				result1 = result * Math.cos(z[ix] / Math.sqrt((double)ix + 1.0));
				result2 = result2 + z[ix] * z[ix] / 4000.0;
			}
			result = result2 - result1 + 1.0;
		}
		
		// F6: Shifted Ackley's Function, multimodal
		if(funID == 6)
		{
			double[] z = new double[xdim];
			for(int ix = 0; ix < xdim; ix++)
			{
				z[ix] = x[ix] - o[ix];
			}
			double result1 = 0.0;
			double result2 = 0.0;
			for(int ix = 0; ix < xdim; ix++)
			{
				result1 += z[ix] * z[ix];
				result2 += Math.cos(2.0 * Math.PI * z[ix]);
			}
			result = 20.0 - 20.0 * Math.exp(-0.2 * Math.sqrt(result1 / xdim))
					- Math.exp(result2 / xdim) + Math.exp(1.0);
		}
		
		// F7: FastFractal "DoubleDip", multimodal
		if(funID == 7)
		{
			try
			{
				FastFractal ff = new FastFractal("onePositionInheritanceABC.CEC2008.DoubleDip", 3, 1, 1l, xdim);
				result = ff.evaluate(x);
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		
		return (result + fbias);
	}// f

	private int funID;
	private int xdim;
	private double fbias;
}// Benchmark
