package onePositionInheritanceABC.CEC2008;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Random;

public class OPIABCCEC2008
{
	/**
	 * class constructor
	 * @param xdim
	 * @param funID
	 * @param np
	 * @param foodNumber
	 * @param isrotate
	 * @param om
	 */
	public OPIABCCEC2008(int funID, int xdim, int foodNumber, int limit, double fbias, long seed) throws Exception
	{
		this.xdim = xdim;
		this.funID = funID;
		this.foodNumber = foodNumber;
		this.limit = limit;
		// shift array data o is 1000*1 except F7
		getShiftData();
		func = new Benchmark(this.funID, xdim, fbias);
		xlb = new double[this.xdim];
		xub = new double[this.xdim];
		getXdomain();
		generator = new Random(seed);
		initializeFirstGeneration();
		prob = new double[this.foodNumber];
	}// constructor
	
	/**
	 * initialize food sources
	 */
	private void initializeFirstGeneration()
	{
		// assign memory for the arrays
		foods = new double[foodNumber][xdim];
		f = new double[foodNumber];
		fitness = new double[foodNumber];
		trial = new int[foodNumber];
		
		// initialize the arrays
		for(int irow = 0; irow < foodNumber; irow++)
		{
			for(int jcol = 0; jcol < xdim; jcol++)
			{
				foods[irow][jcol] = xlb[jcol] + (xub[jcol] - xlb[jcol]) * generator.nextDouble();
			}
			// evaluate function value and fitness 
			f[irow] = func.f(foods[irow], o);
			fitness[irow] = calculateFitness(f[irow]);
			trial[irow] = 0;
		}
		
		// find the best solution in initialization
		xbest = new double[xdim];
		fbest = f[0];
		xbestidx = 0;
		memorizeBestSource();
	}// initializeGeneration
	
	/**
	 * calculate fitness associated with a function value
	 * this fitness function is a strictly decreasing function, and suppose
	 * the optimization is a minimization problem
	 * @param ffood = function value of a food source
	 * @return fitness of foods
	 */
	private double calculateFitness(double ffood)
	{
		double result = 0.0;
		if(ffood >= 0.0)
		{
			result = 1.0 / (ffood + 1.0);
		}
		else
		{
			result = 1.0 + Math.abs(ffood);
		}
		return result;
	}// calculateFitness
	
	/**
	 * find the best solution in current population
	 */
	private void memorizeBestSource()
	{
		for(int irow = 0; irow < foodNumber; irow++)
		{
			if(f[irow] < fbest)
			{
				fbest = f[irow];
				xbestidx = irow;
			}
		}
		System.arraycopy(foods[xbestidx], 0, xbest, 0, xdim);
	}// memorizeBestSource
	
	/**
	 * main evolution loop of OPIABC algorithm for CEC 2008 test set
	 * @param iloop for storing best-so-far function value
	 * @param totalEval
	 * @param fbias 
	 * @throws Exception
	 */
	public void mainOPIABCCEC2008Loop(int iloop, int totalEval, double fbias) throws Exception
	{
		// ========== store best-so-far function value in each generation ===========
		String filename = "OPIABCCEC2008f" + Integer.toString(funID) + "D" + Integer.toString(xdim) + "run" + Integer.toString((iloop + 1)) + ".txt";
		FileWriter writer = new FileWriter(filename, true);
		PrintWriter out = new PrintWriter(writer);
		// ========== store best-so-far function value in each generation ===========
		
		// loop for each generation
		int evalCount = foodNumber;
		while(evalCount < totalEval)
		{
			out.println(evalCount + " " + (fbest - fbias));
			
			// send out employed bees
			int itmp = 0; // a tmp integer variable 
			itmp = sendEmployedBees();
			// count function evaluations
			evalCount += itmp;
			
			// calculate probability of each food source associated with employed bee
			calculateProbabilities();
			// send out onlooker bees
			itmp = sendOnlookerBees();
			// count function evaluations
			evalCount += itmp;
			
			// send out scout bee for exploration
			itmp = sendScoutBees();
			evalCount += itmp;
			
			// find best-to-far function value
			memorizeBestSource();
		}// while
		
		// find best-to-far function value for returning the best found function value
		memorizeBestSource();

		// only for count fitness improved times
		out.println(evalCount + " " + (fbest - fbias));
		// close file
		out.flush();
		out.close();
		writer.close();

		// compute error between fbest and the global optimum
		fbest = fbest - fbias;
	}// mainOPIABCCEC2008Loop
	
	/**
	 * send out employed bees for exploitation
	 */
	private int sendEmployedBees()
	{
		// count evaluations in sendEmployedBees
		int result = 0;
		
		for(int irow = 0; irow < foodNumber; irow++)
		{
			// the parameter to be changed is determined randomly
			int param2change = generator.nextInt(xdim);
			
			// get 1 index which are different with irow within interval 0:foodNumber-1
			int rirow = 0;
			do
			{
				rirow = generator.nextInt(foodNumber);
			} while(rirow == irow);
			// initialize solution to parent
			double[] solution = new double[xdim];
			System.arraycopy(foods[irow], 0, solution, 0, xdim);

			// =================== one-position inheritance ====================
			// inherit one component from another selected parent (rirow2)
			int rirow2 = 0;
			do
			{
				rirow2 = generator.nextInt(foodNumber);
			} while(rirow2 == irow);
			int param2inherit = 0;
			do
			{
				param2inherit = generator.nextInt(xdim);
			} while(param2inherit == param2change);
			solution[param2inherit] = foods[rirow2][param2inherit];
			// =================== one-position inheritance ====================
			
			// generate a new candidate solution
			solution[param2change] = foods[irow][param2change] + 
			(foods[irow][param2change] - foods[rirow][param2change]) * (generator.nextDouble() - 0.5) * 2;
			
			// check feasibility
			if(solution[param2change] < xlb[param2change])
			{
				solution[param2change] = xlb[param2change];
			}
			if(solution[param2change] > xub[param2change])
			{
				solution[param2change] = xub[param2change];
			}
			
			double objValSol = func.f(solution, o);
			// count evaluation
			result += 1;
			double fitnessSol = calculateFitness(objValSol);
			
			// greedy selection is applied between the current solution irow and its mutant solution
			if(fitnessSol > fitness[irow])
			{
				// if the mutant solution is better, then replace the irow solution
				trial[irow] = 0;
				System.arraycopy(solution, 0, foods[irow], 0, xdim);
				f[irow] = objValSol;
				fitness[irow] = fitnessSol;
			}
			else
			{
				// if the mutant solution is worse, then increase its trial counter
				trial[irow] += 1;
			}
			
		}// for irow
		
		return result;
	}// sendEmployedBees
	
	/**
	 * a food source is chosen with the probability which is proportional to its quality
	 * different schemes can be used to calculate the probability values
	 */
	private void calculateProbabilities()
	{
		// first, find the maximal fitness of foods
		double maxfitness = fitness[0];
		for(int irow = 0; irow < foodNumber; irow++)
		{
			if(fitness[irow] > maxfitness)
			{
				maxfitness = fitness[irow];
			}
		}
		// second, calculate probabilities
		for(int irow = 0; irow < foodNumber; irow++)
		{
			prob[irow] = (0.9 * (fitness[irow] / maxfitness)) + 0.1;
		}
	}// calculateProbabilites
	
	/**
	 * send out onlooker bees
	 * @return
	 */
	private int sendOnlookerBees()
	{
		int result = 0; // count evaluations used in onlooker bee phase
		
		int irow = 0; // count how many onlooker bee send out
		int jcol = 0; // count prob
		// onlooker bee phase
		while(irow < foodNumber)
		{
			// choose a food source depending on its probability to be chosen
			if(generator.nextDouble() < prob[jcol])
			{
				// an onlooker bee send out, irow add 1
				irow++;
				
				// the parameter to be changed is determined randomly
				int param2change = generator.nextInt(xdim);
				// get 1 index that is different with jcol
				int rjcol = 0;
				do
				{
					rjcol = generator.nextInt(foodNumber);
				} while(rjcol == jcol);
				// initialize solution to foods[jcol] 
				double[] solution = new double[xdim];
				System.arraycopy(foods[jcol], 0, solution, 0, xdim);
				
				// random search neighbor at param2change component
				solution[param2change] = foods[jcol][param2change] + 
				(foods[jcol][param2change] - foods[rjcol][param2change]) * (generator.nextDouble() - 0.5) * 2;
				
				// check feasibility
				if(solution[param2change] < xlb[param2change])
				{
					solution[param2change] = xlb[param2change];
				}
				if(solution[param2change] > xub[param2change])
				{
					solution[param2change] = xub[param2change];
				}
				
				// evaluate mutant solution
				double objValSol = func.f(solution, o);
				// evaluation coult add 1
				result += 1;
				// calculate fitness of mutant solution
				double fitnessSol = calculateFitness(objValSol);
				
				// greedy selection is applied between the current solution jcol and its mutant solution
				if(fitnessSol > fitness[jcol])
				{
					// the mutant solution is better, then replace the jcol solution with mutant solution
					trial[jcol] = 0;
					System.arraycopy(solution, 0, foods[jcol], 0, xdim);
					f[jcol] = objValSol;
					fitness[jcol] = fitnessSol;
				}
				else
				{
					// mutant solution is worse, then increase its trial counter
					trial[jcol] = trial[jcol] + 1;
				}// if
			}// if
			
			// add prob index
			jcol++;
			if(jcol == (foodNumber - 1))
			{
				// restart from the beginning, if jcol reaches foodNumber
				jcol = 0;
			}
			
		}// while irow
		
		return result;
	}// sendOnlookerBees
	
	/**
	 * send out scout bees
	 * @return
	 */
	private int sendScoutBees()
	{
		int result = 0; // count evaluations used in sendScoutBees
		
		for(int irow = 0; irow < foodNumber; irow++)
		{
			if(trial[irow] > limit)
			{
				// re-generate a new food source for scout bee
				for(int ix = 0; ix < xdim; ix++)
				{
					foods[irow][ix] = xlb[ix] + (xub[ix] - xlb[ix]) * generator.nextDouble();
				}
				// evaluate function value and fitness
				f[irow] = func.f(foods[irow], o);
				// evaluation count add 1
				result += 1;
				fitness[irow] = calculateFitness(f[irow]);
				trial[irow] = 0;
			}
		}
		
		return result;
	}// sendScoutBees
	
	/**
	 * get domain of x based on funID
	 */
	private void getXdomain()
	{
		if(funID == 1)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}
		else if(funID == 2)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}
		else if(funID == 3)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}
		else if(funID == 4)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -5.0;
				xub[ix] = 5.0;
			}
		}
		else if(funID == 5)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -600.0;
				xub[ix] = 600.0;
			}
		}
		else if(funID == 6)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -32.0;
				xub[ix] = 32.0;
			}
		}
		else if(funID == 7)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -1.0;
				xub[ix] = 1.0;
			}
		}
		else
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}// if
	}// getXdomain

	/**
	 * read shift array data from txt files based on funID
	 * @throws Exception
	 */
	private void getShiftData() throws Exception
	{
		o = new double[1000];
		
		BufferedReader br;
		if(funID == 1)
		{
			br = new BufferedReader(new FileReader("shiftDataCEC2008/sphere_shift_func_data.txt"));
		}
		else if(funID == 2)
		{
			br = new BufferedReader(new FileReader("shiftDataCEC2008/schwefel_shift_func_data.txt"));
		}
		else if(funID == 3)
		{
			br = new BufferedReader(new FileReader("shiftDataCEC2008/rosenbrock_shift_func_data.txt"));
		}
		else if(funID == 4)
		{
			br = new BufferedReader(new FileReader("shiftDataCEC2008/rastrigin_shift_func_data.txt"));
		}
		else if(funID == 5)
		{
			br = new BufferedReader(new FileReader("shiftDataCEC2008/griewank_shift_func_data.txt"));
		}
		else if(funID == 6)
		{
			br = new BufferedReader(new FileReader("shiftDataCEC2008/ackley_shift_func_data.txt"));
		}
		else if(funID == 7)
		{
			br = new BufferedReader(new FileReader("shiftDataCEC2008/fastfractal_doubledip_data.txt"));
		}
		else
		{
			br = new BufferedReader(new FileReader("shiftDataCEC2008/sphere_shift_func_data.txt"));
			System.out.println("Warning: cannot read shift array data!");
		}
		
		String str = "";
		if(funID == 7)
		{
			str = br.readLine();
			o[0] = Double.parseDouble(str);
		}
		else
		{
			for(int irow = 0; irow < 1000; irow++)
			{
				str = br.readLine();
				o[irow] = Double.parseDouble(str);
			}
		}// if
		
		br.close();
	}// getShiftData
	
	/**
	 * @return return the best fitness (function) value 
	 */
	public double getMinFitness()
	{
		return fbest;
	}
	
	/**
	 * @return return the best-so-far solution
	 */
	public double[] getOptSolution()
	{
		return xbest;
	}
	
	private int xdim;
	private int funID;
	private int foodNumber; // number of food sources
	private int limit; // max trial number that fails to improve fitness in a food source
	private double[] o = null;
	private Benchmark func = null;
	private double[] xlb = null; // lower bound of food sources
	private double[] xub = null; // upper bound of food sources
	private double[][] foods = null; // population of food sources. size = foodNumber * xdim
	private double[] f = null; // store objective function values associated with foods
	private double[] fitness = null; // store fitness values associated with foods
	private int[] trial = null; // store trial numbers through which solutions cannot be improved
	private double[] prob = null; // store probabilities of foods to be chosen
	private double fbest; // optimal function value obtained by ABC algorithm
	private double[] xbest = null; // optimal bee obtained by ABC algorithm
	private int xbestidx;
	private Random generator = null;

}// OPIABCCEC2008
