package onePositionInheritanceABC.CEC2008;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;

/**
 * Copyright (c) 2013 City University of Hong Kong
 * @author Shiu Yin Yuen (Kelvin) and Xin Zhang (Mark)
 * kelviny.ee@cityu.edu.hk; xinzhang9-c@my.cityu.edu.hk
 * http://www.ee.cityu.edu.hk/~syyuen/Public/Code.html/
 * 
 * GNU LESSER GENERAL PUBLIC LICENSE (Version 3.0, 29 June 2007)
 */
public class OPIABCCEC2008Test
{
	/**
	 * test OPIABC algorithm on CEC 2008 test set (large scale)
	 * @param args not used 
	 * @throws Exception lazy for not writing try/catch code
	 */
	public static void main(String[] args) throws Exception
	{
		FileWriter writer = new FileWriter("OPIABCCEC2008D100.txt", true);
		PrintWriter out = new PrintWriter(writer);
		
		// load random seed so that all test algorithms are initialized with the same seed
		BufferedReader br1 = new BufferedReader(new FileReader("randSeed.txt"));
		String str1 = "";
		Long[] seeds = new Long[100];
		for(int irow = 0; irow < seeds.length; irow++)
		{
			str1 = br1.readLine();
			seeds[irow] = Long.parseLong(str1);
		}
		br1.close();
		
		// CEC2008 contains 7 minimization functions, currently
		for(int ifun = 1; ifun <= 7; ifun++)
		{
			// number of independent runs for average performance
			int loopForAverage = 25;
			double[] minFitness = new double[loopForAverage];
			
			int funID = ifun; // fitness function identity
			int xdim = 100; // dimension of x
			int totalEval = 5000 * xdim;
			double[] fbias = {-450.0, -450.0, 390.0, -330.0, -180.0, -140.0, 0.0};
			int np = 100; // number of colony size (employed bees + onlooker bees)
			int foodNumber = np / 2; // number of food sources equals the half of the population size
			int limit = 100; // a food source which could not be improved through "limit" trials is abandoned by its employed bee
	
			out.println("xdim = " + xdim + ", totalE = " + totalEval + ", foodNumber = " + foodNumber + ", limit = " + limit + ", runs = " + loopForAverage);

			long startTime = System.currentTimeMillis();
			double totalTime = 0.0;
				
			for(int iloop = 0; iloop < loopForAverage; iloop++)
			{
				// ==================== test OPIABC on CEC 2008 test set =======================
				OPIABCCEC2008 opiabc = new OPIABCCEC2008(funID, xdim, foodNumber, limit, fbias[funID - 1], seeds[iloop]);
				opiabc.mainOPIABCCEC2008Loop(iloop, totalEval, fbias[funID - 1]);
					
				minFitness[iloop] = opiabc.getMinFitness();
				// ==================== test OPIABC on CEC 2008 test set =======================
			}// for iloop

			long endTime = System.currentTimeMillis();
			totalTime = ((endTime - startTime)/1000.0);
			System.out.println("Running time(seconds): " + totalTime);
			double meanMinFit = mean(minFitness);
			double stdMinFit = std(minFitness, meanMinFit);
			// output result to txt
			out.println("Running time(seconds): " + totalTime);
			out.println("Function: " + funID + " best fitness found = " );
			for(int irow = 0; irow < loopForAverage; irow++)
			{
				out.print(minFitness[irow] + "  ");
			}
			out.println("");
			out.println("Average Min Fitness = " + meanMinFit);
			out.println("Std of Min Fitness = " + stdMinFit);
			// output result to screen
			System.out.println("Average Min Fitness = " + meanMinFit);
			System.out.println("Std of Min Fitness = " + stdMinFit);
			out.flush();
		}// for ifun
		
		// close file
		out.close();
		writer.close();
	}// main

	/**
	 * compute arithmetic mean of an double array
	 * @param a an double array
	 * @return
	 */
	public static double mean(double[] a)
	{
		double asum = 0.0;
		for(int ia = 0; ia < a.length; ia++)
		{
			asum = asum + a[ia];
		}
		return asum / a.length;
	}

	/**
	 * compute standard deviation of an double array given the mean of the array
	 * @param a
	 * @param meanFit
	 * @return
	 */
	public static double std(double[] a, double meanFit)
	{
		double asum = 0.0;
		for(int ia = 0; ia < a.length; ia++)
		{
			asum = asum + (a[ia] - meanFit) * (a[ia] - meanFit);
		}
		
		return Math.sqrt(asum / a.length);
	}

}// OPIABCCEC2008Test
