package onePositionInheritanceABC;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Random;

public class OPIABC
{
	/**
	 * class constructor
	 * @param xdim
	 * @param funID
	 * @param foodNumber
	 * @param limit
	 * @param seed
	 * @param isrotate
	 * @param om
	 */
	public OPIABC(int xdim, int funID, int foodNumber, int limit, long seed, int isrotate, double[][] om)
	{
		this.xdim = xdim;
		this.funID = funID;
		this.foodNumber = foodNumber;
		this.limit = limit;
		xlb = new double[this.xdim];
		xub = new double[this.xdim];
		getXdomain();
		generator = new Random(seed);
		fitnessFunc = new FitnessFunction(this.xdim);
		initializeFirstGeneration(isrotate, om);
		prob = new double[this.foodNumber];
		successEvaluation = 0; 
		issuccess = 0;
	}// constructor
	
	/**
	 * initialize a population of feasible solutions
	 * @param isrotate
	 * @param om
	 */
	private void initializeFirstGeneration(int isrotate, double[][] om)
	{
		// assign memory for the arrays
		foods = new double[foodNumber][xdim];
		f = new double[foodNumber];
		fitness = new double[foodNumber];
		trial = new int[foodNumber];
		
		// initialize the arrays
		for(int irow = 0; irow < foodNumber; irow++)
		{
			for(int jcol = 0; jcol < xdim; jcol++)
			{
				foods[irow][jcol] = xlb[jcol] + (xub[jcol] - xlb[jcol]) * generator.nextDouble();
			}
			// evaluate function value and fitness 
			fitnessFunc.computeFitness(funID, foods[irow], isrotate, om);
			f[irow] = fitnessFunc.getFitness();
			fitness[irow] = calculateFitness(f[irow]);
			trial[irow] = 0;
		}
		
		// find the best solution in initialization
		xbest = new double[xdim];
		fbest = f[0];
		xbestidx = 0;
		memorizeBestSource();
	}// initializeFirstGeneration
	
	/**
	 * calculate fitness associated with a function value
	 * this fitness function is a strictly decreasing function, and suppose
	 * the optimization is a minimization problem
	 * @param ffood = function value of a food source
	 * @return fitness of foods
	 */
	private double calculateFitness(double ffood)
	{
		double result = 0.0;
		if(ffood >= 0.0)
		{
			result = 1.0 / (ffood + 1.0);
		}
		else
		{
			result = 1.0 + Math.abs(ffood);
		}
		return result;
	}// calculateFitness
	
	/**
	 * find the best solution in the population and save in xbest 
	 */
	private void memorizeBestSource()
	{
		for(int irow = 0; irow < foodNumber; irow++)
		{
			if(f[irow] < fbest)
			{
				fbest = f[irow];
				xbestidx = irow;
			}
		}
		System.arraycopy(foods[xbestidx], 0, xbest, 0, xdim);
	}// memorizeBestSource
	
	/**
	 * main evolution loop of OPIABC algorithm
	 * @param iloop for storing best-so-far function value
	 * @param loopforaverage for storing best-so-far function value
	 * @param totalEval
	 * @param isrotate
	 * @param om
	 * @throws Exception
	 */
	public void mainOPIABCLoop(int iloop, int loopforaverage, int totalEval, int isrotate, double[][] om) throws Exception
	{
		successEvaluation = totalEval;
		
		// ========== store best-so-far function value in each generation ===========
		String filename = "OPIABCNoRotf" + Integer.toString(funID) + "D" + Integer.toString(xdim) + "run" + Integer.toString((iloop + 1)) + ".txt";
		FileWriter writer1 = new FileWriter(filename, true);
		PrintWriter out1 = new PrintWriter(writer1);
		if(iloop == 0)
		{
			out1.println(totalEval + "  " + foodNumber + "  " + loopforaverage);
		}
		// ========== store best-so-far function value in each generation ===========
		
		// loop for each generation
		int evalCount = foodNumber;
		double vtr = getValueToReach(isrotate);
		int isvtrreached = 0;
		while(evalCount < totalEval)
		{
			if(fbest <= vtr && isvtrreached == 0)
			{
				// successfully reach the predefined accuracy, then note down evaluations used
				isvtrreached = 1;
				successEvaluation = evalCount;
				issuccess = 1;
			}
			
			// store best-so-far function value and population diversity in each generation
			double D = calculatePositionDiversity();
			out1.println(evalCount + " " + fbest + " " + Double.toString(D));
			
			// send out employed bees
			int itmp = 0; // a tmp integer variable 
			itmp = sendEmployedBees(isrotate, om);
			// count function evaluations
			evalCount += itmp;
			
			// calculate probability of each food source associated with employed bee
			calculateProbabilities();
			// send out onlooker bees
			itmp = sendOnlookerBees(isrotate, om);
			// count function evaluations
			evalCount += itmp;
			
			// send out scout bee for exploration
			itmp = sendScoutBees(isrotate, om);
			evalCount += itmp;
			
			// find best-to-far function value
			memorizeBestSource();
		}// while
		
		// find best-to-far function value for returning the best found function value
		memorizeBestSource();

		// if not reached vtr, then count total evaluations used
		if(isvtrreached == 0)
		{
			successEvaluation = evalCount;
		}

		// store best-so-far function value and population diversity in each generation
		double D = calculatePositionDiversity();
		out1.println(evalCount + " " + fbest + " " + Double.toString(D));
		// close file
		out1.flush();
		out1.close();
		writer1.close();
	}// mainOPIABCLoop
	
	/**
	 * calculate dimension-wise population position diversity
	 * @return 
	 */
	private double calculatePositionDiversity()
	{
		double result = 0.0;
		
		// first, calculate the mean of each dimension of population
		double[] popumean = new double[xdim];
		for(int ix = 0; ix < xdim; ix++)
		{
			popumean[ix] = 0.0;
			for(int inp = 0; inp < foodNumber; inp++)
			{
				popumean[ix] += foods[inp][ix];
			}
			popumean[ix] /= ((double) foodNumber);
		}
		// second, calculate the Euclidean distance of each column with respect to popumean
		double[] div = new double[xdim];
		for(int ix = 0; ix < xdim; ix++)
		{
			div[ix] = 0.0;
			for(int inp = 0; inp < foodNumber; inp++)
			{
				div[ix] += (foods[inp][ix] - popumean[ix]) * (foods[inp][ix] - popumean[ix]);
			}
			div[ix] /= ((double) foodNumber);
		}
		// sum of distance of all dimensions 
		for(int ix = 0; ix < xdim; ix++)
		{
			result += div[ix];
		}
		
		return result;
	}// calculatePositionDiversity
	
	/**
	 * send out employed bees for exploitation
	 * @param isrotate
	 * @param om
	 */
	private int sendEmployedBees(int isrotate, double[][] om)
	{
		// count evaluations in sendEmployedBees
		int result = 0;

		for(int irow = 0; irow < foodNumber; irow++)
		{
			// the parameter to be changed is determined randomly
			int param2change = generator.nextInt(xdim);
			
			// get 1 index which are different with irow within interval 0:foodNumber-1
			int rirow = 0;
			do
			{
				rirow = generator.nextInt(foodNumber);
			} while(rirow == irow);
			// initialize solution to parent
			double[] solution = new double[xdim];
			System.arraycopy(foods[irow], 0, solution, 0, xdim);

			// =================== one-position inheritance ====================
			// inherit one component from another selected parent (rirow2)
			int rirow2 = 0;
			do
			{
				rirow2 = generator.nextInt(foodNumber);
			} while(rirow2 == irow);
			int param2inherit = 0;
			do
			{
				param2inherit = generator.nextInt(xdim);
			} while(param2inherit == param2change);
			solution[param2inherit] = foods[rirow2][param2inherit];
			// =================== one-position inheritance ====================
			
//			// =================== two-position inheritance ====================
//			// inherit from one parent (rirow2)
//			int param2inherit2;
//			do
//			{
//				param2inherit2 = generator.nextInt(xdim);
//			} while(param2inherit2 == param2change || param2inherit2 == param2inherit);
//			solution[param2inherit2] = foods[rirow2][param2inherit2]; // inherit from one parent

//			// inherit from two different parents
//			int rirow3 = 0; // inherit from two different parents
//			do
//			{
//				rirow3 = generator.nextInt(foodNumber);
//			} while(rirow3 == rirow2 || rirow3 == rirow);
//			int param2inherit2;
//			do
//			{
//				param2inherit2 = generator.nextInt(xdim);
//			} while(param2inherit2 == param2change || param2inherit2 == param2inherit);
//			solution[param2inherit2] = foods[rirow3][param2inherit2]; // inherit from two different parents
//			// =================== two-position inheritance ====================
			
			// generate a new candidate solution
			solution[param2change] = foods[irow][param2change] + 
			(foods[irow][param2change] - foods[rirow][param2change]) * (generator.nextDouble() - 0.5) * 2;
			
			// check feasibility
			if(solution[param2change] < xlb[param2change])
			{
				solution[param2change] = xlb[param2change];
			}
			if(solution[param2change] > xub[param2change])
			{
				solution[param2change] = xub[param2change];
			}
			
			fitnessFunc.computeFitness(funID, solution, isrotate, om);
			double objValSol = fitnessFunc.getFitness();
			// count evaluation
			result += 1;
			double fitnessSol = calculateFitness(objValSol);
			
			// greedy selection is applied between the current solution irow and its mutant solution
			if(fitnessSol > fitness[irow])
			{
				// if the mutant solution is better, then replace the irow solution
				trial[irow] = 0;
				System.arraycopy(solution, 0, foods[irow], 0, xdim);
				f[irow] = objValSol;
				fitness[irow] = fitnessSol;
			}
			else
			{
				// if the mutant solution is worse, then increase its trial counter
				trial[irow] += 1;
			}
			
		}// for irow
		
		return result;
	}// sendEmployedBees
	
	/**
	 * a food source is chosen with the probability which is proportional to its quality
	 * different schemes can be used to calculate the probability values
	 */
	private void calculateProbabilities()
	{
		// first, find the maximal fitness of foods
		double maxfitness = fitness[0];
		for(int irow = 0; irow < foodNumber; irow++)
		{
			if(fitness[irow] > maxfitness)
			{
				maxfitness = fitness[irow];
			}
		}
		// second, calculate probabilities
		for(int irow = 0; irow < foodNumber; irow++)
		{
			prob[irow] = (0.9 * (fitness[irow] / maxfitness)) + 0.1;
		}
	}// calculateProbabilites
	
	/**
	 * send out onlooker bees
	 * @param isrotate
	 * @param om
	 * @return
	 */
	private int sendOnlookerBees(int isrotate, double[][] om)
	{
		int result = 0; // count evaluations used in onlooker bee phase
		
		int irow = 0; // count how many onlooker bee send out
		int jcol = 0; // count prob
		// onlooker bee phase
		while(irow < foodNumber)
		{
			// choose a food source depending on its associated probability to be chosen
			if(generator.nextDouble() < prob[jcol])
			{
				// an onlooker bee send out, irow add 1
				irow++;
				
				// the parameter to be changed is determined randomly
				int param2change = generator.nextInt(xdim);
				// get 1 index that is different with jcol within 0:foodNumber-1
				int rjcol = 0;
				do
				{
					rjcol = generator.nextInt(foodNumber);
				} while(rjcol == jcol);
				
				// initialize solution to foods[jcol] 
				double[] solution = new double[xdim];
				System.arraycopy(foods[jcol], 0, solution, 0, xdim);
				// random search neighbor at param2change component
				solution[param2change] = foods[jcol][param2change] + 
				(foods[jcol][param2change] - foods[rjcol][param2change]) * (generator.nextDouble() - 0.5) * 2;
				
				// check feasibility
				if(solution[param2change] < xlb[param2change])
				{
					solution[param2change] = xlb[param2change];
				}
				if(solution[param2change] > xub[param2change])
				{
					solution[param2change] = xub[param2change];
				}
				
				// evaluate mutant solution
				fitnessFunc.computeFitness(funID, solution, isrotate, om);
				double objValSol = fitnessFunc.getFitness();
				// evaluation coult add 1
				result += 1;
				// calculate fitness of mutant solution
				double fitnessSol = calculateFitness(objValSol);
				
				// greedy selection is applied between the current solution jcol and its mutant solution
				if(fitnessSol > fitness[jcol])
				{
					// the mutant solution is better, then replace the jcol solution with mutant solution
					trial[jcol] = 0;
					System.arraycopy(solution, 0, foods[jcol], 0, xdim);
					f[jcol] = objValSol;
					fitness[jcol] = fitnessSol;
				}
				else
				{
					// mutant solution is worse, then increase its trial counter
					trial[jcol] = trial[jcol] + 1;
				}// if
			}// if
			
			// add prob index
			jcol++;
			if(jcol == (foodNumber - 1))
			{
				// restart from the beginning, if jcol reaches foodNumber
				jcol = 0;
			}
			
		}// while irow
		
		return result;
	}// sendOnlookerBees
	
	/**
	 * send out scout bees
	 * @param isrotate
	 * @param om
	 * @return
	 */
	private int sendScoutBees(int isrotate, double[][] om)
	{
		int result = 0; // count evaluations used in sendScoutBees
		
		for(int irow = 0; irow < foodNumber; irow++)
		{
			if(trial[irow] > limit)
			{
				// re-generate a new food source for scout bee
				for(int ix = 0; ix < xdim; ix++)
				{
					foods[irow][ix] = xlb[ix] + (xub[ix] - xlb[ix]) * generator.nextDouble();
				}
				// evaluate function value and fitness
				fitnessFunc.computeFitness(funID, foods[irow], isrotate, om);
				f[irow] = fitnessFunc.getFitness();
				// evaluation count add 1
				result += 1;
				fitness[irow] = calculateFitness(f[irow]);
				trial[irow] = 0;
			}
		}
		
		return result;
	}// sendScoutBees
	
	/**
	 * get value to reach according to funID
	 * @return
	 */
	private double getValueToReach(int isrotate)
	{
		double vtr = -Double.MAX_VALUE;
		
		// if rotation is used, can not be sure that global minimum is still the same
		if(isrotate == 1)
		{
			return vtr;
		}
		
		if(funID == 1)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 2)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 3)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 4)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 5)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 6)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 7)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 8)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 9 && xdim == 30)
		{
			vtr = -12569.4866181730;
		}
		else if(funID == 9)
		{
			vtr = -418.9829 * xdim + 1.0E-6;
		}
		
		if(funID == 10)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 11)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 12)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 13)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 14)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 15)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 16)
		{
			vtr = -xdim + 1.0 + 1.0E-6;
		}
		
		if(funID == 17)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 19)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 20)
		{
			vtr = 0.9 + 1.0E-6;
		}
		
		if(funID == 21)
		{
			vtr = 1.0E-6;
		}
		
		if(funID == 23)
		{
			vtr = -3.5 + 1.0E-6;
		}
		
		if(funID == 25)
		{
			vtr = 1.0E-6;
		}
		
		return vtr;
	}// getValueToReach
	
	/**
	 * get domain of independent vector x according to function ID
	 */
	private void getXdomain()
	{
		if(funID == 1)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}
		
		if(funID == 2)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -10.0;
				xub[ix] = 10.0;
			}
		}
		
		if(funID == 3)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}
		
		if(funID == 4)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}
		
		if(funID == 5)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -29;
				xub[ix] = 31;
			}
		}
		
		if(funID == 6)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -1.28;
				xub[ix] = 1.28;
			}
		}
		
		if(funID == 7)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -5.12;
				xub[ix] = 5.12;
			}
		}
		
		if(funID == 8)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -600.0;
				xub[ix] = 600.0;
			}
		}
		
		if(funID == 9)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -500.0;
				xub[ix] = 500.0;
			}
		}
		
		if(funID == 10)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -32.0;
				xub[ix] = 32.0;
			}
		}
		
		if(funID == 11)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -0.5;
				xub[ix] = 0.5;
			}
		}
		
		if(funID == 12)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -10.0;
				xub[ix] = 10.0;
			}
		}
		
		if(funID == 13)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -5.0;
				xub[ix] = 10.0;
			}
		}
		
		if(funID == 14)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -10.0;
				xub[ix] = 10.0;
			}
		}
		
		if(funID == 15)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}
		
		if(funID == 16)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -5.0;
				xub[ix] = 5.0;
			}
		}
		
		if(funID == 17)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -1.0;
				xub[ix] = 1.0;
			}
		}
		
		if(funID == 18)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = 0.0;
				xub[ix] = Math.PI;
			}
		}
		
		if(funID == 19)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -5.0;
				xub[ix] = 5.0;
			}
		}
		
		if(funID == 20)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -10.0;
				xub[ix] = 10.0;
			}
		}
		
		if(funID == 21)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}
		
		if(funID == 22)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -10.0;
				xub[ix] = 10.0;
			}
		}
		
		if(funID == 23)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = 0.0;
				xub[ix] = 180.0;
			}
		}
		
		if(funID == 24)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = 0.0;
				xub[ix] = Math.PI;
			}
		}
		
		if(funID == 25)
		{
			for(int ix = 0; ix < xdim; ix++)
			{
				xlb[ix] = -100.0;
				xub[ix] = 100.0;
			}
		}
		
		if(funID < 1 || funID > 25)
		{
			throw new IllegalArgumentException("Unexpected fitness function ID!");
		}
		
	}// getXdomain
	
	/**
	 * @return return the best fitness (function) value
	 */
	public double getMinFitness()
	{
		return fbest;
	}
	
	/**
	 * @return return the best-so-far solution
	 */
	public double[] getOptSolution()
	{
		return xbest;
	}
	
	/**
	 * @return return the number of function evaluations to reach predefined accuracy
	 */
	public double getSuccessEvaluation()
	{
		return (double)successEvaluation;
	}
	
	/**
	 * @return return issuccess, 0 for unsuccess, 1 for success
	 */
	public int getIsSuccess()
	{
		return issuccess;
	}
	
	private int xdim;
	private int funID;
	private int foodNumber; // number of food sources
	private int limit; // max trial number that fails to improve fitness in a food source
	private double[] xlb = null; // lower bound of food sources
	private double[] xub = null; // upper bound of food sources
	private double[][] foods = null; // population of food sources. size = foodNumber * xdim
	private double[] f = null; // store objective function values associated with foods
	private double[] fitness = null; // store fitness values associated with foods
	private int[] trial = null; // store trial numbers through which solutions cannot be improved
	private double[] prob = null; // store probabilities of foods to be chosen
	private double fbest; // optimal function value obtained by ABC algorithm
	private double[] xbest = null; // optimal bee obtained by ABC algorithm
	private int xbestidx;
	private Random generator = null;
	private FitnessFunction fitnessFunc = null;
	private int successEvaluation;
	private int issuccess;

}
