package onePositionInheritanceABC;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;

/**
 * Copyright (c) 2013 City University of Hong Kong
 * @author Shiu Yin Yuen (Kelvin) and Xin Zhang (Mark)
 * kelviny.ee@cityu.edu.hk; xinzhang9-c@my.cityu.edu.hk
 * http://www.ee.cityu.edu.hk/~syyuen/Public/Code.html/
 * 
 * GNU LESSER GENERAL PUBLIC LICENSE (Version 3.0, 29 June 2007)
 */
public class OPIABCTest
{
	/**
	 * test artificial bee colony (ABC) algorithm with one-position inheritance mechanism
	 * so called OPIABC algorithm
	 * @param args
	 * @throws Exception lazy for not writing try/catch code
	 */
	public static void main(String[] args) throws Exception
	{
		FileWriter writer;
		writer = new FileWriter("OPIABCNoRotD30.txt", true);
		PrintWriter out = new PrintWriter(writer);
		
		// load random seed so that all test algorithms are initialized with the same seed
		BufferedReader br1 = new BufferedReader(new FileReader("randSeed.txt"));
		String str1 = "";
		Long[] seeds = new Long[100];
		for(int irow = 0; irow < seeds.length; irow++)
		{
			str1 = br1.readLine();
			seeds[irow] = Long.parseLong(str1);
		}
		br1.close();
		
		// x dimensions
		for(int idim = 30; idim <= 30; idim += 10)
		{
			System.out.println("xdim = " + idim);
			for(int ifun = 1; ifun <= 25; ifun++)
			{
				int isrotate = 0; // 0 for no rotation, 1 for with rotation
				// arrays record results for analysis
				int loopForAverage = 30; // number of independent runs for robustness
				double[] minFitness = new double[loopForAverage];
				double[] successEvaluation = new double[loopForAverage];
				
				// problem specific variables
				int xdim = idim; // number of dimensions (xdim >= 2)
				int funID = ifun;// fitness function identity
				int totalEval = 5000 * xdim;// total number of function evaluations
				
				// control parameters of ABC algorithm
				int np = 100; // number of colony size (employed bees + onlooker bees)
				int foodNumber = np / 2; // number of food sources equals the half of the population size
				int limit = 100; // a food source which could not be improved through "limit" trials is abandoned by its employed bee
				
				out.println("xdim = " + xdim + ", totalE = " + totalEval + ", foodNumber = " + foodNumber + ", limit = " + limit + ", runs = " + loopForAverage);
				
				// om stores rotation matrix
				double[][] om = new double[xdim][xdim];
				if(isrotate == 1)
				{
					BufferedReader br;
					// you may need to change the absolute file path below for running on your computer
					if(xdim == 30)
					{
						br = new BufferedReader(new FileReader(
						"C:\\myJavaProgram\\OPIABC\\src\\orthogonalMatrix\\orthogonalMatrix30.txt"));
					}
					else if(xdim == 40)
					{
						br = new BufferedReader(new FileReader(
						"C:\\myJavaProgram\\OPIABC\\src\\orthogonalMatrix\\orthogonalMatrix40.txt"));
					}
					else
					{
						throw new IllegalArgumentException("pass a wrong xdim!");
					}
					String str = "";
					for(int irow = 0; irow < xdim; irow++)
					{
						for(int jcol = 0; jcol < xdim; jcol++)
						{
							str = br.readLine();
							om[irow][jcol] = Double.parseDouble(str);
						}
					}
					br.close();
				}// if
				
				long startTime = System.currentTimeMillis();
				
				double successCount = 0.0; // count number of success out of loopForAverage runs
				double successECount = 0.0; // count success evaluations
				for(int iloop = 0; iloop < loopForAverage; iloop++)
				{
					// ======================== test OPIABC  ========================
					OPIABC opiabc = new OPIABC(xdim, funID, foodNumber, limit, seeds[iloop], isrotate, om);
					opiabc.mainOPIABCLoop(iloop, loopForAverage, totalEval, isrotate, om);
					
					minFitness[iloop] = opiabc.getMinFitness();
					successEvaluation[iloop] = opiabc.getSuccessEvaluation();
					if(opiabc.getIsSuccess() == 1)
					{
						successCount += 1.0;
						successECount += successEvaluation[iloop];
					}
					// ======================== test OPIABC  ========================
				}// for iloop
				
				long endTime = System.currentTimeMillis();
				double totalTime = (endTime - startTime) / 1000.0;
				System.out.println("Running time (s): " + totalTime);
				double meanMinFit = mean(minFitness);
				double stdMinFit = std(minFitness, meanMinFit);
				double meanSuccessEvaluation = mean(successEvaluation);
				// output result to txt
				out.println("Running time (s): " + totalTime);
				out.println("Function: " + funID + " FEs used = ");
				for(int irow = 0; irow < loopForAverage; irow++)
				{
					out.print(successEvaluation[irow] + "  ");
				}
				out.println("");
				out.println("Function: " + funID + " best fitness found = " );
				for(int irow = 0; irow < loopForAverage; irow++)
				{
					out.print(minFitness[irow] + "  ");
				}
				out.println("");
				out.println("Average Min Fitness = " + meanMinFit);
				out.println("Std of Min Fitness = " + stdMinFit);
				out.println("mean evaluations of all runs = " + meanSuccessEvaluation);
				double successRate = (successCount / (double)loopForAverage);
				double successFC = (successECount / successCount);
				double successPerformance = successFC / successRate;
				// output result to file
				out.println("success rate = " + successRate);
				out.println("mean evaluations of success runs = " + successFC);
				out.println("success performance = " + successPerformance);
				// output result to screen
				System.out.println("Average Min Fitness = " + meanMinFit);
				System.out.println("Std of Min Fitness = " + stdMinFit);
				System.out.println("mean evaluations of all runs = " + meanSuccessEvaluation);
				out.flush();
			}// for ifun
		}// for idim
		
		out.close();
		writer.close();
	}// main
	
	/**
	 * compute mean value of an double array
	 * @param a
	 * @return mean of the array
	 */
	public static double mean(double[] a)
	{
		double asum = 0.0;
		for(int ia = 0; ia < a.length; ia++)
		{
			asum = asum + a[ia];
		}
		return asum / a.length;
	}
	
	/**
	 * compute standard deviation of an double array given the mean of the array
	 * @param a
	 * @param meanFit
	 * @return standard deviation of the array
	 */
	public static double std(double[] a, double meanFit)
	{
		double asum = 0.0;
		for(int ia = 0; ia < a.length; ia++)
		{
			asum = asum + (a[ia] - meanFit) * (a[ia] - meanFit);
		}
		
		return Math.sqrt(asum / a.length);
	}

}
